/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImplWrapper;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;

public class OpenSSLSocketFactoryImpl
extends SSLSocketFactory {
    public SSLParameters sslParameters;
    public IOException instantiationException;

    public OpenSSLSocketFactoryImpl() {
        try {
            this.sslParameters = SSLParameters.getDefault();
        }
        catch (KeyManagementException e) {
            this.instantiationException = new IOException("Delayed instantiation exception:");
            this.instantiationException.initCause(e);
        }
    }

    public OpenSSLSocketFactoryImpl(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
    }

    public String[] getDefaultCipherSuites() {
        return OpenSSLSocketImpl.nativegetsupportedciphersuites();
    }

    public String[] getSupportedCipherSuites() {
        return OpenSSLSocketImpl.nativegetsupportedciphersuites();
    }

    public Socket createSocket() throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new OpenSSLSocketImpl((SSLParameters)this.sslParameters.clone());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new OpenSSLSocketImpl(host, port, (SSLParameters)this.sslParameters.clone());
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return new OpenSSLSocketImpl(host, port, localHost, localPort, (SSLParameters)this.sslParameters.clone());
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return new OpenSSLSocketImpl(host, port, (SSLParameters)this.sslParameters.clone());
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new OpenSSLSocketImpl(address, port, localAddress, localPort, (SSLParameters)this.sslParameters.clone());
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return new OpenSSLSocketImplWrapper(s, host, port, autoClose, (SSLParameters)this.sslParameters.clone());
    }
}

