/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionContext
implements SSLSessionContext {
    public volatile int maximumSize;
    public volatile int timeout;
    public final SSLParameters parameters;
    public static final int OPEN_SSL = 1;

    public AbstractSessionContext(SSLParameters parameters, int maximumSize, int timeout) {
        this.parameters = parameters;
        this.maximumSize = maximumSize;
        this.timeout = timeout;
    }

    public abstract Iterator<SSLSession> sessionIterator();

    public Enumeration getIds() {
        final Iterator<SSLSession> iterator = this.sessionIterator();
        return new Enumeration<byte[]>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public byte[] nextElement() {
                return ((SSLSession)iterator.next()).getId();
            }
        };
    }

    @Override
    public int getSessionCacheSize() {
        return this.maximumSize;
    }

    @Override
    public int getSessionTimeout() {
        return this.timeout;
    }

    public abstract void trimToSize();

    @Override
    public void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        int oldMaximum = this.maximumSize;
        this.maximumSize = size;
        if (size < oldMaximum) {
            this.trimToSize();
        }
    }

    public byte[] toBytes(SSLSession session) {
        if (!(session instanceof OpenSSLSessionImpl)) {
            return null;
        }
        OpenSSLSessionImpl sslSession = (OpenSSLSessionImpl)session;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream daos = new DataOutputStream(baos);
            daos.writeInt(1);
            byte[] data = sslSession.getEncoded();
            daos.writeInt(data.length);
            daos.write(data);
            X509Certificate[] certs = session.getPeerCertificateChain();
            daos.writeInt(certs.length);
            for (X509Certificate cert : certs) {
                data = cert.getEncoded();
                daos.writeInt(data.length);
                daos.write(data);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            AbstractSessionContext.log(e);
            return null;
        }
        catch (CertificateEncodingException e) {
            AbstractSessionContext.log(e);
            return null;
        }
    }

    public SSLSession toSession(byte[] data, String host, int port) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dais = new DataInputStream(bais);
        try {
            int type = dais.readInt();
            if (type != 1) {
                AbstractSessionContext.log((Throwable)((Object)new AssertionError((Object)("Unexpected type ID: " + type))));
                return null;
            }
            int length = dais.readInt();
            byte[] sessionData = new byte[length];
            dais.readFully(sessionData);
            int count = dais.readInt();
            X509Certificate[] certs = new X509Certificate[count];
            for (int i = 0; i < count; ++i) {
                length = dais.readInt();
                byte[] certData = new byte[length];
                dais.readFully(certData);
                certs[i] = X509Certificate.getInstance(certData);
            }
            return new OpenSSLSessionImpl(sessionData, this.parameters, host, port, certs, this);
        }
        catch (IOException e) {
            AbstractSessionContext.log(e);
            return null;
        }
        catch (CertificateException e) {
            AbstractSessionContext.log(e);
            return null;
        }
    }

    public static void log(Throwable t) {
        Logger.global.log(Level.WARNING, "Error converting session.", t);
    }

    public static class ByteArray {
        public final byte[] bytes;

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public boolean equals(Object o) {
            ByteArray other = (ByteArray)o;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

