/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import org.apache.harmony.security.asn1.ASN1BitString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BitString;
import org.apache.harmony.security.utils.Array;
import org.apache.harmony.security.x509.AlgorithmIdentifier;
import org.apache.harmony.security.x509.TBSCertificate;

public class Certificate {
    public final TBSCertificate tbsCertificate;
    public final AlgorithmIdentifier signatureAlgorithm;
    public final byte[] signatureValue;
    public byte[] encoding;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{TBSCertificate.ASN1, AlgorithmIdentifier.ASN1, ASN1BitString.getInstance()}){

        public Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            return new Certificate((TBSCertificate)values[0], (AlgorithmIdentifier)values[1], ((BitString)values[2]).bytes, in.getEncoded(), null);
        }

        public void getValues(Object object, Object[] values) {
            Certificate cert = (Certificate)object;
            values[0] = cert.tbsCertificate;
            values[1] = cert.signatureAlgorithm;
            values[2] = new BitString(cert.signatureValue, 0);
        }
    };

    public Certificate(TBSCertificate tbsCertificate, AlgorithmIdentifier signatureAlgorithm, byte[] signatureValue) {
        this.tbsCertificate = tbsCertificate;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureValue = new byte[signatureValue.length];
        System.arraycopy(signatureValue, 0, this.signatureValue, 0, signatureValue.length);
    }

    public Certificate(TBSCertificate tbsCertificate, AlgorithmIdentifier signatureAlgorithm, byte[] signatureValue, byte[] encoding) {
        this(tbsCertificate, signatureAlgorithm, signatureValue);
        this.encoding = encoding;
    }

    public TBSCertificate getTbsCertificate() {
        return this.tbsCertificate;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public byte[] getSignatureValue() {
        byte[] result = new byte[this.signatureValue.length];
        System.arraycopy(this.signatureValue, 0, result, 0, this.signatureValue.length);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("X.509 Certificate:\n[\n");
        this.tbsCertificate.dumpValue(buffer);
        buffer.append("\n  Algorithm: [");
        this.signatureAlgorithm.dumpValue(buffer);
        buffer.append(']');
        buffer.append("\n  Signature Value:\n");
        buffer.append(Array.toString(this.signatureValue, ""));
        buffer.append(']');
        return buffer.toString();
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public /* synthetic */ Certificate(TBSCertificate x0, AlgorithmIdentifier x1, byte[] x2, byte[] x3, 1 x4) {
        this(x0, x1, x2, x3);
    }
}

