/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;

public class VerticalTextSpinner
extends View {
    public static final int SELECTOR_ARROW_HEIGHT = 15;
    public static final int TEXT_SPACING = 18;
    public static final int TEXT_MARGIN_RIGHT = 25;
    public static final int TEXT_SIZE = 22;
    public static final int TEXT1_Y = -18;
    public static final int TEXT2_Y = 22;
    public static final int TEXT3_Y = 62;
    public static final int TEXT4_Y = 102;
    public static final int TEXT5_Y = 142;
    public static final int SCROLL_MODE_NONE = 0;
    public static final int SCROLL_MODE_UP = 1;
    public static final int SCROLL_MODE_DOWN = 2;
    public static final long DEFAULT_SCROLL_INTERVAL_MS = 400L;
    public static final int SCROLL_DISTANCE = 40;
    public static final int MIN_ANIMATIONS = 4;
    public final Drawable mBackgroundFocused;
    public final Drawable mSelectorFocused;
    public final Drawable mSelectorNormal;
    public final int mSelectorDefaultY;
    public final int mSelectorMinY;
    public final int mSelectorMaxY;
    public final int mSelectorHeight;
    public final TextPaint mTextPaintDark;
    public final TextPaint mTextPaintLight;
    public int mSelectorY;
    public Drawable mSelector;
    public int mDownY;
    public boolean isDraggingSelector;
    public int mScrollMode;
    public long mScrollInterval;
    public boolean mIsAnimationRunning;
    public boolean mStopAnimation;
    public boolean mWrapAround = true;
    public int mTotalAnimatedDistance;
    public int mNumberOfAnimations;
    public long mDelayBetweenAnimations;
    public int mDistanceOfEachAnimation;
    public String[] mTextList;
    public int mCurrentSelectedPos;
    public OnChangedListener mListener;
    public String mText1;
    public String mText2;
    public String mText3;
    public String mText4;
    public String mText5;

    public VerticalTextSpinner(Context context) {
        this(context, null);
    }

    public VerticalTextSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalTextSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mBackgroundFocused = context.getResources().getDrawable(17301975);
        this.mSelectorFocused = context.getResources().getDrawable(17301976);
        this.mSelectorNormal = context.getResources().getDrawable(17301977);
        this.mSelectorHeight = this.mSelectorFocused.getIntrinsicHeight();
        this.mSelectorDefaultY = (this.mBackgroundFocused.getIntrinsicHeight() - this.mSelectorHeight) / 2;
        this.mSelectorMinY = 0;
        this.mSelectorMaxY = this.mBackgroundFocused.getIntrinsicHeight() - this.mSelectorHeight;
        this.mSelector = this.mSelectorNormal;
        this.mSelectorY = this.mSelectorDefaultY;
        this.mTextPaintDark = new TextPaint(1);
        this.mTextPaintDark.setTextSize(22.0f);
        this.mTextPaintDark.setColor(context.getResources().getColor(17170435));
        this.mTextPaintLight = new TextPaint(1);
        this.mTextPaintLight.setTextSize(22.0f);
        this.mTextPaintLight.setColor(context.getResources().getColor(17170437));
        this.mScrollMode = 0;
        this.mScrollInterval = 400L;
        this.calculateAnimationValues();
    }

    public void setOnChangeListener(OnChangedListener listener) {
        this.mListener = listener;
    }

    public void setItems(String[] textList) {
        this.mTextList = textList;
        this.calculateTextPositions();
    }

    public void setSelectedPos(int selectedPos) {
        this.mCurrentSelectedPos = selectedPos;
        this.calculateTextPositions();
        this.postInvalidate();
    }

    public void setScrollInterval(long interval) {
        this.mScrollInterval = interval;
        this.calculateAnimationValues();
    }

    public void setWrapAround(boolean wrap) {
        this.mWrapAround = wrap;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 19 && this.canScrollDown()) {
            this.mScrollMode = 2;
            this.scroll();
            this.mStopAnimation = true;
            return true;
        }
        if (keyCode == 20 && this.canScrollUp()) {
            this.mScrollMode = 1;
            this.scroll();
            this.mStopAnimation = true;
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean canScrollDown() {
        return this.mCurrentSelectedPos > 0 || this.mWrapAround;
    }

    public boolean canScrollUp() {
        return this.mCurrentSelectedPos < this.mTextList.length - 1 || this.mWrapAround;
    }

    public void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus) {
            this.setBackgroundDrawable(this.mBackgroundFocused);
            this.mSelector = this.mSelectorFocused;
        } else {
            this.setBackgroundDrawable(null);
            this.mSelector = this.mSelectorNormal;
            this.mSelectorY = this.mSelectorDefaultY;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        int y = (int)event.getY();
        switch (action) {
            case 0: {
                this.requestFocus();
                this.mDownY = y;
                this.isDraggingSelector = y >= this.mSelectorY && y <= this.mSelectorY + this.mSelector.getIntrinsicHeight();
                break;
            }
            case 2: {
                if (!this.isDraggingSelector) break;
                int top = this.mSelectorDefaultY + (y - this.mDownY);
                if (top <= this.mSelectorMinY && this.canScrollDown()) {
                    this.mSelectorY = this.mSelectorMinY;
                    this.mStopAnimation = false;
                    if (this.mScrollMode == 2) break;
                    this.mScrollMode = 2;
                    this.scroll();
                    break;
                }
                if (top >= this.mSelectorMaxY && this.canScrollUp()) {
                    this.mSelectorY = this.mSelectorMaxY;
                    this.mStopAnimation = false;
                    if (this.mScrollMode == 1) break;
                    this.mScrollMode = 1;
                    this.scroll();
                    break;
                }
                this.mSelectorY = top;
                this.mStopAnimation = true;
                break;
            }
            default: {
                this.mSelectorY = this.mSelectorDefaultY;
                this.mStopAnimation = true;
                this.invalidate();
            }
        }
        return true;
    }

    public void onDraw(Canvas canvas) {
        boolean selectorLeft = false;
        int selectorTop = this.mSelectorY;
        int selectorRight = this.mMeasuredWidth;
        int selectorBottom = this.mSelectorY + this.mSelectorHeight;
        this.mSelector.setBounds(0, selectorTop, selectorRight, selectorBottom);
        this.mSelector.draw(canvas);
        if (this.mTextList == null) {
            return;
        }
        TextPaint textPaintDark = this.mTextPaintDark;
        if (this.hasFocus()) {
            boolean topLeft = false;
            boolean topTop = false;
            int topRight = selectorRight;
            int topBottom = selectorTop + 15;
            String text1 = this.mText1;
            String text2 = this.mText2;
            String text3 = this.mText3;
            String text4 = this.mText4;
            String text5 = this.mText5;
            TextPaint textPaintLight = this.mTextPaintLight;
            canvas.save();
            canvas.clipRect(0, 0, topRight, topBottom);
            this.drawText(canvas, text1, -18 + this.mTotalAnimatedDistance, textPaintLight);
            this.drawText(canvas, text2, 22 + this.mTotalAnimatedDistance, textPaintLight);
            this.drawText(canvas, text3, 62 + this.mTotalAnimatedDistance, textPaintLight);
            canvas.restore();
            canvas.save();
            canvas.clipRect(0, selectorTop + 15, selectorRight, selectorBottom - 15);
            this.drawText(canvas, text2, 22 + this.mTotalAnimatedDistance, textPaintDark);
            this.drawText(canvas, text3, 62 + this.mTotalAnimatedDistance, textPaintDark);
            this.drawText(canvas, text4, 102 + this.mTotalAnimatedDistance, textPaintDark);
            canvas.restore();
            boolean bottomLeft = false;
            int bottomTop = selectorBottom - 15;
            int bottomRight = selectorRight;
            int bottomBottom = this.mMeasuredHeight;
            canvas.save();
            canvas.clipRect(0, bottomTop, bottomRight, bottomBottom);
            this.drawText(canvas, text3, 62 + this.mTotalAnimatedDistance, textPaintLight);
            this.drawText(canvas, text4, 102 + this.mTotalAnimatedDistance, textPaintLight);
            this.drawText(canvas, text5, 142 + this.mTotalAnimatedDistance, textPaintLight);
            canvas.restore();
        } else {
            this.drawText(canvas, this.mText3, 62, textPaintDark);
        }
        if (this.mIsAnimationRunning) {
            if (Math.abs(this.mTotalAnimatedDistance) + this.mDistanceOfEachAnimation > 40) {
                int newPos;
                int oldPos;
                this.mTotalAnimatedDistance = 0;
                if (this.mScrollMode == 1) {
                    oldPos = this.mCurrentSelectedPos;
                    newPos = this.getNewIndex(1);
                    if (newPos >= 0) {
                        this.mCurrentSelectedPos = newPos;
                        if (this.mListener != null) {
                            this.mListener.onChanged(this, oldPos, this.mCurrentSelectedPos, this.mTextList);
                        }
                    }
                    if (newPos < 0 || newPos >= this.mTextList.length - 1 && !this.mWrapAround) {
                        this.mStopAnimation = true;
                    }
                    this.calculateTextPositions();
                } else if (this.mScrollMode == 2) {
                    oldPos = this.mCurrentSelectedPos;
                    newPos = this.getNewIndex(-1);
                    if (newPos >= 0) {
                        this.mCurrentSelectedPos = newPos;
                        if (this.mListener != null) {
                            this.mListener.onChanged(this, oldPos, this.mCurrentSelectedPos, this.mTextList);
                        }
                    }
                    if (newPos < 0 || newPos == 0 && !this.mWrapAround) {
                        this.mStopAnimation = true;
                    }
                    this.calculateTextPositions();
                }
                if (this.mStopAnimation) {
                    int previousScrollMode = this.mScrollMode;
                    this.mIsAnimationRunning = false;
                    this.mStopAnimation = false;
                    this.mScrollMode = 0;
                    if ("".equals(this.mTextList[this.mCurrentSelectedPos])) {
                        this.mScrollMode = previousScrollMode;
                        this.scroll();
                        this.mStopAnimation = true;
                    }
                }
            } else if (this.mScrollMode == 1) {
                this.mTotalAnimatedDistance -= this.mDistanceOfEachAnimation;
            } else if (this.mScrollMode == 2) {
                this.mTotalAnimatedDistance += this.mDistanceOfEachAnimation;
            }
            if (this.mDelayBetweenAnimations > 0L) {
                this.postInvalidateDelayed(this.mDelayBetweenAnimations);
            } else {
                this.invalidate();
            }
        }
    }

    public void calculateTextPositions() {
        this.mText1 = this.getTextToDraw(-2);
        this.mText2 = this.getTextToDraw(-1);
        this.mText3 = this.getTextToDraw(0);
        this.mText4 = this.getTextToDraw(1);
        this.mText5 = this.getTextToDraw(2);
    }

    public String getTextToDraw(int offset) {
        int index = this.getNewIndex(offset);
        if (index < 0) {
            return "";
        }
        return this.mTextList[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNewIndex(int offset) {
        int index = this.mCurrentSelectedPos + offset;
        if (index < 0) {
            if (!this.mWrapAround) return -1;
            index += this.mTextList.length;
            return index;
        } else {
            if (index < this.mTextList.length) return index;
            if (!this.mWrapAround) return -1;
            index -= this.mTextList.length;
        }
        return index;
    }

    public void scroll() {
        if (this.mIsAnimationRunning) {
            return;
        }
        this.mTotalAnimatedDistance = 0;
        this.mIsAnimationRunning = true;
        this.invalidate();
    }

    public void calculateAnimationValues() {
        this.mNumberOfAnimations = (int)this.mScrollInterval / 40;
        if (this.mNumberOfAnimations < 4) {
            this.mNumberOfAnimations = 4;
            this.mDistanceOfEachAnimation = 40 / this.mNumberOfAnimations;
            this.mDelayBetweenAnimations = 0L;
        } else {
            this.mDistanceOfEachAnimation = 40 / this.mNumberOfAnimations;
            this.mDelayBetweenAnimations = this.mScrollInterval / (long)this.mNumberOfAnimations;
        }
    }

    public void drawText(Canvas canvas, String text, int y, TextPaint paint) {
        int width = (int)paint.measureText(text);
        int x = this.getMeasuredWidth() - width - 25;
        canvas.drawText(text, x, y, paint);
    }

    public int getCurrentSelectedPos() {
        return this.mCurrentSelectedPos;
    }

    public static interface OnChangedListener {
        public void onChanged(VerticalTextSpinner var1, int var2, int var3, String[] var4);
    }
}

