/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Parcel;
import android.telephony.PhoneNumberUtils;
import android.telephony.SmsMessage;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GsmSmsAddress;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class SmsMessage
extends SmsMessageBase {
    public static final String LOG_TAG = "GSM";
    public SmsMessage.MessageClass messageClass;
    public int mti;
    public int protocolIdentifier;
    public int dataCodingScheme;
    public boolean replyPathPresent = false;
    public boolean automaticDeletion;
    public boolean forSubmit;
    public GsmSmsAddress recipientAddress;
    public long dischargeTimeMillis;
    public int status;
    public boolean isStatusReportMessage = false;

    public static SmsMessage createFromPdu(byte[] pdu) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static SmsMessage newFromCMT(String[] lines) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(IccUtils.hexStringToBytes(lines[1]));
            return msg;
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static SmsMessage newFromCMTI(String line) {
        Log.e(LOG_TAG, "newFromCMTI: not yet supported");
        return null;
    }

    public static SmsMessage newFromCDS(String line) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.parsePdu(IccUtils.hexStringToBytes(line));
            return msg;
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "CDS SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static SmsMessageBase newFromParcel(Parcel p) {
        Log.w(LOG_TAG, "newFromParcel: is not supported in GSM mode.");
        return null;
    }

    public static SmsMessage createFromEfRecord(int index, byte[] data) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.indexOnIcc = index;
            if ((data[0] & 1) == 0) {
                Log.w(LOG_TAG, "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            msg.statusOnIcc = data[0] & 7;
            int size = data.length - 1;
            byte[] pdu = new byte[size];
            System.arraycopy(data, 1, pdu, 0, size);
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    public static int getTPLayerLengthForPDU(String pdu) {
        int len = pdu.length() / 2;
        int smscLen = 0;
        smscLen = Integer.parseInt(pdu.substring(0, 2), 16);
        return len - smscLen - 1;
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested, byte[] header) {
        if (message == null || destinationAddress == null) {
            return null;
        }
        SubmitPdu ret = new SubmitPdu();
        byte mtiByte = (byte)(1 | (header != null ? 64 : 0));
        ByteArrayOutputStream bo = SmsMessage.getSubmitPduHead(scAddress, destinationAddress, mtiByte, statusReportRequested, ret);
        try {
            byte[] userData = GsmAlphabet.stringToGsm7BitPackedWithHeader(message, header);
            if ((0xFF & userData[0]) > 160) {
                return null;
            }
            bo.write(0);
            bo.write(userData, 0, userData.length);
        }
        catch (EncodeException ex) {
            byte[] userData;
            byte[] textPart;
            try {
                textPart = message.getBytes("utf-16be");
            }
            catch (UnsupportedEncodingException uex) {
                Log.e(LOG_TAG, "Implausible UnsupportedEncodingException ", uex);
                return null;
            }
            if (header != null) {
                userData = new byte[header.length + textPart.length + 1];
                userData[0] = (byte)header.length;
                System.arraycopy(header, 0, userData, 1, header.length);
                System.arraycopy(textPart, 0, userData, header.length + 1, textPart.length);
            } else {
                userData = textPart;
            }
            if (userData.length > 140) {
                return null;
            }
            bo.write(11);
            bo.write(userData.length);
            bo.write(userData, 0, userData.length);
        }
        ret.encodedMessage = bo.toByteArray();
        return ret;
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested) {
        return SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, null);
    }

    public static SubmitPdu getSubmitPdu(String scAddress, String destinationAddress, short destinationPort, byte[] data, boolean statusReportRequested) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = destinationPort;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        byte[] smsHeaderData = SmsHeader.toByteArray(smsHeader);
        if (data.length + smsHeaderData.length + 1 > 140) {
            Log.e(LOG_TAG, "SMS data message may only contain " + (140 - smsHeaderData.length - 1) + " bytes");
            return null;
        }
        SubmitPdu ret = new SubmitPdu();
        ByteArrayOutputStream bo = SmsMessage.getSubmitPduHead(scAddress, destinationAddress, (byte)65, statusReportRequested, ret);
        bo.write(4);
        bo.write(data.length + smsHeaderData.length + 1);
        bo.write(smsHeaderData.length);
        bo.write(smsHeaderData, 0, smsHeaderData.length);
        bo.write(data, 0, data.length);
        ret.encodedMessage = bo.toByteArray();
        return ret;
    }

    public static ByteArrayOutputStream getSubmitPduHead(String scAddress, String destinationAddress, byte mtiByte, boolean statusReportRequested, SubmitPdu ret) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream(180);
        ret.encodedScAddress = (byte[])(scAddress == null ? null : PhoneNumberUtils.networkPortionToCalledPartyBCDWithLength(scAddress));
        if (statusReportRequested) {
            mtiByte = (byte)(mtiByte | 0x20);
            Log.d(LOG_TAG, "SMS status report requested");
        }
        bo.write(mtiByte);
        bo.write(0);
        byte[] daBytes = PhoneNumberUtils.networkPortionToCalledPartyBCD(destinationAddress);
        bo.write((daBytes.length - 1) * 2 - ((daBytes[daBytes.length - 1] & 0xF0) == 240 ? 1 : 0));
        bo.write(daBytes, 0, daBytes.length);
        bo.write(0);
        return bo;
    }

    public static SmsMessageBase.TextEncodingDetails calculateLength(CharSequence msgBody, boolean use7bitOnly) {
        SmsMessageBase.TextEncodingDetails ted = new SmsMessageBase.TextEncodingDetails();
        try {
            int septets;
            ted.codeUnitCount = septets = GsmAlphabet.countGsmSeptets(msgBody, !use7bitOnly);
            if (septets > 160) {
                ted.msgCount = septets / 153 + 1;
                ted.codeUnitsRemaining = 153 - septets % 153;
            } else {
                ted.msgCount = 1;
                ted.codeUnitsRemaining = 160 - septets;
            }
            ted.codeUnitSize = 1;
        }
        catch (EncodeException ex) {
            int octets = msgBody.length() * 2;
            ted.codeUnitCount = msgBody.length();
            if (octets > 140) {
                ted.msgCount = octets / 134 + 1;
                ted.codeUnitsRemaining = (134 - octets % 134) / 2;
            } else {
                ted.msgCount = 1;
                ted.codeUnitsRemaining = (140 - octets) / 2;
            }
            ted.codeUnitSize = 3;
        }
        return ted;
    }

    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public boolean isReplace() {
        return (this.protocolIdentifier & 0xC0) == 64 && (this.protocolIdentifier & 0x3F) > 0 && (this.protocolIdentifier & 0x3F) < 8;
    }

    public boolean isCphsMwiMessage() {
        return ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageClear() || ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageSet();
    }

    public boolean isMWIClearMessage() {
        if (this.isMwi && !this.mwiSense) {
            return true;
        }
        return this.originatingAddress != null && ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageClear();
    }

    public boolean isMWISetMessage() {
        if (this.isMwi && this.mwiSense) {
            return true;
        }
        return this.originatingAddress != null && ((GsmSmsAddress)this.originatingAddress).isCphsVoiceMessageSet();
    }

    public boolean isMwiDontStore() {
        if (this.isMwi && this.mwiDontStore) {
            return true;
        }
        if (this.isCphsMwiMessage()) {
            if (" ".equals(this.getMessageBody())) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isStatusReportMessage() {
        return this.isStatusReportMessage;
    }

    public boolean isReplyPathPresent() {
        return this.replyPathPresent;
    }

    public void parsePdu(byte[] pdu) {
        this.mPdu = pdu;
        PduParser p = new PduParser(pdu);
        this.scAddress = p.getSCAddress();
        if (this.scAddress != null) {
            Log.d(LOG_TAG, "SMS SC address: " + this.scAddress);
        }
        int firstByte = p.getByte();
        this.mti = firstByte & 3;
        switch (this.mti) {
            case 0: {
                this.parseSmsDeliver(p, firstByte);
                break;
            }
            case 2: {
                this.parseSmsStatusReport(p, firstByte);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported message type");
            }
        }
    }

    public void parseSmsStatusReport(PduParser p, int firstByte) {
        this.isStatusReportMessage = true;
        this.forSubmit = (firstByte & 0x20) == 0;
        this.messageRef = p.getByte();
        this.recipientAddress = p.getAddress();
        this.scTimeMillis = p.getSCTimestampMillis();
        this.dischargeTimeMillis = p.getSCTimestampMillis();
        this.status = p.getByte();
        if (p.moreDataPresent()) {
            int extraParams;
            int moreExtraParams = extraParams = p.getByte();
            while ((moreExtraParams & 0x80) != 0) {
                moreExtraParams = p.getByte();
            }
            if ((extraParams & 1) != 0) {
                this.protocolIdentifier = p.getByte();
            }
            if ((extraParams & 2) != 0) {
                this.dataCodingScheme = p.getByte();
            }
            if ((extraParams & 4) != 0) {
                boolean hasUserDataHeader = (firstByte & 0x40) == 64;
                this.parseUserData(p, hasUserDataHeader);
            }
        }
    }

    public void parseSmsDeliver(PduParser p, int firstByte) {
        this.replyPathPresent = (firstByte & 0x80) == 128;
        this.originatingAddress = p.getAddress();
        if (this.originatingAddress != null) {
            // empty if block
        }
        this.protocolIdentifier = p.getByte();
        this.dataCodingScheme = p.getByte();
        this.scTimeMillis = p.getSCTimestampMillis();
        Log.d(LOG_TAG, "SMS SC timestamp: " + this.scTimeMillis);
        boolean hasUserDataHeader = (firstByte & 0x40) == 64;
        this.parseUserData(p, hasUserDataHeader);
    }

    public void parseUserData(PduParser p, boolean hasUserDataHeader) {
        boolean hasMessageClass = false;
        boolean userDataCompressed = false;
        int encodingType = 0;
        if ((this.dataCodingScheme & 0x80) == 0) {
            this.automaticDeletion = 0 != (this.dataCodingScheme & 0x40);
            userDataCompressed = 0 != (this.dataCodingScheme & 0x20);
            boolean bl = hasMessageClass = 0 != (this.dataCodingScheme & 0x10);
            if (userDataCompressed) {
                Log.w(LOG_TAG, "4 - Unsupported SMS data coding scheme (compression) " + (this.dataCodingScheme & 0xFF));
            } else {
                switch (this.dataCodingScheme >> 2 & 3) {
                    case 0: {
                        encodingType = 1;
                        break;
                    }
                    case 2: {
                        encodingType = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        Log.w(LOG_TAG, "1 - Unsupported SMS data coding scheme " + (this.dataCodingScheme & 0xFF));
                        encodingType = 2;
                    }
                }
            }
        } else if ((this.dataCodingScheme & 0xF0) == 240) {
            this.automaticDeletion = false;
            hasMessageClass = true;
            userDataCompressed = false;
            encodingType = 0 == (this.dataCodingScheme & 4) ? 1 : 2;
        } else if ((this.dataCodingScheme & 0xF0) == 192 || (this.dataCodingScheme & 0xF0) == 208 || (this.dataCodingScheme & 0xF0) == 224) {
            boolean active;
            encodingType = (this.dataCodingScheme & 0xF0) == 224 ? 3 : 1;
            userDataCompressed = false;
            boolean bl = active = (this.dataCodingScheme & 8) == 8;
            if ((this.dataCodingScheme & 3) == 0) {
                this.isMwi = true;
                this.mwiSense = active;
                this.mwiDontStore = (this.dataCodingScheme & 0xF0) == 192;
            } else {
                this.isMwi = false;
                Log.w(LOG_TAG, "MWI for fax, email, or other " + (this.dataCodingScheme & 0xFF));
            }
        } else {
            Log.w(LOG_TAG, "3 - Unsupported SMS data coding scheme " + (this.dataCodingScheme & 0xFF));
        }
        int count = p.constructUserData(hasUserDataHeader, encodingType == 1);
        this.userData = p.getUserData();
        this.userDataHeader = p.getUserDataHeader();
        switch (encodingType) {
            case 0: 
            case 2: {
                this.messageBody = null;
                break;
            }
            case 1: {
                this.messageBody = p.getUserDataGSM7Bit(count);
                break;
            }
            case 3: {
                this.messageBody = p.getUserDataUCS2(count);
            }
        }
        if (this.messageBody != null) {
            this.parseMessageBody();
        }
        if (!hasMessageClass) {
            this.messageClass = SmsMessage.MessageClass.UNKNOWN;
        } else {
            switch (this.dataCodingScheme & 3) {
                case 0: {
                    this.messageClass = SmsMessage.MessageClass.CLASS_0;
                    break;
                }
                case 1: {
                    this.messageClass = SmsMessage.MessageClass.CLASS_1;
                    break;
                }
                case 2: {
                    this.messageClass = SmsMessage.MessageClass.CLASS_2;
                    break;
                }
                case 3: {
                    this.messageClass = SmsMessage.MessageClass.CLASS_3;
                }
            }
        }
    }

    public SmsMessage.MessageClass getMessageClass() {
        return this.messageClass;
    }

    public static class PduParser {
        public byte[] pdu;
        public int cur;
        public SmsHeader userDataHeader;
        public byte[] userData;
        public int mUserDataSeptetPadding;
        public int mUserDataSize;

        public PduParser(String s) {
            this(IccUtils.hexStringToBytes(s));
        }

        public PduParser(byte[] pdu) {
            this.pdu = pdu;
            this.cur = 0;
            this.mUserDataSeptetPadding = 0;
        }

        public String getSCAddress() {
            String ret;
            int len = this.getByte();
            if (len == 0) {
                ret = null;
            } else {
                try {
                    ret = PhoneNumberUtils.calledPartyBCDToString(this.pdu, this.cur, len);
                }
                catch (RuntimeException tr) {
                    Log.d(SmsMessage.LOG_TAG, "invalid SC address: ", tr);
                    ret = null;
                }
            }
            this.cur += len;
            return ret;
        }

        public int getByte() {
            return this.pdu[this.cur++] & 0xFF;
        }

        public GsmSmsAddress getAddress() {
            int addressLength = this.pdu[this.cur] & 0xFF;
            int lengthBytes = 2 + (addressLength + 1) / 2;
            GsmSmsAddress ret = new GsmSmsAddress(this.pdu, this.cur, lengthBytes);
            this.cur += lengthBytes;
            return ret;
        }

        public long getSCTimestampMillis() {
            int year = IccUtils.bcdByteToInt(this.pdu[this.cur++]);
            int month = IccUtils.bcdByteToInt(this.pdu[this.cur++]);
            int day = IccUtils.bcdByteToInt(this.pdu[this.cur++]);
            int hour = IccUtils.bcdByteToInt(this.pdu[this.cur++]);
            int minute = IccUtils.bcdByteToInt(this.pdu[this.cur++]);
            int second = IccUtils.bcdByteToInt(this.pdu[this.cur++]);
            byte tzByte = this.pdu[this.cur++];
            int timezoneOffset = IccUtils.bcdByteToInt((byte)(tzByte & 0xFFFFFFF7));
            timezoneOffset = (tzByte & 8) == 0 ? timezoneOffset : -timezoneOffset;
            Time time = new Time("UTC");
            time.year = year >= 90 ? year + 1900 : year + 2000;
            time.month = month - 1;
            time.monthDay = day;
            time.hour = hour;
            time.minute = minute;
            time.second = second;
            return time.toMillis(true) - (long)(timezoneOffset * 15 * 60 * 1000);
        }

        public int constructUserData(boolean hasUserDataHeader, boolean dataInSeptets) {
            int bufferLen;
            int offset = this.cur;
            int userDataLength = this.pdu[offset++] & 0xFF;
            int headerSeptets = 0;
            int userDataHeaderLength = 0;
            if (hasUserDataHeader) {
                userDataHeaderLength = this.pdu[offset++] & 0xFF;
                byte[] udh = new byte[userDataHeaderLength];
                System.arraycopy(this.pdu, offset, udh, 0, userDataHeaderLength);
                this.userDataHeader = SmsHeader.fromByteArray(udh);
                offset += userDataHeaderLength;
                int headerBits = (userDataHeaderLength + 1) * 8;
                headerSeptets = headerBits / 7;
                this.mUserDataSeptetPadding = (headerSeptets += headerBits % 7 > 0 ? 1 : 0) * 7 - headerBits;
            }
            if (dataInSeptets) {
                bufferLen = this.pdu.length - offset;
            } else {
                bufferLen = userDataLength - (hasUserDataHeader ? userDataHeaderLength + 1 : 0);
                if (bufferLen < 0) {
                    bufferLen = 0;
                }
            }
            this.userData = new byte[bufferLen];
            System.arraycopy(this.pdu, offset, this.userData, 0, this.userData.length);
            this.cur = offset;
            if (dataInSeptets) {
                int count = userDataLength - headerSeptets;
                return count < 0 ? 0 : count;
            }
            return this.userData.length;
        }

        public byte[] getUserData() {
            return this.userData;
        }

        public int getUserDataSeptetPadding() {
            return this.mUserDataSeptetPadding;
        }

        public SmsHeader getUserDataHeader() {
            return this.userDataHeader;
        }

        public String getUserDataGSM7Bit(int septetCount) {
            String ret = GsmAlphabet.gsm7BitPackedToString(this.pdu, this.cur, septetCount, this.mUserDataSeptetPadding);
            this.cur += septetCount * 7 / 8;
            return ret;
        }

        public String getUserDataUCS2(int byteCount) {
            String ret;
            try {
                ret = new String(this.pdu, this.cur, byteCount, "utf-16");
            }
            catch (UnsupportedEncodingException ex) {
                ret = "";
                Log.e(SmsMessage.LOG_TAG, "implausible UnsupportedEncodingException", ex);
            }
            this.cur += byteCount;
            return ret;
        }

        public boolean moreDataPresent() {
            return this.pdu.length > this.cur;
        }
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase {
    }
}

