/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.ActivityManagerNative;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.gsm.GSMPhone;

public class SimCard
extends Handler
implements IccCard {
    public static final String LOG_TAG = "GSM";
    public static final boolean DBG = true;
    public GSMPhone phone;
    public CommandsInterface.IccStatus status = null;
    public boolean mDesiredPinLocked;
    public boolean mDesiredFdnEnabled;
    public boolean mSimPinLocked = true;
    public boolean mSimFdnEnabled = false;
    public static final int NOTIFICATION_ID_SIM_STATUS = 33456;
    public static final int EVENT_SIM_LOCKED_OR_ABSENT = 1;
    public static final int EVENT_GET_SIM_STATUS_DONE = 2;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 3;
    public static final int EVENT_PINPUK_DONE = 4;
    public static final int EVENT_REPOLL_STATUS_DONE = 5;
    public static final int EVENT_SIM_READY = 6;
    public static final int EVENT_QUERY_FACILITY_LOCK_DONE = 7;
    public static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 8;
    public static final int EVENT_CHANGE_SIM_PASSWORD_DONE = 9;
    public static final int EVENT_QUERY_FACILITY_FDN_DONE = 10;
    public static final int EVENT_CHANGE_FACILITY_FDN_DONE = 11;
    public RegistrantList absentRegistrants = new RegistrantList();
    public RegistrantList pinLockedRegistrants = new RegistrantList();
    public RegistrantList networkLockedRegistrants = new RegistrantList();

    public SimCard(GSMPhone phone) {
        this.phone = phone;
        phone.mCM.registerForSIMLockedOrAbsent(this, 1, null);
        phone.mCM.registerForOffOrNotAvailable(this, 3, null);
        phone.mCM.registerForSIMReady(this, 6, null);
        this.updateStateProperty();
    }

    public void dispose() {
        this.phone.mCM.unregisterForSIMLockedOrAbsent(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unregisterForSIMReady(this);
    }

    public void finalize() {
        Log.d(LOG_TAG, "SimCard finalized");
    }

    public IccCard.State getState() {
        if (this.status == null) {
            switch (this.phone.mCM.getRadioState()) {
                case RADIO_OFF: 
                case RADIO_UNAVAILABLE: 
                case SIM_NOT_READY: {
                    return IccCard.State.UNKNOWN;
                }
                case SIM_LOCKED_OR_ABSENT: {
                    return IccCard.State.UNKNOWN;
                }
                case SIM_READY: {
                    return IccCard.State.READY;
                }
            }
        } else {
            switch (this.status) {
                case ICC_ABSENT: {
                    return IccCard.State.ABSENT;
                }
                case ICC_NOT_READY: {
                    return IccCard.State.UNKNOWN;
                }
                case ICC_READY: {
                    return IccCard.State.READY;
                }
                case ICC_PIN: {
                    return IccCard.State.PIN_REQUIRED;
                }
                case ICC_PUK: {
                    return IccCard.State.PUK_REQUIRED;
                }
                case ICC_NETWORK_PERSONALIZATION: {
                    return IccCard.State.NETWORK_LOCKED;
                }
            }
        }
        Log.e(LOG_TAG, "GsmSimCard.getState(): case should never be reached");
        return IccCard.State.UNKNOWN;
    }

    public void registerForAbsent(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.absentRegistrants.add(r);
        if (this.getState() == IccCard.State.ABSENT) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForAbsent(Handler h) {
        this.absentRegistrants.remove(h);
    }

    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.networkLockedRegistrants.add(r);
        if (this.getState() == IccCard.State.NETWORK_LOCKED) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkLocked(Handler h) {
        this.networkLockedRegistrants.remove(h);
    }

    public void registerForLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.pinLockedRegistrants.add(r);
        if (this.getState().isPinLocked()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForLocked(Handler h) {
        this.pinLockedRegistrants.remove(h);
    }

    public void supplyPin(String pin, Message onComplete) {
        this.phone.mCM.supplyIccPin(pin, this.obtainMessage(4, onComplete));
    }

    public void supplyPuk(String puk, String newPin, Message onComplete) {
        this.phone.mCM.supplyIccPuk(puk, newPin, this.obtainMessage(4, onComplete));
    }

    public void supplyPin2(String pin2, Message onComplete) {
        this.phone.mCM.supplyIccPin2(pin2, this.obtainMessage(4, onComplete));
    }

    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        this.phone.mCM.supplyIccPuk2(puk2, newPin2, this.obtainMessage(4, onComplete));
    }

    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        this.log("Network Despersonalization: " + pin);
        this.phone.mCM.supplyNetworkDepersonalization(pin, this.obtainMessage(4, onComplete));
    }

    public boolean getIccLockEnabled() {
        return this.mSimPinLocked;
    }

    public boolean getIccFdnEnabled() {
        return this.mSimFdnEnabled;
    }

    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 7;
        this.mDesiredPinLocked = enabled;
        this.phone.mCM.setFacilityLock("SC", enabled, password, serviceClassX, this.obtainMessage(8, onComplete));
    }

    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 15;
        this.mDesiredFdnEnabled = enabled;
        this.phone.mCM.setFacilityLock("FD", enabled, password, serviceClassX, this.obtainMessage(11, onComplete));
    }

    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        this.log("Change Pin1 old: " + oldPassword + " new: " + newPassword);
        this.phone.mCM.changeIccPin(oldPassword, newPassword, this.obtainMessage(9, onComplete));
    }

    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        this.log("Change Pin2 old: " + oldPassword + " new: " + newPassword);
        this.phone.mCM.changeIccPin2(oldPassword, newPassword, this.obtainMessage(9, onComplete));
    }

    public String getServiceProviderName() {
        return this.phone.mSIMRecords.getServiceProviderName();
    }

    public void handleMessage(Message msg) {
        int serviceClassX = 7;
        switch (msg.what) {
            case 3: {
                this.status = null;
                this.updateStateProperty();
                this.broadcastSimStateChangedIntent("NOT_READY", null);
                break;
            }
            case 6: {
                this.phone.mCM.getIccStatus(this.obtainMessage(2));
                this.phone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                this.phone.mCM.queryFacilityLock("FD", "", serviceClassX, this.obtainMessage(10));
                break;
            }
            case 1: {
                this.phone.mCM.getIccStatus(this.obtainMessage(2));
                this.phone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.getSimStatusDone(ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                this.phone.mCM.getIccStatus(this.obtainMessage(5, ar.userObj));
                break;
            }
            case 5: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.getSimStatusDone(ar);
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryFacilityLock(ar);
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryFdnEnabled(ar);
                break;
            }
            case 8: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mSimPinLocked = this.mDesiredPinLocked;
                    this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mSimPinLocked= " + this.mSimPinLocked);
                } else {
                    Log.e(LOG_TAG, "Error change facility lock with exception " + ar.exception);
                }
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mSimFdnEnabled = this.mDesiredFdnEnabled;
                    this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mSimFdnEnabled=" + this.mSimFdnEnabled);
                } else {
                    Log.e(LOG_TAG, "Error change facility fdn with exception " + ar.exception);
                }
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 9: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Log.e(LOG_TAG, "Error in change sim password with exception" + ar.exception);
                }
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            default: {
                Log.e(LOG_TAG, "[GsmSimCard] Unknown Event " + msg.what);
            }
        }
    }

    public void onQueryFacilityLock(AsyncResult ar) {
        if (ar.exception != null) {
            this.log("Error in querying facility lock:" + ar.exception);
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            this.mSimPinLocked = 0 != ints[0];
            this.log("Query facility lock : " + this.mSimPinLocked);
        } else {
            Log.e(LOG_TAG, "[GsmSimCard] Bogus facility lock response");
        }
    }

    public void onQueryFdnEnabled(AsyncResult ar) {
        if (ar.exception != null) {
            this.log("Error in querying facility lock:" + ar.exception);
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            this.mSimFdnEnabled = 0 != ints[0];
            this.log("Query facility lock : " + this.mSimFdnEnabled);
        } else {
            Log.e(LOG_TAG, "[GsmSimCard] Bogus facility lock response");
        }
    }

    public void getSimStatusDone(AsyncResult ar) {
        if (ar.exception != null) {
            Log.e(LOG_TAG, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        CommandsInterface.IccStatus newStatus = (CommandsInterface.IccStatus)((Object)ar.result);
        this.handleSimStatus(newStatus);
    }

    public void handleSimStatus(CommandsInterface.IccStatus newStatus) {
        boolean transitionedIntoNetworkLocked;
        IccCard.State oldState = this.getState();
        this.status = newStatus;
        IccCard.State newState = this.getState();
        this.updateStateProperty();
        boolean transitionedIntoPinLocked = oldState != IccCard.State.PIN_REQUIRED && newState == IccCard.State.PIN_REQUIRED || oldState != IccCard.State.PUK_REQUIRED && newState == IccCard.State.PUK_REQUIRED;
        boolean transitionedIntoAbsent = oldState != IccCard.State.ABSENT && newState == IccCard.State.ABSENT;
        boolean bl = transitionedIntoNetworkLocked = oldState != IccCard.State.NETWORK_LOCKED && newState == IccCard.State.NETWORK_LOCKED;
        if (transitionedIntoPinLocked) {
            this.log("Notify SIM pin or puk locked.");
            this.pinLockedRegistrants.notifyRegistrants();
            this.broadcastSimStateChangedIntent("LOCKED", newState == IccCard.State.PIN_REQUIRED ? "PIN" : "PUK");
        } else if (transitionedIntoAbsent) {
            this.log("Notify SIM missing.");
            this.absentRegistrants.notifyRegistrants();
            this.broadcastSimStateChangedIntent("ABSENT", null);
        } else if (transitionedIntoNetworkLocked) {
            this.log("Notify SIM network locked.");
            this.networkLockedRegistrants.notifyRegistrants();
            this.broadcastSimStateChangedIntent("LOCKED", "NETWORK");
        }
    }

    public void broadcastSimStateChangedIntent(String value, String reason) {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        intent.putExtra("phoneName", this.phone.getPhoneName());
        intent.putExtra("ss", value);
        intent.putExtra("reason", reason);
        this.log("Broadcasting intent SIM_STATE_CHANGED_ACTION " + value + " reason " + reason);
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE");
    }

    public void updateImsiConfiguration(String imsi) {
        if (imsi.length() >= 6) {
            Configuration config = new Configuration();
            config.mcc = (imsi.charAt(0) - 48) * 100 + (imsi.charAt(1) - 48) * 10 + (imsi.charAt(2) - 48);
            config.mnc = (imsi.charAt(3) - 48) * 100 + (imsi.charAt(4) - 48) * 10 + (imsi.charAt(5) - 48);
            try {
                ActivityManagerNative.getDefault().updateConfiguration(config);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void updateStateProperty() {
        this.phone.setSystemProperty("gsm.sim.state", this.getState().toString());
    }

    public void log(String msg) {
        Log.d(LOG_TAG, "[GsmSimCard] " + msg);
    }
}

