/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SmsMessage;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsmSMSDispatcher
extends SMSDispatcher {
    public static final String TAG = "GSM";
    public GSMPhone mGsmPhone;

    public GsmSMSDispatcher(GSMPhone phone) {
        super(phone);
        this.mGsmPhone = phone;
    }

    @Override
    public void handleStatusReport(AsyncResult ar) {
        String pduString = (String)ar.result;
        SmsMessage sms = SmsMessage.newFromCDS(pduString);
        if (sms != null) {
            int messageRef = sms.messageRef;
            int count = this.deliveryPendingList.size();
            for (int i = 0; i < count; ++i) {
                SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (tracker.mMessageRef != messageRef) continue;
                this.deliveryPendingList.remove(i);
                PendingIntent intent = tracker.mDeliveryIntent;
                Intent fillIn = new Intent();
                fillIn.putExtra("pdu", IccUtils.hexStringToBytes(pduString));
                try {
                    intent.send(this.mContext, -1, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {}
                break;
            }
        }
        this.acknowledgeLastIncomingSms(true, 1, null);
    }

    @Override
    public int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            return 2;
        }
        SmsMessage sms = (SmsMessage)smsb;
        boolean handled = false;
        if (sms.isMWISetMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(true);
            Log.d(TAG, "Received voice mail indicator set SMS shouldStore=" + !(handled |= sms.isMwiDontStore()));
        } else if (sms.isMWIClearMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(false);
            Log.d(TAG, "Received voice mail indicator clear SMS shouldStore=" + !(handled |= sms.isMwiDontStore()));
        }
        if (handled) {
            return 1;
        }
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            byte[][] pdus = new byte[][]{sms.getPdu()};
            if (smsHeader != null && smsHeader.portAddrs != null) {
                if (smsHeader.portAddrs.destPort == 2948) {
                    return this.mWapPush.dispatchWapPdu(sms.getUserData());
                }
                this.dispatchPortAddressedPdus(pdus, smsHeader.portAddrs.destPort);
            } else {
                this.dispatchPdus(pdus);
            }
            return -1;
        }
        return this.processMessagePart(sms, smsHeader.concatRef, smsHeader.portAddrs);
    }

    @Override
    public void sendMultipartText(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        int refNumber = GsmSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        for (int i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            SmsMessage.SubmitPdu pdus = SmsMessage.getSubmitPdu(scAddress, destinationAddress, parts.get(i), deliveryIntent != null, SmsHeader.toByteArray(smsHeader));
            this.sendRawPdu(pdus.encodedScAddress, pdus.encodedMessage, sentIntent, deliveryIntent);
        }
    }

    public void sendMultipartTextWithPermit(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        int ss = this.mPhone.getServiceState().getState();
        if (ss != 0) {
            int count = parts.size();
            for (int i = 0; i < count; ++i) {
                PendingIntent sentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    sentIntent = sentIntents.get(i);
                }
                SMSDispatcher.SmsTracker tracker = this.SmsTrackerFactory(null, sentIntent, null);
                this.handleNotInService(ss, tracker);
            }
            return;
        }
        int refNumber = GsmSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        for (int i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = false;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            SmsMessage.SubmitPdu pdus = SmsMessage.getSubmitPdu(scAddress, destinationAddress, parts.get(i), deliveryIntent != null, SmsHeader.toByteArray(smsHeader));
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            map.put("smsc", pdus.encodedScAddress);
            map.put("pdu", pdus.encodedMessage);
            SMSDispatcher.SmsTracker tracker = this.SmsTrackerFactory(map, sentIntent, deliveryIntent);
            this.sendSms(tracker);
        }
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap map = tracker.mData;
        byte[] smsc = (byte[])map.get("smsc");
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        this.mCm.sendSMS(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
    }

    @Override
    public void sendMultipartSms(SMSDispatcher.SmsTracker tracker) {
        HashMap map = tracker.mData;
        String destinationAddress = (String)map.get("destination");
        String scAddress = (String)map.get("scaddress");
        ArrayList parts = (ArrayList)map.get("parts");
        ArrayList sentIntents = (ArrayList)map.get("sentIntents");
        ArrayList deliveryIntents = (ArrayList)map.get("deliveryIntents");
        this.sendMultipartTextWithPermit(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
    }

    @Override
    public void acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (this.mCm != null) {
            this.mCm.acknowledgeLastIncomingGsmSms(success, this.resultToCause(result), response);
        }
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        response.recycle();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        response.recycle();
    }

    @Override
    public void setCellBroadcastConfig(int[] configValuesArray, Message response) {
        Log.e(TAG, "Error! The functionality cell broadcast sms is not implemented for GSM.");
        response.recycle();
    }

    public int resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 211;
            }
        }
        return 255;
    }
}

