/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.ActivityManagerNative;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.cdma.CDMAPhone;

public class RuimCard
extends Handler
implements IccCard {
    public static final String LOG_TAG = "CDMA";
    public static final boolean DBG = true;
    public CDMAPhone phone;
    public CommandsInterface.IccStatus status = null;
    public boolean mDesiredPinLocked;
    public boolean mDesiredFdnEnabled;
    public boolean mRuimPinLocked = true;
    public boolean mRuimFdnEnabled = false;
    public static final int EVENT_RUIM_LOCKED_OR_ABSENT = 1;
    public static final int EVENT_GET_RUIM_STATUS_DONE = 2;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 3;
    public static final int EVENT_PINPUK_DONE = 4;
    public static final int EVENT_REPOLL_STATUS_DONE = 5;
    public static final int EVENT_RUIM_READY = 6;
    public static final int EVENT_QUERY_FACILITY_LOCK_DONE = 7;
    public static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 8;
    public static final int EVENT_CHANGE_RUIM_PASSWORD_DONE = 9;
    public static final int EVENT_QUERY_FACILITY_FDN_DONE = 10;
    public static final int EVENT_CHANGE_FACILITY_FDN_DONE = 11;
    public RegistrantList absentRegistrants = new RegistrantList();
    public RegistrantList pinLockedRegistrants = new RegistrantList();
    public RegistrantList networkLockedRegistrants = new RegistrantList();

    public RuimCard(CDMAPhone phone) {
        this.phone = phone;
        phone.mCM.registerForRUIMLockedOrAbsent(this, 1, null);
        phone.mCM.registerForOffOrNotAvailable(this, 3, null);
        phone.mCM.registerForRUIMReady(this, 6, null);
        this.updateStateProperty();
    }

    public IccCard.State getState() {
        if (this.status == null) {
            switch (this.phone.mCM.getRadioState()) {
                case RADIO_OFF: 
                case RADIO_UNAVAILABLE: 
                case RUIM_NOT_READY: {
                    return IccCard.State.UNKNOWN;
                }
                case RUIM_LOCKED_OR_ABSENT: {
                    return IccCard.State.UNKNOWN;
                }
                case RUIM_READY: {
                    return IccCard.State.READY;
                }
                case NV_READY: 
                case NV_NOT_READY: {
                    return IccCard.State.ABSENT;
                }
            }
        } else {
            switch (this.status) {
                case ICC_ABSENT: {
                    return IccCard.State.ABSENT;
                }
                case ICC_NOT_READY: {
                    return IccCard.State.UNKNOWN;
                }
                case ICC_READY: {
                    return IccCard.State.READY;
                }
                case ICC_PIN: {
                    return IccCard.State.PIN_REQUIRED;
                }
                case ICC_PUK: {
                    return IccCard.State.PUK_REQUIRED;
                }
                case ICC_NETWORK_PERSONALIZATION: {
                    return IccCard.State.NETWORK_LOCKED;
                }
            }
        }
        Log.e(LOG_TAG, "RuimCard.getState(): case should never be reached");
        return IccCard.State.UNKNOWN;
    }

    public void dispose() {
        this.phone.mCM.unregisterForRUIMLockedOrAbsent(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.phone.mCM.unregisterForRUIMReady(this);
    }

    public void finalize() {
        Log.d(LOG_TAG, "RuimCard finalized");
    }

    public void registerForAbsent(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.absentRegistrants.add(r);
        if (this.getState() == IccCard.State.ABSENT) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForAbsent(Handler h) {
        this.absentRegistrants.remove(h);
    }

    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.networkLockedRegistrants.add(r);
        if (this.getState() == IccCard.State.NETWORK_LOCKED) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkLocked(Handler h) {
        this.networkLockedRegistrants.remove(h);
    }

    public void registerForLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.pinLockedRegistrants.add(r);
        if (this.getState().isPinLocked()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForLocked(Handler h) {
        this.pinLockedRegistrants.remove(h);
    }

    public void supplyPin(String pin, Message onComplete) {
        this.phone.mCM.supplyIccPin(pin, this.obtainMessage(4, onComplete));
    }

    public void supplyPuk(String puk, String newPin, Message onComplete) {
        this.phone.mCM.supplyIccPuk(puk, newPin, this.obtainMessage(4, onComplete));
    }

    public void supplyPin2(String pin2, Message onComplete) {
        this.phone.mCM.supplyIccPin2(pin2, this.obtainMessage(4, onComplete));
    }

    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        this.phone.mCM.supplyIccPuk2(puk2, newPin2, this.obtainMessage(4, onComplete));
    }

    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        this.log("Network Despersonalization: " + pin);
        this.phone.mCM.supplyNetworkDepersonalization(pin, this.obtainMessage(4, onComplete));
    }

    public boolean getIccLockEnabled() {
        return this.mRuimPinLocked;
    }

    public boolean getIccFdnEnabled() {
        return this.mRuimFdnEnabled;
    }

    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 7;
        this.mDesiredPinLocked = enabled;
        this.phone.mCM.setFacilityLock("SC", enabled, password, serviceClassX, this.obtainMessage(8, onComplete));
    }

    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 15;
        this.mDesiredFdnEnabled = enabled;
        this.phone.mCM.setFacilityLock("FD", enabled, password, serviceClassX, this.obtainMessage(11, onComplete));
    }

    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        this.log("Change Pin1 old: " + oldPassword + " new: " + newPassword);
        this.phone.mCM.changeIccPin(oldPassword, newPassword, this.obtainMessage(9, onComplete));
    }

    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        this.log("Change Pin2 old: " + oldPassword + " new: " + newPassword);
        this.phone.mCM.changeIccPin2(oldPassword, newPassword, this.obtainMessage(9, onComplete));
    }

    public String getServiceProviderName() {
        return this.phone.mRuimRecords.getServiceProviderName();
    }

    public void handleMessage(Message msg) {
        int serviceClassX = 7;
        switch (msg.what) {
            case 3: {
                Log.d(LOG_TAG, "Event EVENT_RADIO_OFF_OR_NOT_AVAILABLE Received");
                this.status = null;
                this.updateStateProperty();
                this.broadcastRuimStateChangedIntent("NOT_READY", null);
                break;
            }
            case 6: {
                Log.d(LOG_TAG, "Event EVENT_RUIM_READY Received");
                this.phone.mCM.getIccStatus(this.obtainMessage(2));
                this.phone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                this.phone.mCM.queryFacilityLock("FD", "", serviceClassX, this.obtainMessage(10));
                break;
            }
            case 1: {
                Log.d(LOG_TAG, "Event EVENT_RUIM_LOCKED_OR_ABSENT Received");
                this.phone.mCM.getIccStatus(this.obtainMessage(2));
                this.phone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                break;
            }
            case 2: {
                Log.d(LOG_TAG, "Event EVENT_GET_RUIM_STATUS_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.getRuimStatusDone(ar);
                break;
            }
            case 4: {
                Log.d(LOG_TAG, "Event EVENT_PINPUK_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                this.phone.mCM.getIccStatus(this.obtainMessage(5, ar.userObj));
                break;
            }
            case 5: {
                Log.d(LOG_TAG, "Event EVENT_REPOLL_STATUS_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.getRuimStatusDone(ar);
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 7: {
                Log.d(LOG_TAG, "Event EVENT_QUERY_FACILITY_LOCK_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryFacilityLock(ar);
                break;
            }
            case 10: {
                Log.d(LOG_TAG, "Event EVENT_QUERY_FACILITY_FDN_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryFdnEnabled(ar);
                break;
            }
            case 8: {
                Log.d(LOG_TAG, "Event EVENT_CHANGE_FACILITY_LOCK_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mRuimPinLocked = this.mDesiredPinLocked;
                    this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mRuimPinLocked= " + this.mRuimPinLocked);
                } else {
                    Log.e(LOG_TAG, "Error change facility lock with exception " + ar.exception);
                }
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 11: {
                Log.d(LOG_TAG, "Event EVENT_CHANGE_FACILITY_FDN_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mRuimFdnEnabled = this.mDesiredFdnEnabled;
                    this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mRuimFdnEnabled=" + this.mRuimFdnEnabled);
                } else {
                    Log.e(LOG_TAG, "Error change facility fdn with exception " + ar.exception);
                }
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 9: {
                Log.d(LOG_TAG, "Event EVENT_CHANGE_RUIM_PASSWORD_DONE Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Log.e(LOG_TAG, "Error in change sim password with exception" + ar.exception);
                }
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            default: {
                Log.e(LOG_TAG, "[CdmaRuimCard] Unknown Event " + msg.what);
            }
        }
    }

    public void onQueryFacilityLock(AsyncResult ar) {
        if (ar.exception != null) {
            this.log("Error in querying facility lock:" + ar.exception);
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            this.mRuimPinLocked = 0 != ints[0];
            this.log("Query facility lock : " + this.mRuimPinLocked);
        } else {
            Log.e(LOG_TAG, "[CdmaRuimCard] Bogus facility lock response");
        }
    }

    public void onQueryFdnEnabled(AsyncResult ar) {
        if (ar.exception != null) {
            this.log("Error in querying facility lock:" + ar.exception);
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            this.mRuimFdnEnabled = 0 != ints[0];
            this.log("Query facility lock : " + this.mRuimFdnEnabled);
        } else {
            Log.e(LOG_TAG, "[CdmaRuimCard] Bogus facility lock response");
        }
    }

    public void getRuimStatusDone(AsyncResult ar) {
        if (ar.exception != null) {
            Log.e(LOG_TAG, "Error getting SIM status. RIL_REQUEST_GET_SIM_STATUS should never return an error", ar.exception);
            return;
        }
        CommandsInterface.IccStatus newStatus = (CommandsInterface.IccStatus)((Object)ar.result);
        this.handleRuimStatus(newStatus);
    }

    public void handleRuimStatus(CommandsInterface.IccStatus newStatus) {
        boolean transitionedIntoNetworkLocked;
        IccCard.State oldState = this.getState();
        this.status = newStatus;
        IccCard.State newState = this.getState();
        this.updateStateProperty();
        boolean transitionedIntoPinLocked = oldState != IccCard.State.PIN_REQUIRED && newState == IccCard.State.PIN_REQUIRED || oldState != IccCard.State.PUK_REQUIRED && newState == IccCard.State.PUK_REQUIRED;
        boolean transitionedIntoAbsent = oldState != IccCard.State.ABSENT && newState == IccCard.State.ABSENT;
        boolean bl = transitionedIntoNetworkLocked = oldState != IccCard.State.NETWORK_LOCKED && newState == IccCard.State.NETWORK_LOCKED;
        if (transitionedIntoPinLocked) {
            this.log("Notify RUIM pin or puk locked.");
            this.pinLockedRegistrants.notifyRegistrants();
            this.broadcastRuimStateChangedIntent("LOCKED", newState == IccCard.State.PIN_REQUIRED ? "PIN" : "PUK");
        } else if (transitionedIntoAbsent) {
            this.log("Notify RUIM missing.");
            this.absentRegistrants.notifyRegistrants();
            this.broadcastRuimStateChangedIntent("ABSENT", null);
        } else if (transitionedIntoNetworkLocked) {
            this.log("Notify RUIM network locked.");
            this.networkLockedRegistrants.notifyRegistrants();
            this.broadcastRuimStateChangedIntent("LOCKED", "NETWORK");
        }
    }

    public void broadcastRuimStateChangedIntent(String value, String reason) {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        intent.putExtra("phoneName", this.phone.getPhoneName());
        intent.putExtra("ss", value);
        intent.putExtra("reason", reason);
        this.log("Broadcasting intent SIM_STATE_CHANGED_ACTION " + value + " reason " + reason);
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE");
    }

    public void updateImsiConfiguration(String imsi) {
        if (imsi.length() >= 6) {
            Configuration config = new Configuration();
            config.mcc = (imsi.charAt(0) - 48) * 100 + (imsi.charAt(1) - 48) * 10 + (imsi.charAt(2) - 48);
            config.mnc = (imsi.charAt(3) - 48) * 100 + (imsi.charAt(4) - 48) * 10 + (imsi.charAt(5) - 48);
            try {
                ActivityManagerNative.getDefault().updateConfiguration(config);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void updateStateProperty() {
        this.phone.setSystemProperty("gsm.sim.state", this.getState().toString());
    }

    public void log(String msg) {
        Log.d(LOG_TAG, "[RuimCard] " + msg);
    }
}

