/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureCode
extends Handler
implements MmiCode {
    public static final String LOG_TAG = "CDMA";
    public static final String FC_CF_ACTIVATE = "72";
    public static final String FC_CF_DEACTIVATE = "73";
    public static final String FC_CF_FORWARD_TO_NUMBER = "56";
    public static final String FC_CFBL_ACTIVATE = "90";
    public static final String FC_CFBL_DEACTIVATE = "91";
    public static final String FC_CFBL_FORWARD_TO_NUMBER = "40";
    public static final String FC_CFDA_ACTIVATE = "92";
    public static final String FC_CFDA_DEACTIVATE = "93";
    public static final String FC_CFDA_FORWARD_TO_NUMBER = "42";
    public static final String FC_CCW = "70";
    public static final String FC_3WC = "71";
    public static final String FC_DND_ACTIVATE = "78";
    public static final String FC_DND_DEACTIVATE = "79";
    public static final String FC_WHO = "51";
    public static final String FC_RUAC_ACTIVATE = "60";
    public static final String FC_RUAC_DEACTIVATE = "80";
    public static final String FC_CNIP = "65";
    public static final String FC_CNIR = "85";
    public static final int EVENT_SET_COMPLETE = 1;
    public static final int EVENT_CDMA_FLASH_COMPLETED = 2;
    public CDMAPhone phone;
    public Context context;
    public String action;
    public String sc;
    public String poundString;
    public String dialingNumber;
    public MmiCode.State state = MmiCode.State.PENDING;
    public CharSequence message;
    public static Pattern sPatternSuppService = Pattern.compile("((\\*)(\\d{2,3})(#?)([^*#]*)?)(.*)");
    public static final int MATCH_GROUP_POUND_STRING = 1;
    public static final int MATCH_GROUP_ACTION_STRING = 2;
    public static final int MATCH_GROUP_SERVICE_CODE = 3;
    public static final int MATCH_GROUP_DIALING_NUMBER = 5;

    public static FeatureCode newFromDialString(String dialString, CDMAPhone phone) {
        FeatureCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new FeatureCode(phone);
            ret.poundString = FeatureCode.makeEmptyNull(m.group(1));
            ret.action = FeatureCode.makeEmptyNull(m.group(2));
            ret.sc = FeatureCode.makeEmptyNull(m.group(3));
            ret.dialingNumber = FeatureCode.makeEmptyNull(m.group(5));
        }
        return ret;
    }

    public static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public static boolean isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals(FC_CF_ACTIVATE) || sc.equals(FC_CF_DEACTIVATE) || sc.equals(FC_CF_FORWARD_TO_NUMBER) || sc.equals(FC_CFBL_ACTIVATE) || sc.equals(FC_CFBL_DEACTIVATE) || sc.equals(FC_CFBL_FORWARD_TO_NUMBER) || sc.equals(FC_CFDA_ACTIVATE) || sc.equals(FC_CFDA_DEACTIVATE) || sc.equals(FC_CFDA_FORWARD_TO_NUMBER));
    }

    public static boolean isServiceCodeCallWaiting(String sc) {
        return sc != null && sc.equals(FC_CCW);
    }

    public static boolean isServiceCodeThreeWayCalling(String sc) {
        return sc != null && sc.equals(FC_3WC);
    }

    public static boolean isServiceCodeAnnoyingCalls(String sc) {
        return sc != null && (sc.equals(FC_RUAC_ACTIVATE) || sc.equals(FC_RUAC_DEACTIVATE));
    }

    public static boolean isServiceCodeCallingNumberDelivery(String sc) {
        return sc != null && (sc.equals(FC_CNIP) || sc.equals(FC_CNIR));
    }

    public static boolean isServiceCodeDoNotDisturb(String sc) {
        return sc != null && (sc.equals(FC_DND_ACTIVATE) || sc.equals(FC_DND_DEACTIVATE));
    }

    public FeatureCode(CDMAPhone phone) {
        super(phone.getHandler().getLooper());
        this.phone = phone;
        this.context = phone.getContext();
    }

    public MmiCode.State getState() {
        return this.state;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public void cancel() {
    }

    public boolean isCancelable() {
        Log.e(LOG_TAG, "isCancelable: not used in CDMA");
        return false;
    }

    public boolean isUssdRequest() {
        Log.e(LOG_TAG, "isUssdRequest: not used in CDMA");
        return false;
    }

    public void processCode() {
        Log.d(LOG_TAG, "send feature code...");
        this.phone.mCM.sendCDMAFeatureCode(this.poundString, this.obtainMessage(2));
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.state = MmiCode.State.FAILED;
                    this.message = this.context.getText(17039591);
                } else {
                    this.state = MmiCode.State.COMPLETE;
                    this.message = this.context.getText(17039590);
                }
                this.phone.onFeatureCodeDone(this);
            }
        }
    }

    public CharSequence getScString() {
        if (this.sc != null) {
            if (FeatureCode.isServiceCodeCallForwarding(this.sc)) {
                return this.context.getText(17039541);
            }
            if (FeatureCode.isServiceCodeCallWaiting(this.sc)) {
                return this.context.getText(17039542);
            }
            if (this.sc.equals(FC_CNIP)) {
                return this.context.getText(17039546);
            }
            if (this.sc.equals(FC_CNIR)) {
                return this.context.getText(17039547);
            }
            if (FeatureCode.isServiceCodeThreeWayCalling(this.sc)) {
                return this.context.getText(17039548);
            }
            if (FeatureCode.isServiceCodeAnnoyingCalls(this.sc)) {
                return this.context.getText(17039549);
            }
            if (FeatureCode.isServiceCodeCallingNumberDelivery(this.sc)) {
                return this.context.getText(17039550);
            }
            if (FeatureCode.isServiceCodeDoNotDisturb(this.sc)) {
                return this.context.getText(17039551);
            }
        }
        return "";
    }

    public void onSetComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.state = MmiCode.State.FAILED;
            sb.append(this.context.getText(17039525));
        } else {
            this.state = MmiCode.State.FAILED;
            sb.append(this.context.getText(17039525));
        }
        this.message = sb;
        this.phone.onFeatureCodeDone(this);
    }
}

