/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.NetworkInfo;
import android.os.AsyncResult;
import android.os.INetStatService;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.provider.Checkin;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaDataConnection;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdmaDataConnectionTracker
extends DataConnectionTracker {
    public static final String LOG_TAG = "CDMA";
    public static final boolean DBG = true;
    public CDMAPhone mCdmaPhone;
    public boolean noAutoAttach = false;
    public long nextReconnectDelay = 5000L;
    public boolean mReregisterOnReconnectFailure = false;
    public boolean mIsScreenOn = true;
    public boolean failNextConnect = false;
    public ArrayList<DataConnection> dataConnectionList;
    public CdmaDataConnection mActiveDataConnection;
    public static final int EXTERNAL_NETWORK_DEFAULT_ID = 0;
    public static final int EXTERNAL_NETWORK_NUM_TYPES = 1;
    public boolean[] dataEnabled = new boolean[1];
    public static final int DATA_CONNECTION_POOL_SIZE = 1;
    public static final int POLL_CONNECTION_MILLIS = 5000;
    public static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.cdma-reconnect";
    public static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reason";
    public static final int DATA_CONNECTION_ACTIVE_PH_LINK_INACTIVE = 0;
    public static final int DATA_CONNECTION_ACTIVE_PH_LINK_DOWN = 1;
    public static final int DATA_CONNECTION_ACTIVE_PH_LINK_UP = 2;
    public BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                CdmaDataConnectionTracker.this.mIsScreenOn = true;
                CdmaDataConnectionTracker.this.stopNetStatPoll();
                CdmaDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                CdmaDataConnectionTracker.this.mIsScreenOn = false;
                CdmaDataConnectionTracker.this.stopNetStatPoll();
                CdmaDataConnectionTracker.this.startNetStatPoll();
            } else if (action.equals(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM)) {
                Log.d(CdmaDataConnectionTracker.LOG_TAG, "Data reconnect alarm. Previous state was " + (Object)((Object)CdmaDataConnectionTracker.this.state));
                String reason = intent.getStringExtra(CdmaDataConnectionTracker.INTENT_RECONNECT_ALARM_EXTRA_REASON);
                if (CdmaDataConnectionTracker.this.state == DataConnectionTracker.State.FAILED) {
                    CdmaDataConnectionTracker.this.cleanUpConnection(false, reason);
                }
                CdmaDataConnectionTracker.this.trySetupData(reason);
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                CdmaDataConnectionTracker.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    CdmaDataConnectionTracker.this.mIsWifiConnected = false;
                }
            }
        }
    };
    public Runnable mPollNetStat = new Runnable(){

        public void run() {
            long preTxPkts = -1L;
            long preRxPkts = -1L;
            preTxPkts = CdmaDataConnectionTracker.this.txPkts;
            preRxPkts = CdmaDataConnectionTracker.this.rxPkts;
            if (CdmaDataConnectionTracker.this.netstat != null) {
                try {
                    CdmaDataConnectionTracker.this.txPkts = CdmaDataConnectionTracker.this.netstat.getMobileTxPackets();
                    CdmaDataConnectionTracker.this.rxPkts = CdmaDataConnectionTracker.this.netstat.getMobileRxPackets();
                }
                catch (RemoteException e) {
                    CdmaDataConnectionTracker.this.txPkts = 0L;
                    CdmaDataConnectionTracker.this.rxPkts = 0L;
                }
                if (CdmaDataConnectionTracker.this.netStatPollEnabled && (preTxPkts > 0L || preRxPkts > 0L)) {
                    DataConnectionTracker.Activity newActivity;
                    long sent = CdmaDataConnectionTracker.this.txPkts - preTxPkts;
                    long received = CdmaDataConnectionTracker.this.rxPkts - preRxPkts;
                    if (sent > 0L && received > 0L) {
                        CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                        newActivity = DataConnectionTracker.Activity.DATAINANDOUT;
                    } else if (sent > 0L && received == 0L) {
                        if (CdmaDataConnectionTracker.this.phone.getState() == Phone.State.IDLE) {
                            CdmaDataConnectionTracker.this.sentSinceLastRecv += sent;
                        } else {
                            CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                        }
                        newActivity = DataConnectionTracker.Activity.DATAOUT;
                    } else if (sent == 0L && received > 0L) {
                        CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                        newActivity = DataConnectionTracker.Activity.DATAIN;
                    } else if (sent == 0L && received == 0L) {
                        newActivity = DataConnectionTracker.Activity.NONE;
                    } else {
                        CdmaDataConnectionTracker.this.sentSinceLastRecv = 0L;
                        newActivity = DataConnectionTracker.Activity.NONE;
                    }
                    if (CdmaDataConnectionTracker.this.activity != newActivity) {
                        CdmaDataConnectionTracker.this.activity = newActivity;
                        CdmaDataConnectionTracker.this.phone.notifyDataActivity();
                    }
                }
                if (CdmaDataConnectionTracker.this.sentSinceLastRecv >= 10L) {
                    if (CdmaDataConnectionTracker.this.mNoRecvPollCount == 0) {
                        EventLog.writeEvent(50101, CdmaDataConnectionTracker.this.sentSinceLastRecv);
                    }
                    if (CdmaDataConnectionTracker.this.mNoRecvPollCount < 24) {
                        CdmaDataConnectionTracker.this.mNoRecvPollCount++;
                        CdmaDataConnectionTracker.this.netStatPollPeriod = 5000;
                    } else {
                        CdmaDataConnectionTracker.this.log("Sent " + String.valueOf(CdmaDataConnectionTracker.this.sentSinceLastRecv) + " pkts since last received");
                        CdmaDataConnectionTracker.this.netStatPollEnabled = false;
                        CdmaDataConnectionTracker.this.stopNetStatPoll();
                        CdmaDataConnectionTracker.this.restartRadio();
                        EventLog.writeEvent(50102, 24);
                    }
                } else {
                    CdmaDataConnectionTracker.this.mNoRecvPollCount = 0;
                    CdmaDataConnectionTracker.this.netStatPollPeriod = 1000;
                }
                if (CdmaDataConnectionTracker.this.netStatPollEnabled) {
                    CdmaDataConnectionTracker.this.mDataConnectionTracker.postDelayed(this, CdmaDataConnectionTracker.this.netStatPollPeriod);
                }
            }
        }
    };

    public CdmaDataConnectionTracker(CDMAPhone p) {
        super(p);
        this.mCdmaPhone = p;
        p.mCM.registerForAvailable(this, 3, null);
        p.mCM.registerForOffOrNotAvailable(this, 12, null);
        p.mRuimRecords.registerForRecordsLoaded(this, 4, null);
        p.mCM.registerForNVReady(this, 31, null);
        p.mCM.registerForDataStateChanged(this, 6, null);
        p.mCT.registerForVoiceCallEnded(this, 15, null);
        p.mCT.registerForVoiceCallStarted(this, 14, null);
        p.mSST.registerForCdmaDataConnectionAttached(this, 5, null);
        p.mSST.registerForCdmaDataConnectionDetached(this, 30, null);
        p.mSST.registerForRoamingOn(this, 21, null);
        p.mSST.registerForRoamingOff(this, 22, null);
        this.netstat = INetStatService.Stub.asInterface(ServiceManager.getService("netstat"));
        IntentFilter filter = new IntentFilter();
        filter.addAction(INTENT_RECONNECT_ALARM);
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        p.getContext().registerReceiver(this.mIntentReceiver, filter, null, p.h);
        this.mDataConnectionTracker = this;
        this.createAllDataConnectionList();
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.phone.getContext());
        this.dataEnabled[0] = !sp.getBoolean("disabled_on_boot_key", false);
        this.noAutoAttach = !this.dataEnabled[0];
    }

    public void dispose() {
        this.phone.mCM.unregisterForAvailable(this);
        this.phone.mCM.unregisterForOffOrNotAvailable(this);
        this.mCdmaPhone.mRuimRecords.unregisterForRecordsLoaded(this);
        this.phone.mCM.unregisterForNVReady(this);
        this.phone.mCM.unregisterForDataStateChanged(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallEnded(this);
        this.mCdmaPhone.mCT.unregisterForVoiceCallStarted(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionAttached(this);
        this.mCdmaPhone.mSST.unregisterForCdmaDataConnectionDetached(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOn(this);
        this.mCdmaPhone.mSST.unregisterForRoamingOff(this);
        this.phone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.destroyAllDataConnectionList();
    }

    public void finalize() {
        Log.d(LOG_TAG, "CdmaDataConnectionTracker finalized");
    }

    public void setState(DataConnectionTracker.State s) {
        this.log("setState: " + (Object)((Object)s));
        if (this.state != s) {
            if (s == DataConnectionTracker.State.INITING) {
                Checkin.updateStats(this.phone.getContext().getContentResolver(), Checkin.Stats.Tag.PHONE_CDMA_DATA_ATTEMPTED, 1, 0.0);
            }
            if (s == DataConnectionTracker.State.CONNECTED) {
                Checkin.updateStats(this.phone.getContext().getContentResolver(), Checkin.Stats.Tag.PHONE_CDMA_DATA_CONNECTED, 1, 0.0);
            }
        }
        this.state = s;
    }

    public int enableApnType(String type) {
        Log.d(LOG_TAG, "Request to enableApnType(" + type + ")");
        if (TextUtils.equals(type, "mms")) {
            return 0;
        }
        if (TextUtils.equals(type, "supl")) {
            Log.w(LOG_TAG, "Phone.APN_TYPE_SUPL not enabled for CDMA");
            return 3;
        }
        return 3;
    }

    public int disableApnType(String type) {
        Log.d(LOG_TAG, "Request to disableApnType(" + type + ")");
        if (TextUtils.equals(type, "mms")) {
            return 1;
        }
        return 3;
    }

    public boolean isEnabled(int cdmaDataProfile) {
        return this.dataEnabled[cdmaDataProfile];
    }

    public void setEnabled(int cdmaDataProfile, boolean enable) {
        Log.d(LOG_TAG, "setEnabled(" + cdmaDataProfile + ", " + enable + ')');
        this.dataEnabled[cdmaDataProfile] = enable;
        Log.d(LOG_TAG, "dataEnabled[DEFAULT_PROFILE]=" + this.dataEnabled[0]);
    }

    @Override
    public boolean isDataConnectionAsDesired() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        if (!(this.phone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && !this.mCdmaPhone.mRuimRecords.getRecordsLoaded() || this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState() != 0 || roaming && !this.getDataOnRoamingEnabled() || this.mIsWifiConnected)) {
            return this.state == DataConnectionTracker.State.CONNECTED;
        }
        return true;
    }

    @Override
    public boolean setDataEnabled(boolean enable) {
        boolean isEnabled = this.isEnabled(0);
        Log.d(LOG_TAG, "setDataEnabled(" + enable + ") isEnabled=" + isEnabled);
        if (!isEnabled && enable) {
            this.setEnabled(0, true);
            this.sendMessage(this.obtainMessage(5));
        } else if (!enable) {
            this.setEnabled(0, false);
            Message msg = this.obtainMessage(34);
            msg.arg1 = 1;
            msg.obj = "dataDisabled";
            this.sendMessage(msg);
        }
        return true;
    }

    @Override
    public boolean getDataEnabled() {
        return this.dataEnabled[0];
    }

    @Override
    public boolean getAnyDataEnabled() {
        for (int i = 0; i < 1; ++i) {
            if (!this.isEnabled(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataAllowed() {
        boolean roaming = this.phone.getServiceState().getRoaming();
        return this.getAnyDataEnabled() && (!roaming || this.getDataOnRoamingEnabled());
    }

    public boolean trySetupData(String reason) {
        this.log("***trySetupData due to " + (reason == null ? "(unspecified)" : reason));
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(reason);
            Log.i(LOG_TAG, "(fix?) We're on the simulator; assuming data is connected");
            return true;
        }
        int psState = this.mCdmaPhone.mSST.getCurrentCdmaDataConnectionState();
        boolean roaming = this.phone.getServiceState().getRoaming();
        boolean desiredPowerState = this.mCdmaPhone.mSST.getDesiredPowerState();
        if ((this.state == DataConnectionTracker.State.IDLE || this.state == DataConnectionTracker.State.SCANNING) && psState == 0 && (this.phone.mCM.getRadioState() == CommandsInterface.RadioState.NV_READY || this.mCdmaPhone.mRuimRecords.getRecordsLoaded()) && (this.mCdmaPhone.mSST.isConcurrentVoiceAndData() || this.phone.getState() == Phone.State.IDLE) && this.isDataAllowed() && desiredPowerState) {
            return this.setupData(reason);
        }
        this.log("trySetupData: Not ready for data:  dataState=" + (Object)((Object)this.state) + " PS state=" + psState + " radio state=" + (Object)((Object)this.phone.mCM.getRadioState()) + " ruim=" + this.mCdmaPhone.mRuimRecords.getRecordsLoaded() + " concurrentVoice&Data=" + this.mCdmaPhone.mSST.isConcurrentVoiceAndData() + " phoneState=" + (Object)((Object)this.phone.getState()) + " dataEnabled=" + this.getAnyDataEnabled() + " roaming=" + roaming + " dataOnRoamingEnable=" + this.getDataOnRoamingEnabled() + " desiredPowerState=" + desiredPowerState);
        return false;
    }

    public void cleanUpConnection(boolean tearDown, String reason) {
        this.log("Clean up connection due to " + reason);
        if (this.mReconnectIntent != null) {
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            am.cancel(this.mReconnectIntent);
            this.mReconnectIntent = null;
        }
        this.setState(DataConnectionTracker.State.DISCONNECTING);
        for (DataConnection connBase : this.dataConnectionList) {
            CdmaDataConnection conn = (CdmaDataConnection)connBase;
            if (conn == null) continue;
            if (tearDown) {
                Message msg = this.obtainMessage(25, reason);
                conn.disconnect(msg);
                continue;
            }
            conn.clearSettings();
        }
        this.stopNetStatPoll();
        if (!tearDown) {
            this.setState(DataConnectionTracker.State.IDLE);
            this.phone.notifyDataConnection(reason);
        }
    }

    public CdmaDataConnection findFreeDataConnection() {
        for (DataConnection connBase : this.dataConnectionList) {
            CdmaDataConnection conn = (CdmaDataConnection)connBase;
            if (conn.getState() != DataConnection.State.INACTIVE) continue;
            return conn;
        }
        return null;
    }

    public boolean setupData(String reason) {
        CdmaDataConnection conn = this.findFreeDataConnection();
        if (conn == null) {
            this.log("setupData: No free CdmaDataConnectionfound!");
            return false;
        }
        this.mActiveDataConnection = conn;
        Message msg = this.obtainMessage();
        msg.what = 1;
        msg.obj = reason;
        conn.connect(msg);
        this.setState(DataConnectionTracker.State.INITING);
        this.phone.notifyDataConnection(reason);
        return true;
    }

    public void notifyDefaultData(String reason) {
        this.setState(DataConnectionTracker.State.CONNECTED);
        this.phone.notifyDataConnection(reason);
        this.startNetStatPoll();
        this.nextReconnectDelay = 5000L;
        this.mReregisterOnReconnectFailure = false;
    }

    public void resetPollStats() {
        this.txPkts = -1L;
        this.rxPkts = -1L;
        this.sentSinceLastRecv = 0L;
        this.netStatPollPeriod = 1000;
        this.mNoRecvPollCount = 0;
    }

    @Override
    public void startNetStatPoll() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.netStatPollEnabled) {
            Log.d(LOG_TAG, "[DataConnection] Start poll NetStat");
            this.resetPollStats();
            this.netStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    @Override
    public void stopNetStatPoll() {
        this.netStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        Log.d(LOG_TAG, "[DataConnection] Stop poll NetStat");
    }

    @Override
    public void restartRadio() {
        Log.d(LOG_TAG, "************TURN OFF RADIO**************");
        this.cleanUpConnection(true, "radioTurnedOff");
        this.phone.mCM.setRadioPower(false, null);
    }

    public boolean shouldPostNotification(DataConnection.FailCause cause) {
        return cause != DataConnection.FailCause.UNKNOWN;
    }

    public boolean retryAfterDisconnected(String reason) {
        boolean retry = true;
        if ("radioTurnedOff".equals(reason) || "dataDisabled".equals(reason)) {
            retry = false;
        }
        return retry;
    }

    public void reconnectAfterFail(DataConnection.FailCause lastFailCauseCode, String reason) {
        if (this.state == DataConnectionTracker.State.FAILED) {
            if (this.nextReconnectDelay > 1800000L) {
                if (this.mReregisterOnReconnectFailure) {
                    this.nextReconnectDelay = 1800000L;
                } else {
                    Log.d(LOG_TAG, "PDP activate failed, Reregistering to the network");
                    this.mReregisterOnReconnectFailure = true;
                    this.mCdmaPhone.mSST.reRegisterNetwork(null);
                    this.nextReconnectDelay = 5000L;
                    return;
                }
            }
            Log.d(LOG_TAG, "Data Connection activate failed. Scheduling next attempt for " + this.nextReconnectDelay / 1000L + "s");
            AlarmManager am = (AlarmManager)this.phone.getContext().getSystemService("alarm");
            Intent intent = new Intent(INTENT_RECONNECT_ALARM);
            intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, reason);
            this.mReconnectIntent = PendingIntent.getBroadcast(this.phone.getContext(), 0, intent, 0);
            am.set(2, SystemClock.elapsedRealtime() + this.nextReconnectDelay, this.mReconnectIntent);
            this.nextReconnectDelay *= 2L;
            if (!this.shouldPostNotification(lastFailCauseCode)) {
                Log.d(LOG_TAG, "NOT Posting Data Connection Unavailable notification -- likely transient error");
            } else {
                this.notifyNoData(lastFailCauseCode);
            }
        }
    }

    public void notifyNoData(DataConnection.FailCause lastFailCauseCode) {
        this.setState(DataConnectionTracker.State.FAILED);
    }

    public void onRecordsLoaded() {
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5, "simLoaded"));
    }

    public void onNVReady() {
        if (this.state == DataConnectionTracker.State.FAILED) {
            this.cleanUpConnection(false, null);
        }
        this.sendMessage(this.obtainMessage(5));
    }

    @Override
    public void onTrySetupData(String reason) {
        this.trySetupData(reason);
    }

    @Override
    public void onRoamingOff() {
        this.trySetupData("roamingOff");
    }

    @Override
    public void onRoamingOn() {
        if (this.getDataOnRoamingEnabled()) {
            this.trySetupData("roamingOn");
        } else {
            this.log("Tear down data connection on roaming.");
            this.cleanUpConnection(true, "roamingOn");
        }
    }

    @Override
    public void onRadioAvailable() {
        if (this.phone.getSimulatedRadioControl() != null) {
            this.setState(DataConnectionTracker.State.CONNECTED);
            this.phone.notifyDataConnection(null);
            Log.i(LOG_TAG, "We're on the simulator; assuming data is connected");
        }
        if (this.state != DataConnectionTracker.State.IDLE) {
            this.cleanUpConnection(true, null);
        }
    }

    @Override
    public void onRadioOffOrNotAvailable() {
        this.nextReconnectDelay = 5000L;
        this.mReregisterOnReconnectFailure = false;
        if (this.phone.getSimulatedRadioControl() != null) {
            Log.i(LOG_TAG, "We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("Radio is off and clean up all connection");
            this.cleanUpConnection(false, "radioTurnedOff");
        }
    }

    @Override
    public void onDataSetupComplete(AsyncResult ar) {
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        if (ar.exception == null) {
            this.notifyDefaultData(reason);
        } else {
            DataConnection.FailCause cause = (DataConnection.FailCause)((Object)ar.result);
            this.log("Data Connection setup failed " + (Object)((Object)cause));
            if (cause.isPermanentFail()) {
                this.notifyNoData(cause);
                return;
            }
            this.startDelayedRetry(cause, reason);
        }
    }

    @Override
    public void onDisconnectDone(AsyncResult ar) {
        this.log("EVENT_DISCONNECT_DONE");
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.setState(DataConnectionTracker.State.IDLE);
        this.phone.notifyDataConnection(reason);
        if (this.retryAfterDisconnected(reason)) {
            this.trySetupData(reason);
        }
    }

    @Override
    public void onVoiceCallStarted() {
        if (this.state == DataConnectionTracker.State.CONNECTED && !this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
            this.stopNetStatPoll();
            this.phone.notifyDataConnection("2GVoiceCallStarted");
        }
    }

    @Override
    public void onVoiceCallEnded() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (!this.mCdmaPhone.mSST.isConcurrentVoiceAndData()) {
                this.startNetStatPoll();
                this.phone.notifyDataConnection("2GVoiceCallEnded");
            } else {
                this.resetPollStats();
            }
        } else {
            this.nextReconnectDelay = 5000L;
            this.mReregisterOnReconnectFailure = false;
            this.trySetupData("2GVoiceCallEnded");
        }
    }

    @Override
    public void onCleanUpConnection(boolean tearDown, String reason) {
        this.cleanUpConnection(tearDown, reason);
    }

    public void createAllDataConnectionList() {
        this.dataConnectionList = new ArrayList();
        for (int i = 0; i < 1; ++i) {
            CdmaDataConnection dataConn = new CdmaDataConnection(this.mCdmaPhone);
            this.dataConnectionList.add(dataConn);
        }
    }

    public void destroyAllDataConnectionList() {
        if (this.dataConnectionList != null) {
            this.dataConnectionList.removeAll(this.dataConnectionList);
        }
    }

    public void onCdmaDataDetached() {
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            this.startNetStatPoll();
            this.phone.notifyDataConnection("cdmaDataDetached");
        } else {
            if (this.state == DataConnectionTracker.State.FAILED) {
                this.cleanUpConnection(false, "cdmaDataDetached");
                this.nextReconnectDelay = 5000L;
                CdmaCellLocation loc = (CdmaCellLocation)this.phone.getCellLocation();
                int bsid = loc != null ? loc.getBaseStationId() : -1;
                EventLog.List val = new EventLog.List(bsid, TelephonyManager.getDefault().getNetworkType());
                EventLog.writeEvent(50110, val);
            }
            this.trySetupData("cdmaDataDetached");
        }
    }

    public void writeEventLogCdmaDataDrop() {
        CdmaCellLocation loc = (CdmaCellLocation)this.phone.getCellLocation();
        int bsid = loc != null ? loc.getBaseStationId() : -1;
        EventLog.List val = new EventLog.List(bsid, TelephonyManager.getDefault().getNetworkType());
        EventLog.writeEvent(50111, val);
    }

    public void onDataStateChanged(AsyncResult ar) {
        ArrayList dataCallStates = (ArrayList)ar.result;
        if (ar.exception != null) {
            return;
        }
        if (this.state == DataConnectionTracker.State.CONNECTED) {
            if (dataCallStates.size() >= 1) {
                switch (((DataCallState)dataCallStates.get((int)0)).active) {
                    case 2: {
                        Log.v(LOG_TAG, "onDataStateChanged: active=LINK_ACTIVE && CONNECTED, ignore");
                        this.activity = DataConnectionTracker.Activity.NONE;
                        this.phone.notifyDataActivity();
                        break;
                    }
                    case 0: {
                        Log.v(LOG_TAG, "onDataStateChanged active=LINK_INACTIVE && CONNECTED, disconnecting/cleanup");
                        this.writeEventLogCdmaDataDrop();
                        this.cleanUpConnection(true, null);
                        break;
                    }
                    case 1: {
                        Log.v(LOG_TAG, "onDataStateChanged active=LINK_DOWN && CONNECTED, dormant");
                        this.activity = DataConnectionTracker.Activity.DORMANT;
                        this.phone.notifyDataActivity();
                        break;
                    }
                    default: {
                        Log.v(LOG_TAG, "onDataStateChanged: IGNORE unexpected DataCallState.active=" + ((DataCallState)dataCallStates.get((int)0)).active);
                        break;
                    }
                }
            } else {
                Log.v(LOG_TAG, "onDataStateChanged: network disconnected, clean up");
                this.writeEventLogCdmaDataDrop();
                this.cleanUpConnection(true, null);
            }
        } else {
            Log.i(LOG_TAG, "onDataStateChanged: not connected, state=" + (Object)((Object)this.state) + " ignoring");
        }
    }

    public String getInterfaceName() {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getInterface();
        }
        return null;
    }

    public String getIpAddress() {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getIpAddress();
        }
        return null;
    }

    public String getGateway() {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getGatewayAddress();
        }
        return null;
    }

    public String[] getDnsServers() {
        if (this.mActiveDataConnection != null) {
            return this.mActiveDataConnection.getDnsServers();
        }
        return null;
    }

    public ArrayList<DataConnection> getAllDataConnections() {
        return this.dataConnectionList;
    }

    public void startDelayedRetry(DataConnection.FailCause cause, String reason) {
        this.notifyNoData(cause);
        this.reconnectAfterFail(cause, reason);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 4: {
                this.onRecordsLoaded();
                break;
            }
            case 31: {
                this.onNVReady();
                break;
            }
            case 30: {
                this.onCdmaDataDetached();
                break;
            }
            case 6: {
                this.onDataStateChanged((AsyncResult)msg.obj);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    public void log(String s) {
        Log.d(LOG_TAG, "[CdmaDataConnectionTracker] " + s);
    }
}

