/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsHeader;
import java.util.Arrays;

public abstract class SmsMessageBase {
    public static final String LOG_TAG = "SMS";
    public String scAddress;
    public SmsAddress originatingAddress;
    public String messageBody;
    public String pseudoSubject;
    public String emailFrom;
    public String emailBody;
    public boolean isEmail;
    public long scTimeMillis;
    public byte[] mPdu;
    public byte[] userData;
    public SmsHeader userDataHeader;
    public boolean isMwi;
    public boolean mwiSense;
    public boolean mwiDontStore;
    public int statusOnIcc = -1;
    public int indexOnIcc = -1;
    public int messageRef;

    public String getServiceCenterAddress() {
        return this.scAddress;
    }

    public String getOriginatingAddress() {
        if (this.originatingAddress == null) {
            return null;
        }
        return this.originatingAddress.getAddressString();
    }

    public String getDisplayOriginatingAddress() {
        if (this.isEmail) {
            return this.emailFrom;
        }
        return this.getOriginatingAddress();
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public abstract SmsMessage.MessageClass getMessageClass();

    public String getDisplayMessageBody() {
        if (this.isEmail) {
            return this.emailBody;
        }
        return this.getMessageBody();
    }

    public String getPseudoSubject() {
        return this.pseudoSubject == null ? "" : this.pseudoSubject;
    }

    public long getTimestampMillis() {
        return this.scTimeMillis;
    }

    public boolean isEmail() {
        return this.isEmail;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public abstract int getProtocolIdentifier();

    public abstract boolean isReplace();

    public abstract boolean isCphsMwiMessage();

    public abstract boolean isMWIClearMessage();

    public abstract boolean isMWISetMessage();

    public abstract boolean isMwiDontStore();

    public byte[] getUserData() {
        return this.userData;
    }

    public SmsHeader getUserDataHeader() {
        return this.userDataHeader;
    }

    public byte[] getPdu() {
        return this.mPdu;
    }

    public abstract int getStatus();

    public abstract boolean isStatusReportMessage();

    public abstract boolean isReplyPathPresent();

    public int getStatusOnIcc() {
        return this.statusOnIcc;
    }

    public int getIndexOnIcc() {
        return this.indexOnIcc;
    }

    public void parseMessageBody() {
        if (this.originatingAddress != null && this.originatingAddress.couldBeEmailGateway()) {
            this.extractEmailAddressFromMessageBody();
        }
    }

    public void extractEmailAddressFromMessageBody() {
        int slash = 0;
        int slash2 = 0;
        int atSymbol = 0;
        try {
            slash = this.messageBody.indexOf(" /");
            if (slash == -1) {
                return;
            }
            atSymbol = this.messageBody.indexOf(64);
            if (atSymbol == -1 || atSymbol > slash) {
                return;
            }
            this.emailFrom = this.messageBody.substring(0, slash);
            slash2 = this.messageBody.indexOf(" /", slash + 2);
            if (slash2 == -1) {
                this.pseudoSubject = null;
                this.emailBody = this.messageBody.substring(slash + 2);
            } else {
                this.pseudoSubject = this.messageBody.substring(slash + 2, slash2);
                this.emailBody = this.messageBody.substring(slash2 + 2);
            }
            this.isEmail = true;
        }
        catch (Exception ex) {
            Log.w(LOG_TAG, "extractEmailAddressFromMessageBody: exception slash=" + slash + ", atSymbol=" + atSymbol + ", slash2=" + slash2, ex);
        }
    }

    public static abstract class SubmitPduBase {
        public byte[] encodedScAddress;
        public byte[] encodedMessage;

        public String toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }
    }

    public static class TextEncodingDetails {
        public int msgCount;
        public int codeUnitCount;
        public int codeUnitsRemaining;
        public int codeUnitSize;
    }
}

