/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import com.android.internal.telephony.AdnRecord;
import com.android.internal.telephony.AdnRecordCache;
import com.android.internal.telephony.AdnRecordLoader;
import com.android.internal.telephony.IccConstants;
import com.android.internal.telephony.PhoneBase;

public abstract class IccRecords
extends Handler
implements IccConstants {
    public static final boolean DBG = true;
    public PhoneBase phone;
    public RegistrantList recordsLoadedRegistrants = new RegistrantList();
    public int recordsToLoad;
    public AdnRecordCache adnCache;
    public boolean recordsRequested = false;
    public String iccid;
    public String msisdn = null;
    public String msisdnTag = null;
    public String voiceMailNum = null;
    public String voiceMailTag = null;
    public String newVoiceMailNum = null;
    public String newVoiceMailTag = null;
    public boolean isVoiceMailFixed = false;
    public int countVoiceMessages = 0;
    public int mncLength = 0;
    public int mailboxIndex = 0;
    public String spn;
    public int spnDisplayCondition;
    public static final int SPN_RULE_SHOW_SPN = 1;
    public static final int SPN_RULE_SHOW_PLMN = 2;
    public static final int EVENT_SET_MSISDN_DONE = 30;

    public IccRecords(PhoneBase p) {
        this.phone = p;
    }

    public abstract void onRadioOffOrNotAvailable();

    public AdnRecordCache getAdnCache() {
        return this.adnCache;
    }

    public void registerForRecordsLoaded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.recordsLoadedRegistrants.add(r);
        if (this.recordsToLoad == 0 && this.recordsRequested) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForRecordsLoaded(Handler h) {
        this.recordsLoadedRegistrants.remove(h);
    }

    public String getMsisdnNumber() {
        return this.msisdn;
    }

    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.msisdn = number;
        this.msisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.msisdnTag + " " + this.msisdn);
        AdnRecord adn = new AdnRecord(this.msisdnTag, this.msisdn);
        new AdnRecordLoader(this.phone).updateEF(adn, 28480, 28490, 1, null, this.obtainMessage(30, onComplete));
    }

    public String getMsisdnAlphaTag() {
        return this.msisdnTag;
    }

    public String getVoiceMailNumber() {
        return this.voiceMailNum;
    }

    public String getServiceProviderName() {
        return this.spn;
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public String getVoiceMailAlphaTag() {
        return this.voiceMailTag;
    }

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public boolean getVoiceMessageWaiting() {
        return this.countVoiceMessages != 0;
    }

    public int getVoiceMessageCount() {
        return this.countVoiceMessages;
    }

    public abstract void onRefresh(boolean var1, int[] var2);

    public boolean getRecordsLoaded() {
        return this.recordsToLoad == 0 && this.recordsRequested;
    }

    public abstract void handleMessage(Message var1);

    public abstract void onRecordLoaded();

    public abstract void onAllRecordsLoaded();

    public abstract int getDisplayRule(String var1);

    public abstract void log(String var1);
}

