/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.text.format.Time;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpDateTime {
    public static final String HTTP_DATE_RFC_REGEXP = "([0-9]{1,2})[- ]([A-Za-z]{3,3})[- ]([0-9]{2,4})[ ]([0-9][0-9]:[0-9][0-9]:[0-9][0-9])";
    public static final String HTTP_DATE_ANSIC_REGEXP = "[ ]([A-Za-z]{3,3})[ ]+([0-9]{1,2})[ ]([0-9][0-9]:[0-9][0-9]:[0-9][0-9])[ ]([0-9]{2,4})";
    public static final Pattern HTTP_DATE_RFC_PATTERN = Pattern.compile("([0-9]{1,2})[- ]([A-Za-z]{3,3})[- ]([0-9]{2,4})[ ]([0-9][0-9]:[0-9][0-9]:[0-9][0-9])");
    public static final Pattern HTTP_DATE_ANSIC_PATTERN = Pattern.compile("[ ]([A-Za-z]{3,3})[ ]+([0-9]{1,2})[ ]([0-9][0-9]:[0-9][0-9]:[0-9][0-9])[ ]([0-9]{2,4})");

    public static Long parse(String timeString) throws IllegalArgumentException {
        int date = 1;
        int month = 0;
        int year = 1970;
        TimeOfDay timeOfDay = new TimeOfDay(null);
        Matcher rfcMatcher = HTTP_DATE_RFC_PATTERN.matcher(timeString);
        if (rfcMatcher.find()) {
            date = HttpDateTime.getDate(rfcMatcher.group(1));
            month = HttpDateTime.getMonth(rfcMatcher.group(2));
            year = HttpDateTime.getYear(rfcMatcher.group(3));
            timeOfDay = HttpDateTime.getTime(rfcMatcher.group(4));
        } else {
            Matcher ansicMatcher = HTTP_DATE_ANSIC_PATTERN.matcher(timeString);
            if (ansicMatcher.find()) {
                month = HttpDateTime.getMonth(ansicMatcher.group(1));
                date = HttpDateTime.getDate(ansicMatcher.group(2));
                timeOfDay = HttpDateTime.getTime(ansicMatcher.group(3));
                year = HttpDateTime.getYear(ansicMatcher.group(4));
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (year >= 2038) {
            year = 2038;
            month = 0;
            date = 1;
        }
        Time time = new Time("UTC");
        time.set(timeOfDay.second, timeOfDay.minute, timeOfDay.hour, date, month, year);
        return time.toMillis(false);
    }

    public static int getDate(String dateString) {
        if (dateString.length() == 2) {
            return (dateString.charAt(0) - 48) * 10 + (dateString.charAt(1) - 48);
        }
        return dateString.charAt(0) - 48;
    }

    public static int getMonth(String monthString) {
        int hash = Character.toLowerCase(monthString.charAt(0)) + Character.toLowerCase(monthString.charAt(1)) + Character.toLowerCase(monthString.charAt(2)) - 291;
        switch (hash) {
            case 22: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 29: {
                return 2;
            }
            case 32: {
                return 3;
            }
            case 36: {
                return 4;
            }
            case 42: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 26: {
                return 7;
            }
            case 37: {
                return 8;
            }
            case 35: {
                return 9;
            }
            case 48: {
                return 10;
            }
            case 9: {
                return 11;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getYear(String yearString) {
        if (yearString.length() == 2) {
            int year = (yearString.charAt(0) - 48) * 10 + (yearString.charAt(1) - 48);
            if (year >= 70) {
                return year + 1900;
            }
            return year + 2000;
        }
        return (yearString.charAt(0) - 48) * 1000 + (yearString.charAt(1) - 48) * 100 + (yearString.charAt(2) - 48) * 10 + (yearString.charAt(3) - 48);
    }

    public static TimeOfDay getTime(String timeString) {
        TimeOfDay time = new TimeOfDay(null);
        time.hour = (timeString.charAt(0) - 48) * 10 + (timeString.charAt(1) - 48);
        time.minute = (timeString.charAt(3) - 48) * 10 + (timeString.charAt(4) - 48);
        time.second = (timeString.charAt(6) - 48) * 10 + (timeString.charAt(7) - 48);
        return time;
    }

    public static class 1 {
    }

    public static class TimeOfDay {
        public int hour;
        public int minute;
        public int second;

        public TimeOfDay() {
        }

        public /* synthetic */ TimeOfDay(1 x0) {
            this();
        }
    }
}

