/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.provider.Settings;
import java.io.File;
import java.util.HashSet;

public class GearsPermissionsManager {
    public Context mContext;
    public String mGearsPath;
    public static final String GEARS_DATABASE_DIR = "gears";
    public static final String GEARS_DATABASE_FILE = "permissions.db";
    public static final String GEARS_LOCATION_ACCESS_TABLE_NAME = "LocationAccess";
    public static final String GEARS_STORAGE_ACCESS_TABLE_NAME = "Access";
    public static final String GEARS_SCHEMA_VERSION_TABLE_NAME = "VersionInfo";
    public static final int GEARS_ALLOW_LOCATION_ACCESS = 1;
    public static final String LAST_KNOWN_LOCATION_SETTING = "lastKnownLocationSystemSetting";
    public static final String BROWSER_PACKAGE_NAME = "com.android.browser";
    public SecureSettingsObserver mSettingsObserver;
    public static HashSet<String> sGearsWhiteList = new HashSet();
    public static final String LOGTAG = "webcore";
    public static final boolean DEBUG = false;
    public static final boolean LOGV_ENABLED = false;

    public GearsPermissionsManager(Context context, String gearsPath) {
        this.mContext = context;
        this.mGearsPath = gearsPath;
    }

    public void doCheckAndStartObserver() {
        if (!BROWSER_PACKAGE_NAME.equals(this.mContext.getPackageName())) {
            return;
        }
        this.checkGearsPermissions();
        this.mSettingsObserver = new SecureSettingsObserver();
        this.mSettingsObserver.observe();
    }

    public void checkGearsPermissions() {
        int setting = Settings.Secure.getInt(this.mContext.getContentResolver(), "use_location", -1);
        if (setting != -1 && this.locationSystemSettingChanged(setting)) {
            this.setGearsPermissionForGoogleDomains(setting);
        }
    }

    public boolean locationSystemSettingChanged(int newSetting) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        int oldSetting = 0;
        if ((oldSetting = prefs.getInt(LAST_KNOWN_LOCATION_SETTING, oldSetting)) == newSetting) {
            return false;
        }
        SharedPreferences.Editor ed = prefs.edit();
        ed.putInt(LAST_KNOWN_LOCATION_SETTING, newSetting);
        ed.commit();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGearsPermissionForGoogleDomains(int systemPermission) {
        SQLiteDatabase permissions;
        boolean addToGearsLocationTable = systemPermission == 1;
        File file = new File(this.mGearsPath).getParentFile();
        if (file == null) {
            return;
        }
        file = new File(file.getAbsolutePath() + File.separator + GEARS_DATABASE_DIR + File.separator + GEARS_DATABASE_FILE);
        boolean needToCreateTables = false;
        if (!file.exists()) {
            needToCreateTables = true;
            file.getParentFile().mkdirs();
        }
        if (needToCreateTables && !addToGearsLocationTable) {
            return;
        }
        try {
            permissions = SQLiteDatabase.openOrCreateDatabase(file, null);
        }
        catch (SQLiteException e) {
            return;
        }
        permissions.beginTransaction();
        try {
            try {
                if (needToCreateTables) {
                    SQLiteStatement statement = permissions.compileStatement("CREATE TABLE IF NOT EXISTS Access (Name TEXT UNIQUE, Value)");
                    statement.execute();
                    statement = permissions.compileStatement("CREATE TABLE IF NOT EXISTS LocationAccess (Name TEXT UNIQUE, Value)");
                    statement.execute();
                    statement = permissions.compileStatement("CREATE TABLE IF NOT EXISTS VersionInfo (Name TEXT UNIQUE, Value)");
                    statement.execute();
                    ContentValues schema = new ContentValues();
                    schema.put("Name", "Version");
                    schema.put("Value", 2);
                    permissions.insert(GEARS_SCHEMA_VERSION_TABLE_NAME, null, schema);
                }
                if (addToGearsLocationTable) {
                    ContentValues permissionValues = new ContentValues();
                    for (String url : sGearsWhiteList) {
                        permissionValues.put("Name", url);
                        permissionValues.put("Value", 1);
                        permissions.replace(GEARS_LOCATION_ACCESS_TABLE_NAME, null, permissionValues);
                        permissionValues.clear();
                    }
                } else {
                    for (String url : sGearsWhiteList) {
                        permissions.delete(GEARS_LOCATION_ACCESS_TABLE_NAME, "Name=?", new String[]{url});
                    }
                }
                permissions.setTransactionSuccessful();
            }
            catch (SQLiteException e) {
                Object var10_12 = null;
                permissions.endTransaction();
                permissions.close();
            }
            Object var10_11 = null;
            permissions.endTransaction();
            permissions.close();
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            permissions.endTransaction();
            permissions.close();
            throw throwable;
        }
    }

    static {
        sGearsWhiteList.add("http://www.google.com");
        sGearsWhiteList.add("http://www.google.co.uk");
    }

    public class SecureSettingsObserver
    extends ContentObserver {
        public SecureSettingsObserver() {
            super(new Handler());
        }

        public void observe() {
            ContentResolver resolver = GearsPermissionsManager.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("use_location"), false, this);
        }

        public void onChange(boolean selfChange) {
            GearsPermissionsManager.this.checkGearsPermissions();
        }
    }
}

