/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewRoot;
import android.view.WindowManager;
import android.view._Original_SurfaceView$1;
import android.view._Original_SurfaceView$2;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class _Original_SurfaceView
extends View {
    public static final String TAG = "SurfaceView";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    public final int[] mLocation = new int[2];
    public final ReentrantLock mSurfaceLock = new ReentrantLock();
    public final Surface mSurface = new Surface();
    public boolean mDrawingStopped = true;
    public final WindowManager.LayoutParams mLayout = new WindowManager.LayoutParams();
    public IWindowSession mSession;
    public MyWindow mWindow;
    public final Rect mVisibleInsets = new Rect();
    public final Rect mWinFrame = new Rect();
    public final Rect mContentInsets = new Rect();
    public static final int KEEP_SCREEN_ON_MSG = 1;
    public static final int GET_NEW_SURFACE_MSG = 2;
    public int mWindowType = 1001;
    public boolean mIsCreating = false;
    public final Handler mHandler = new _Original_SurfaceView$1(this);
    public boolean mRequestedVisible = false;
    public int mRequestedWidth = -1;
    public int mRequestedHeight = -1;
    public int mRequestedFormat = -1;
    public int mRequestedType = -1;
    public boolean mHaveFrame = false;
    public boolean mDestroyReportNeeded = false;
    public boolean mNewSurfaceNeeded = false;
    public long mLastLockTime = 0L;
    public boolean mVisible = false;
    public int mLeft = -1;
    public int mTop = -1;
    public int mWidth = -1;
    public int mHeight = -1;
    public int mFormat = -1;
    public int mType = -1;
    public final Rect mSurfaceFrame = new Rect();
    public CompatibilityInfo.Translator mTranslator;
    public SurfaceHolder mSurfaceHolder = new _Original_SurfaceView$2(this);

    public _Original_SurfaceView(Context context) {
        super(context);
        this.setWillNotDraw(true);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(true);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(true);
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mParent.requestTransparentRegion(this);
        this.mSession = this.getWindowSession();
        this.mLayout.token = this.getWindowToken();
        this.mLayout.setTitle(TAG);
    }

    public void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mRequestedVisible = visibility == 0;
        this.updateWindow(false);
    }

    public void onDetachedFromWindow() {
        this.mRequestedVisible = false;
        this.updateWindow(false);
        this.mHaveFrame = false;
        if (this.mWindow != null) {
            try {
                this.mSession.remove(this.mWindow);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mWindow = null;
        }
        this.mSession = null;
        this.mLayout.token = null;
        super.onDetachedFromWindow();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = _Original_SurfaceView.getDefaultSize(this.mRequestedWidth, widthMeasureSpec);
        int height = _Original_SurfaceView.getDefaultSize(this.mRequestedHeight, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.updateWindow(false);
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateWindow(false);
    }

    public boolean gatherTransparentRegion(Region region) {
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    public void draw(Canvas canvas) {
        if ((this.mPrivateFlags & 0x80) == 0) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.draw(canvas);
    }

    public void dispatchDraw(Canvas canvas) {
        if ((this.mPrivateFlags & 0x80) == 128) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.mHaveFrame = true;
        this.updateWindow(false);
        super.dispatchDraw(canvas);
    }

    public void setWindowType(int type) {
        this.mWindowType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateWindow(boolean force) {
        boolean typeChanged;
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRoot viewRoot = (ViewRoot)this.getRootView().getParent();
        this.mTranslator = viewRoot.mTranslator;
        Resources res = this.getContext().getResources();
        if (this.mTranslator != null || !res.getCompatibilityInfo().supportsScreen()) {
            this.mSurface.setCompatibleDisplayMetrics(res.getDisplayMetrics(), this.mTranslator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        this.getLocationInWindow(this.mLocation);
        boolean creating = this.mWindow == null;
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean sizeChanged = this.mWidth != myWidth || this.mHeight != myHeight;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible || this.mNewSurfaceNeeded;
        boolean bl = typeChanged = this.mType != this.mRequestedType;
        if (!force && !creating && !formatChanged && !sizeChanged && !visibleChanged && !typeChanged && this.mLeft == this.mLocation[0] && this.mTop == this.mLocation[1]) return;
        try {
            boolean visible = this.mVisible = this.mRequestedVisible;
            this.mLeft = this.mLocation[0];
            this.mTop = this.mLocation[1];
            this.mWidth = myWidth;
            this.mHeight = myHeight;
            this.mFormat = this.mRequestedFormat;
            this.mType = this.mRequestedType;
            this.mLayout.x = this.mLeft;
            this.mLayout.y = this.mTop;
            this.mLayout.width = this.getWidth();
            this.mLayout.height = this.getHeight();
            if (this.mTranslator != null) {
                this.mTranslator.translateLayoutParamsInAppWindowToScreen(this.mLayout);
            }
            this.mLayout.format = this.mRequestedFormat;
            this.mLayout.flags |= 0x4218;
            if (!this.getContext().getResources().getCompatibilityInfo().supportsScreen()) {
                this.mLayout.flags |= 0x100000;
            }
            this.mLayout.memoryType = this.mRequestedType;
            if (this.mWindow == null) {
                this.mWindow = new MyWindow(this);
                this.mLayout.type = this.mWindowType;
                this.mLayout.gravity = 51;
                this.mSession.add(this.mWindow, this.mLayout, this.mVisible ? 0 : 8, this.mContentInsets);
            }
            if (visibleChanged && (!visible || this.mNewSurfaceNeeded)) {
                this.reportSurfaceDestroyed();
            }
            this.mNewSurfaceNeeded = false;
            this.mSurfaceLock.lock();
            this.mDrawingStopped = !visible;
            int relayoutResult = this.mSession.relayout(this.mWindow, this.mLayout, this.mWidth, this.mHeight, visible ? 0 : 8, false, this.mWinFrame, this.mContentInsets, this.mVisibleInsets, this.mSurface);
            this.mSurfaceFrame.left = 0;
            this.mSurfaceFrame.top = 0;
            if (this.mTranslator == null) {
                this.mSurfaceFrame.right = this.mWinFrame.width();
                this.mSurfaceFrame.bottom = this.mWinFrame.height();
            } else {
                float appInvertedScale = this.mTranslator.applicationInvertedScale;
                this.mSurfaceFrame.right = (int)((float)this.mWinFrame.width() * appInvertedScale + 0.5f);
                this.mSurfaceFrame.bottom = (int)((float)this.mWinFrame.height() * appInvertedScale + 0.5f);
            }
            this.mSurfaceLock.unlock();
            try {
                if (visible) {
                    SurfaceHolder.Callback[] callbacks;
                    this.mDestroyReportNeeded = true;
                    ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
                    synchronized (arrayList) {
                        callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
                        this.mCallbacks.toArray(callbacks);
                    }
                    if (visibleChanged) {
                        this.mIsCreating = true;
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceCreated(this.mSurfaceHolder);
                        }
                    }
                    if (creating || formatChanged || sizeChanged || visibleChanged) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mWidth, this.mHeight);
                        }
                    }
                }
                Object var19_21 = null;
                this.mIsCreating = false;
                if (!creating && (relayoutResult & 2) == 0) return;
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                this.mIsCreating = false;
                if (!creating && (relayoutResult & 2) == 0) throw throwable;
                this.mSession.finishDrawing(this.mWindow);
                throw throwable;
            }
            this.mSession.finishDrawing(this.mWindow);
            return;
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSurfaceDestroyed() {
        if (this.mDestroyReportNeeded) {
            SurfaceHolder.Callback[] callbacks;
            this.mDestroyReportNeeded = false;
            ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
            synchronized (arrayList) {
                callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
                this.mCallbacks.toArray(callbacks);
            }
            for (SurfaceHolder.Callback c : callbacks) {
                c.surfaceDestroyed(this.mSurfaceHolder);
            }
        }
        super.onDetachedFromWindow();
    }

    public void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.updateWindow(false);
    }

    public static /* synthetic */ void access$000(_Original_SurfaceView x0, boolean x1) {
        x0.updateWindow(x1);
    }

    public static class MyWindow
    extends IWindow.Stub {
        public final WeakReference<_Original_SurfaceView> mSurfaceView;
        public int mCurWidth = -1;
        public int mCurHeight = -1;

        public MyWindow(_Original_SurfaceView surfaceView) {
            this.mSurfaceView = new WeakReference<_Original_SurfaceView>(surfaceView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw) {
            _Original_SurfaceView surfaceView = (_Original_SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                MyWindow myWindow = this;
                synchronized (myWindow) {
                    if (this.mCurWidth != w || this.mCurHeight != h) {
                        this.mCurWidth = w;
                        this.mCurHeight = h;
                    }
                    if (reportDraw) {
                        try {
                            surfaceView.mSession.finishDrawing(surfaceView.mWindow);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void dispatchKey(KeyEvent event) {
            _Original_SurfaceView surfaceView = (_Original_SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null && surfaceView.mSession != null && surfaceView.mSurface != null) {
                try {
                    surfaceView.mSession.finishKey(surfaceView.mWindow);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void dispatchPointer(MotionEvent event, long eventTime) {
            Log.w(_Original_SurfaceView.TAG, "Unexpected pointer event in surface: " + event);
        }

        public void dispatchTrackball(MotionEvent event, long eventTime) {
            Log.w(_Original_SurfaceView.TAG, "Unexpected trackball event in surface: " + event);
        }

        public void dispatchAppVisibility(boolean visible) {
        }

        public void dispatchGetNewSurface() {
            _Original_SurfaceView surfaceView = (_Original_SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                Message msg = surfaceView.mHandler.obtainMessage(2);
                surfaceView.mHandler.sendMessage(msg);
            }
        }

        public void windowFocusChanged(boolean hasFocus, boolean touchEnabled) {
            Log.w(_Original_SurfaceView.TAG, "Unexpected focus in surface: focus=" + hasFocus + ", touchEnabled=" + touchEnabled);
        }

        public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
        }
    }
}

