/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;

public class BulletSpan
implements LeadingMarginSpan,
ParcelableSpan {
    public final int mGapWidth;
    public final boolean mWantColor;
    public final int mColor;
    public static final int BULLET_RADIUS = 3;
    public static final int STANDARD_GAP_WIDTH = 2;

    public BulletSpan() {
        this.mGapWidth = 2;
        this.mWantColor = false;
        this.mColor = 0;
    }

    public BulletSpan(int gapWidth) {
        this.mGapWidth = gapWidth;
        this.mWantColor = false;
        this.mColor = 0;
    }

    public BulletSpan(int gapWidth, int color2) {
        this.mGapWidth = gapWidth;
        this.mWantColor = true;
        this.mColor = color2;
    }

    public BulletSpan(Parcel src) {
        this.mGapWidth = src.readInt();
        this.mWantColor = src.readInt() != 0;
        this.mColor = src.readInt();
    }

    public int getSpanTypeId() {
        return 8;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mGapWidth);
        dest.writeInt(this.mWantColor ? 1 : 0);
        dest.writeInt(this.mColor);
    }

    public int getLeadingMargin(boolean first) {
        return 6 + this.mGapWidth;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
        if (((Spanned)text).getSpanStart(this) == start) {
            Paint.Style style2 = p.getStyle();
            int oldcolor = 0;
            if (this.mWantColor) {
                oldcolor = p.getColor();
                p.setColor(this.mColor);
            }
            p.setStyle(Paint.Style.FILL);
            c.drawCircle(x + dir * 3, (float)(top + bottom) / 2.0f, 3.0f, p);
            if (this.mWantColor) {
                p.setColor(oldcolor);
            }
            p.setStyle(style2);
        }
    }
}

