/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.Context;
import android.content.Intent;
import android.security.Keystore;
import android.text.TextUtils;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;

public class CertTool {
    public static final String ACTION_ADD_CREDENTIAL = "android.security.ADD_CREDENTIAL";
    public static final String KEY_TYPE_NAME = "typeName";
    public static final String KEY_ITEM = "item";
    public static final String KEY_NAMESPACE = "namespace";
    public static final String KEY_DESCRIPTION = "description";
    public static final String TITLE_CA_CERT = "CA Certificate";
    public static final String TITLE_USER_CERT = "User Certificate";
    public static final String TITLE_PKCS12_KEYSTORE = "PKCS12 Keystore";
    public static final String TITLE_PRIVATE_KEY = "Private Key";
    public static final int INCORRECT_PKCS12_PASSPHRASE = -100;
    public static final String TAG = "CertTool";
    public static final String UNKNOWN = "Unknown";
    public static final String ISSUER_NAME = "Issuer Name:";
    public static final String DISTINCT_NAME = "Distinct Name:";
    public static final String CA_CERTIFICATE = "CACERT";
    public static final String USER_CERTIFICATE = "USRCERT";
    public static final String USER_KEY = "USRKEY";
    public static final String KEYNAME_DELIMITER = "_";
    public static final Keystore sKeystore;
    public static CertTool singleton;

    public int getPkcs12Handle(byte[] byArray, String string2) {
        return OverrideMethod.invokeI("android.security.CertTool#getPkcs12Handle([BLjava/lang/String;)I", true, this);
    }

    public String getPkcs12Certificate(int n) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#getPkcs12Certificate(I)Ljava/lang/String;", true, this);
    }

    public String getPkcs12PrivateKey(int n) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#getPkcs12PrivateKey(I)Ljava/lang/String;", true, this);
    }

    public String popPkcs12CertificateStack(int n) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#popPkcs12CertificateStack(I)Ljava/lang/String;", true, this);
    }

    public void freePkcs12Handle(int n) {
        OverrideMethod.invokeV("android.security.CertTool#freePkcs12Handle(I)V", true, this);
    }

    public String generateCertificateRequest(int n, String string2) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#generateCertificateRequest(ILjava/lang/String;)Ljava/lang/String;", true, this);
    }

    public boolean isPkcs12Keystore(byte[] byArray) {
        return OverrideMethod.invokeI("android.security.CertTool#isPkcs12Keystore([B)Z", true, this) != 0;
    }

    public int generateX509Certificate(byte[] byArray) {
        return OverrideMethod.invokeI("android.security.CertTool#generateX509Certificate([B)I", true, this);
    }

    public boolean isCaCertificate(int n) {
        return OverrideMethod.invokeI("android.security.CertTool#isCaCertificate(I)Z", true, this) != 0;
    }

    public String getIssuerDN(int n) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#getIssuerDN(I)Ljava/lang/String;", true, this);
    }

    public String getCertificateDN(int n) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#getCertificateDN(I)Ljava/lang/String;", true, this);
    }

    public String getPrivateKeyPEM(int n) {
        return (String)OverrideMethod.invokeA("android.security.CertTool#getPrivateKeyPEM(I)Ljava/lang/String;", true, this);
    }

    public void freeX509Certificate(int n) {
        OverrideMethod.invokeV("android.security.CertTool#freeX509Certificate(I)V", true, this);
    }

    public static CertTool getInstance() {
        if (singleton == null) {
            singleton = new CertTool();
        }
        return singleton;
    }

    public String getUserPrivateKey(String key) {
        return "USRKEY_" + key;
    }

    public String getUserCertificate(String key) {
        return "USRCERT_" + key;
    }

    public String getCaCertificate(String key) {
        return "CACERT_" + key;
    }

    public String[] getAllUserCertificateKeys() {
        return sKeystore.listKeys(USER_KEY);
    }

    public String[] getAllCaCertificateKeys() {
        return sKeystore.listKeys(CA_CERTIFICATE);
    }

    public String[] getSupportedKeyStrenghs() {
        return new String[]{"High Grade", "Medium Grade"};
    }

    public int getKeyLength(int index) {
        if (index == 0) {
            return 2048;
        }
        return 1024;
    }

    public String generateKeyPair(int keyStrengthIndex, String challenge, String dirName) {
        return this.generateCertificateRequest(this.getKeyLength(keyStrengthIndex), challenge);
    }

    public Intent prepareIntent(String title, byte[] data, String namespace, String issuer, String distinctName) {
        Intent intent = new Intent(ACTION_ADD_CREDENTIAL);
        intent.putExtra(KEY_TYPE_NAME, title);
        intent.putExtra("item0", data);
        intent.putExtra("namespace0", namespace);
        intent.putExtra("description0", ISSUER_NAME + issuer);
        intent.putExtra("description1", DISTINCT_NAME + distinctName);
        return intent;
    }

    public void addExtraIntentInfo(Intent intent, String namespace, String data) {
        intent.putExtra("item1", data.getBytes());
        intent.putExtra("namespace1", namespace);
    }

    public int extractAndStoreKeysFromPkcs12(int handle, String keyname) {
        int ret;
        int i = 0;
        String pemData = this.getPkcs12Certificate(handle);
        if (pemData != null && (ret = sKeystore.put(USER_CERTIFICATE, keyname, pemData)) != 0) {
            return ret;
        }
        pemData = this.getPkcs12PrivateKey(handle);
        if (pemData != null && (ret = sKeystore.put(USER_KEY, keyname, pemData)) != 0) {
            return ret;
        }
        while ((pemData = this.popPkcs12CertificateStack(handle)) != null) {
            if (!(i++ > 0 ? (ret = sKeystore.put(CA_CERTIFICATE, keyname + i, pemData)) != 0 : (ret = sKeystore.put(CA_CERTIFICATE, keyname, pemData)) != 0)) continue;
            return ret;
        }
        return 0;
    }

    public int addPkcs12Keystore(byte[] p12Data, String password, String keyname) {
        Log.i(TAG, "addPkcs12Keystore()");
        int handle = this.getPkcs12Handle(p12Data, password);
        if (handle == 0) {
            return -100;
        }
        int ret = this.extractAndStoreKeysFromPkcs12(handle, keyname);
        this.freePkcs12Handle(handle);
        return ret;
    }

    public synchronized void addCertificate(byte[] data, Context context) {
        Intent intent = null;
        Log.i(TAG, "addCertificate()");
        if (this.isPkcs12Keystore(data)) {
            intent = this.prepareIntent(TITLE_PKCS12_KEYSTORE, data, USER_KEY, UNKNOWN, UNKNOWN);
        } else {
            int handle = this.generateX509Certificate(data);
            if (handle != 0) {
                String issuer = this.getIssuerDN(handle);
                String distinctName = this.getCertificateDN(handle);
                String privateKeyPEM = this.getPrivateKeyPEM(handle);
                if (this.isCaCertificate(handle)) {
                    intent = this.prepareIntent(TITLE_CA_CERT, data, CA_CERTIFICATE, issuer, distinctName);
                } else {
                    intent = this.prepareIntent(TITLE_USER_CERT, data, USER_CERTIFICATE, issuer, distinctName);
                    if (!TextUtils.isEmpty(privateKeyPEM)) {
                        this.addExtraIntentInfo(intent, USER_KEY, privateKeyPEM);
                    }
                }
                this.freeX509Certificate(handle);
            }
        }
        if (intent != null) {
            context.startActivity(intent);
        } else {
            Log.w(TAG, "incorrect data for addCertificate()");
        }
    }

    static {
        System.loadLibrary("certtool_jni");
        sKeystore = Keystore.getInstance();
        singleton = null;
    }
}

