/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bouncycastle.asn1.x509.X509Name;

public class DomainNameChecker {
    public static Pattern QUICK_IP_PATTERN;
    public static final int ALT_DNS_NAME = 2;
    public static final int ALT_IPA_NAME = 7;

    public static boolean match(X509Certificate certificate, String thisDomain) {
        if (certificate == null || thisDomain == null || thisDomain.length() == 0) {
            return false;
        }
        if (!DomainNameChecker.isIpAddress(thisDomain = thisDomain.toLowerCase())) {
            return DomainNameChecker.matchDns(certificate, thisDomain);
        }
        return DomainNameChecker.matchIpAddress(certificate, thisDomain);
    }

    public static boolean isIpAddress(String domain) {
        boolean rval;
        boolean bl = rval = domain != null && domain.length() != 0;
        if (rval) {
            try {
                rval = QUICK_IP_PATTERN.matcher(domain).matches();
                if (rval) {
                    rval = domain.equals(InetAddress.getByName(domain).getHostAddress());
                }
            }
            catch (UnknownHostException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "unknown host exception";
                }
                rval = false;
            }
        }
        return rval;
    }

    public static boolean matchIpAddress(X509Certificate certificate, String thisDomain) {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> altNameEntry : subjectAltNames) {
                    String altName;
                    Integer altNameType;
                    if (altNameEntry == null || 2 > altNameEntry.size() || (altNameType = (Integer)altNameEntry.get(0)) == null || altNameType != 7 || (altName = (String)altNameEntry.get(1)) == null || !thisDomain.equalsIgnoreCase(altName)) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }

    public static boolean matchDns(X509Certificate certificate, String thisDomain) {
        boolean hasDns = false;
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> altNameEntry : subjectAltNames) {
                    Integer altNameType;
                    if (altNameEntry == null || 2 > altNameEntry.size() || (altNameType = (Integer)altNameEntry.get(0)) == null || altNameType != 2) continue;
                    hasDns = true;
                    String altName = (String)altNameEntry.get(1);
                    if (altName == null || !DomainNameChecker.matchDns(thisDomain, altName)) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException e) {
            // empty catch block
        }
        if (!hasDns) {
            X509Name xName = new X509Name(certificate.getSubjectDN().getName());
            Vector val = xName.getValues();
            Vector oid = xName.getOIDs();
            for (int i = 0; i < oid.size(); ++i) {
                if (!oid.elementAt(i).equals(X509Name.CN)) continue;
                return DomainNameChecker.matchDns(thisDomain, (String)val.elementAt(i));
            }
        }
        return false;
    }

    public static boolean matchDns(String thisDomain, String thatDomain) {
        String[] thatDomainTokens;
        int thatDomainTokensNum;
        String[] thisDomainTokens;
        int thisDomainTokensNum;
        if (thisDomain == null || thisDomain.length() == 0 || thatDomain == null || thatDomain.length() == 0) {
            return false;
        }
        boolean rval = thisDomain.equals(thatDomain = thatDomain.toLowerCase());
        if (!rval && (thisDomainTokensNum = (thisDomainTokens = thisDomain.split("\\.")).length) >= (thatDomainTokensNum = (thatDomainTokens = thatDomain.split("\\.")).length)) {
            for (int i = thatDomainTokensNum - 1; i >= 0; --i) {
                rval = thisDomainTokens[i].equals(thatDomainTokens[i]);
                if (rval) continue;
                boolean bl = rval = i == 0 && thisDomainTokensNum == thatDomainTokensNum;
                if (!rval || (rval = thatDomainTokens[0].equals("*"))) break;
                rval = DomainNameChecker.domainTokenMatch(thisDomainTokens[0], thatDomainTokens[0]);
                break;
            }
        }
        return rval;
    }

    public static boolean domainTokenMatch(String thisDomainToken, String thatDomainToken) {
        int starIndex;
        if (thisDomainToken != null && thatDomainToken != null && (starIndex = thatDomainToken.indexOf(42)) >= 0 && thatDomainToken.length() - 1 <= thisDomainToken.length()) {
            String prefix = thatDomainToken.substring(0, starIndex);
            String suffix = thatDomainToken.substring(starIndex + 1);
            return thisDomainToken.startsWith(prefix) && thisDomainToken.endsWith(suffix);
        }
        return false;
    }

    static {
        try {
            QUICK_IP_PATTERN = Pattern.compile("^[a-f0-9\\.:]+$");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

