/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.Connection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestQueue;
import android.os.Process;
import android.os.SystemClock;
import org.apache.http.HttpHost;

public class ConnectionThread
extends Thread {
    public static final int WAIT_TIMEOUT = 5000;
    public static final int WAIT_TICK = 1000;
    public long mStartThreadTime;
    public long mCurrentThreadTime;
    public boolean mWaiting;
    public volatile boolean mRunning = true;
    public Context mContext;
    public RequestQueue.ConnectionManager mConnectionManager;
    public RequestFeeder mRequestFeeder;
    public int mId;
    public Connection mConnection;

    public ConnectionThread(Context context, int id2, RequestQueue.ConnectionManager connectionManager, RequestFeeder requestFeeder) {
        this.mContext = context;
        this.setName("http" + id2);
        this.mId = id2;
        this.mConnectionManager = connectionManager;
        this.mRequestFeeder = requestFeeder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            this.mRunning = false;
            this.mRequestFeeder.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Process.setThreadPriority(1);
        this.mStartThreadTime = -1L;
        this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
        while (this.mRunning) {
            Request request = this.mRequestFeeder.getRequest();
            if (request == null) {
                RequestFeeder requestFeeder = this.mRequestFeeder;
                synchronized (requestFeeder) {
                    this.mWaiting = true;
                    try {
                        if (this.mStartThreadTime != -1L) {
                            this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
                        }
                        this.mRequestFeeder.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.mWaiting = false;
                    continue;
                }
            }
            HttpHost proxy = this.mConnectionManager.getProxyHost();
            HttpHost host = proxy == null || request.mHost.getSchemeName().equals("https") ? request.mHost : proxy;
            this.mConnection = this.mConnectionManager.getConnection(this.mContext, host);
            this.mConnection.processRequests(request);
            if (this.mConnection.getCanPersist()) {
                if (!this.mConnectionManager.recycleConnection(host, this.mConnection)) {
                    this.mConnection.closeConnection();
                }
            } else {
                this.mConnection.closeConnection();
            }
            this.mConnection = null;
        }
    }

    public synchronized String toString() {
        String con = this.mConnection == null ? "" : this.mConnection.toString();
        String active = this.mWaiting ? "w" : "a";
        return "cid " + this.mId + " " + active + " " + con;
    }
}

