/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyboardView
extends View
implements View.OnClickListener {
    public static final boolean DEBUG = false;
    public static final int NOT_A_KEY = -1;
    public static final int[] KEY_DELETE = new int[]{-5};
    public static final int[] LONG_PRESSABLE_STATE_SET = new int[]{16843324};
    public Keyboard mKeyboard;
    public int mCurrentKeyIndex = -1;
    public int mLabelTextSize;
    public int mKeyTextSize;
    public int mKeyTextColor;
    public float mShadowRadius;
    public int mShadowColor;
    public float mBackgroundDimAmount;
    public TextView mPreviewText;
    public PopupWindow mPreviewPopup;
    public int mPreviewTextSizeLarge;
    public int mPreviewOffset;
    public int mPreviewHeight;
    public int[] mOffsetInWindow;
    public PopupWindow mPopupKeyboard;
    public View mMiniKeyboardContainer;
    public KeyboardView mMiniKeyboard;
    public boolean mMiniKeyboardOnScreen;
    public View mPopupParent;
    public int mMiniKeyboardOffsetX;
    public int mMiniKeyboardOffsetY;
    public Map<Keyboard.Key, View> mMiniKeyboardCache;
    public int[] mWindowOffset;
    public Keyboard.Key[] mKeys;
    public OnKeyboardActionListener mKeyboardActionListener;
    public static final int MSG_SHOW_PREVIEW = 1;
    public static final int MSG_REMOVE_PREVIEW = 2;
    public static final int MSG_REPEAT = 3;
    public static final int MSG_LONGPRESS = 4;
    public static final int DELAY_BEFORE_PREVIEW = 40;
    public static final int DELAY_AFTER_PREVIEW = 60;
    public int mVerticalCorrection;
    public int mProximityThreshold;
    public boolean mPreviewCentered = false;
    public boolean mShowPreview = true;
    public boolean mShowTouchPoints = true;
    public int mPopupPreviewX;
    public int mPopupPreviewY;
    public int mLastX;
    public int mLastY;
    public int mStartX;
    public int mStartY;
    public boolean mProximityCorrectOn;
    public Paint mPaint;
    public Rect mPadding;
    public long mDownTime;
    public long mLastMoveTime;
    public int mLastKey;
    public int mLastCodeX;
    public int mLastCodeY;
    public int mCurrentKey = -1;
    public long mLastKeyTime;
    public long mCurrentKeyTime;
    public int[] mKeyIndices = new int[12];
    public GestureDetector mGestureDetector;
    public int mPopupX;
    public int mPopupY;
    public int mRepeatKeyIndex = -1;
    public int mPopupLayout;
    public boolean mAbortKey;
    public Keyboard.Key mInvalidatedKey;
    public Rect mClipRegion = new Rect(0, 0, 0, 0);
    public Drawable mKeyBackground;
    public static final int REPEAT_INTERVAL = 50;
    public static final int REPEAT_START_DELAY = 400;
    public static final int LONGPRESS_TIMEOUT = 800;
    public static int MAX_NEARBY_KEYS = 12;
    public int[] mDistances = new int[MAX_NEARBY_KEYS];
    public int mLastSentIndex;
    public int mTapCount;
    public long mLastTapTime;
    public boolean mInMultiTap;
    public static final int MULTITAP_INTERVAL = 800;
    public StringBuilder mPreviewLabel = new StringBuilder(1);
    public boolean mDrawPending;
    public Rect mDirtyRect = new Rect();
    public Bitmap mBuffer;
    public Canvas mCanvas;
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    KeyboardView.this.showKey(msg.arg1);
                    break;
                }
                case 2: {
                    KeyboardView.this.mPreviewText.setVisibility(4);
                    break;
                }
                case 3: {
                    if (!KeyboardView.this.repeatKey()) break;
                    Message repeat = Message.obtain((Handler)this, 3);
                    this.sendMessageDelayed(repeat, 50L);
                    break;
                }
                case 4: {
                    KeyboardView.this.openPopupIfRequired((MotionEvent)msg.obj);
                }
            }
        }
    };

    public KeyboardView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843418);
    }

    public KeyboardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyboardView, defStyle, 0);
        LayoutInflater inflate = (LayoutInflater)context.getSystemService("layout_inflater");
        int previewLayout = 0;
        boolean keyTextSize = false;
        int n = a.getIndexCount();
        block13: for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 2: {
                    this.mKeyBackground = a.getDrawable(attr2);
                    continue block13;
                }
                case 9: {
                    this.mVerticalCorrection = a.getDimensionPixelOffset(attr2, 0);
                    continue block13;
                }
                case 6: {
                    previewLayout = a.getResourceId(attr2, 0);
                    continue block13;
                }
                case 7: {
                    this.mPreviewOffset = a.getDimensionPixelOffset(attr2, 0);
                    continue block13;
                }
                case 8: {
                    this.mPreviewHeight = a.getDimensionPixelSize(attr2, 80);
                    continue block13;
                }
                case 3: {
                    this.mKeyTextSize = a.getDimensionPixelSize(attr2, 18);
                    continue block13;
                }
                case 5: {
                    this.mKeyTextColor = a.getColor(attr2, -16777216);
                    continue block13;
                }
                case 4: {
                    this.mLabelTextSize = a.getDimensionPixelSize(attr2, 14);
                    continue block13;
                }
                case 10: {
                    this.mPopupLayout = a.getResourceId(attr2, 0);
                    continue block13;
                }
                case 0: {
                    this.mShadowColor = a.getColor(attr2, 0);
                    continue block13;
                }
                case 1: {
                    this.mShadowRadius = a.getFloat(attr2, 0.0f);
                }
            }
        }
        a = this.mContext.obtainStyledAttributes(R.styleable.Theme);
        this.mBackgroundDimAmount = a.getFloat(2, 0.5f);
        this.mPreviewPopup = new PopupWindow(context);
        if (previewLayout != 0) {
            this.mPreviewText = (TextView)inflate.inflate(previewLayout, null);
            this.mPreviewTextSizeLarge = (int)this.mPreviewText.getTextSize();
            this.mPreviewPopup.setContentView(this.mPreviewText);
            this.mPreviewPopup.setBackgroundDrawable(null);
        } else {
            this.mShowPreview = false;
        }
        this.mPreviewPopup.setTouchable(false);
        this.mPopupKeyboard = new PopupWindow(context);
        this.mPopupKeyboard.setBackgroundDrawable(null);
        this.mPopupParent = this;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)keyTextSize);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPadding = new Rect(0, 0, 0, 0);
        this.mMiniKeyboardCache = new HashMap<Keyboard.Key, View>();
        this.mKeyBackground.getPadding(this.mPadding);
        this.resetMultiTap();
        this.initGestureDetector();
    }

    public void initGestureDetector() {
        this.mGestureDetector = new GestureDetector(this.getContext(), new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent me1, MotionEvent me2, float velocityX, float velocityY) {
                float absX = Math.abs(velocityX);
                float absY = Math.abs(velocityY);
                if (velocityX > 500.0f && absY < absX) {
                    KeyboardView.this.swipeRight();
                    return true;
                }
                if (velocityX < -500.0f && absY < absX) {
                    KeyboardView.this.swipeLeft();
                    return true;
                }
                if (velocityY < -500.0f && absX < absY) {
                    KeyboardView.this.swipeUp();
                    return true;
                }
                if (velocityY > 500.0f && absX < 200.0f) {
                    KeyboardView.this.swipeDown();
                    return true;
                }
                return absX > 800.0f || absY > 800.0f;
            }
        });
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    public void setOnKeyboardActionListener(OnKeyboardActionListener listener) {
        this.mKeyboardActionListener = listener;
    }

    public OnKeyboardActionListener getOnKeyboardActionListener() {
        return this.mKeyboardActionListener;
    }

    public void setKeyboard(Keyboard keyboard) {
        if (this.mKeyboard != null) {
            this.showPreview(-1);
        }
        this.mKeyboard = keyboard;
        List<Keyboard.Key> keys = this.mKeyboard.getKeys();
        this.mKeys = keys.toArray(new Keyboard.Key[keys.size()]);
        this.requestLayout();
        this.mBuffer = null;
        this.invalidateAllKeys();
        this.computeProximityThreshold(keyboard);
        this.mMiniKeyboardCache.clear();
    }

    public Keyboard getKeyboard() {
        return this.mKeyboard;
    }

    public boolean setShifted(boolean shifted) {
        if (this.mKeyboard != null && this.mKeyboard.setShifted(shifted)) {
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    public boolean isShifted() {
        if (this.mKeyboard != null) {
            return this.mKeyboard.isShifted();
        }
        return false;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.mShowPreview = previewEnabled;
    }

    public boolean isPreviewEnabled() {
        return this.mShowPreview;
    }

    public void setVerticalCorrection(int verticalOffset) {
    }

    public void setPopupParent(View v) {
        this.mPopupParent = v;
    }

    public void setPopupOffset(int x, int y) {
        this.mMiniKeyboardOffsetX = x;
        this.mMiniKeyboardOffsetY = y;
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
    }

    public void setProximityCorrectionEnabled(boolean enabled) {
        this.mProximityCorrectOn = enabled;
    }

    public boolean isProximityCorrectionEnabled() {
        return this.mProximityCorrectOn;
    }

    public void onClick(View v) {
        this.dismissPopupKeyboard();
    }

    public CharSequence adjustCase(CharSequence label) {
        if (this.mKeyboard.isShifted() && label != null && label.length() < 3 && Character.isLowerCase(label.charAt(0))) {
            label = ((Object)label).toString().toUpperCase();
        }
        return label;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mKeyboard == null) {
            this.setMeasuredDimension(this.mPaddingLeft + this.mPaddingRight, this.mPaddingTop + this.mPaddingBottom);
        } else {
            int width = this.mKeyboard.getMinWidth() + this.mPaddingLeft + this.mPaddingRight;
            if (View.MeasureSpec.getSize(widthMeasureSpec) < width + 10) {
                width = View.MeasureSpec.getSize(widthMeasureSpec);
            }
            this.setMeasuredDimension(width, this.mKeyboard.getHeight() + this.mPaddingTop + this.mPaddingBottom);
        }
    }

    public void computeProximityThreshold(Keyboard keyboard) {
        if (keyboard == null) {
            return;
        }
        Keyboard.Key[] keys = this.mKeys;
        if (keys == null) {
            return;
        }
        int length = keys.length;
        int dimensionSum = 0;
        for (int i = 0; i < length; ++i) {
            Keyboard.Key key = keys[i];
            dimensionSum += Math.min(key.width, key.height) + key.gap;
        }
        if (dimensionSum < 0 || length == 0) {
            return;
        }
        this.mProximityThreshold = (int)((float)dimensionSum * 1.4f / (float)length);
        this.mProximityThreshold *= this.mProximityThreshold;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mBuffer = null;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawPending || this.mBuffer == null) {
            this.onBufferDraw();
        }
        canvas.drawBitmap(this.mBuffer, 0.0f, 0.0f, null);
    }

    public void onBufferDraw() {
        if (this.mBuffer == null) {
            this.mBuffer = Bitmap.createBitmap(this.getWidth(), this.getHeight(), Bitmap.Config.ARGB_8888);
            this.mCanvas = new Canvas(this.mBuffer);
            this.invalidateAllKeys();
        }
        Canvas canvas = this.mCanvas;
        canvas.clipRect(this.mDirtyRect, Region.Op.REPLACE);
        if (this.mKeyboard == null) {
            return;
        }
        Paint paint = this.mPaint;
        Drawable keyBackground = this.mKeyBackground;
        Rect clipRegion = this.mClipRegion;
        Rect padding = this.mPadding;
        int kbdPaddingLeft = this.mPaddingLeft;
        int kbdPaddingTop = this.mPaddingTop;
        Keyboard.Key[] keys = this.mKeys;
        Keyboard.Key invalidKey = this.mInvalidatedKey;
        paint.setAlpha(255);
        paint.setColor(this.mKeyTextColor);
        boolean drawSingleKey = false;
        if (invalidKey != null && canvas.getClipBounds(clipRegion) && invalidKey.x + kbdPaddingLeft - 1 <= clipRegion.left && invalidKey.y + kbdPaddingTop - 1 <= clipRegion.top && invalidKey.x + invalidKey.width + kbdPaddingLeft + 1 >= clipRegion.right && invalidKey.y + invalidKey.height + kbdPaddingTop + 1 >= clipRegion.bottom) {
            drawSingleKey = true;
        }
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (Keyboard.Key key : keys) {
            if (drawSingleKey && invalidKey != key) continue;
            int[] drawableState = key.getCurrentDrawableState();
            keyBackground.setState(drawableState);
            String label = key.label == null ? null : ((Object)this.adjustCase(key.label)).toString();
            Rect bounds = keyBackground.getBounds();
            if (key.width != bounds.right || key.height != bounds.bottom) {
                keyBackground.setBounds(0, 0, key.width, key.height);
            }
            canvas.translate(key.x + kbdPaddingLeft, key.y + kbdPaddingTop);
            keyBackground.draw(canvas);
            if (label != null) {
                if (label.length() > 1 && key.codes.length < 2) {
                    paint.setTextSize(this.mLabelTextSize);
                    paint.setTypeface(Typeface.DEFAULT_BOLD);
                } else {
                    paint.setTextSize(this.mKeyTextSize);
                    paint.setTypeface(Typeface.DEFAULT);
                }
                paint.setShadowLayer(this.mShadowRadius, 0.0f, 0.0f, this.mShadowColor);
                canvas.drawText(label, (key.width - padding.left - padding.right) / 2 + padding.left, (float)((key.height - padding.top - padding.bottom) / 2) + (paint.getTextSize() - paint.descent()) / 2.0f + (float)padding.top, paint);
                paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            } else if (key.icon != null) {
                int drawableX = (key.width - padding.left - padding.right - key.icon.getIntrinsicWidth()) / 2 + padding.left;
                int drawableY = (key.height - padding.top - padding.bottom - key.icon.getIntrinsicHeight()) / 2 + padding.top;
                canvas.translate(drawableX, drawableY);
                key.icon.setBounds(0, 0, key.icon.getIntrinsicWidth(), key.icon.getIntrinsicHeight());
                key.icon.draw(canvas);
                canvas.translate(-drawableX, -drawableY);
            }
            canvas.translate(-key.x - kbdPaddingLeft, -key.y - kbdPaddingTop);
        }
        this.mInvalidatedKey = null;
        if (this.mMiniKeyboardOnScreen) {
            paint.setColor((int)(this.mBackgroundDimAmount * 255.0f) << 24);
            canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.getHeight(), paint);
        }
        this.mDrawPending = false;
        this.mDirtyRect.setEmpty();
    }

    public int getKeyIndices(int x, int y, int[] allKeys) {
        Keyboard.Key[] keys = this.mKeys;
        boolean shifted = this.mKeyboard.isShifted();
        int primaryIndex = -1;
        int closestKey = -1;
        int closestKeyDist = this.mProximityThreshold + 1;
        Arrays.fill(this.mDistances, Integer.MAX_VALUE);
        int[] nearestKeyIndices = this.mKeyboard.getNearestKeys(x, y);
        int keyCount = nearestKeyIndices.length;
        for (int i = 0; i < keyCount; ++i) {
            Keyboard.Key key = keys[nearestKeyIndices[i]];
            int dist = 0;
            boolean isInside = key.isInside(x, y);
            if ((this.mProximityCorrectOn && (dist = key.squaredDistanceFrom(x, y)) < this.mProximityThreshold || isInside) && key.codes[0] > 32) {
                int nCodes = key.codes.length;
                if (dist < closestKeyDist) {
                    closestKeyDist = dist;
                    closestKey = nearestKeyIndices[i];
                }
                if (allKeys == null) continue;
                for (int j = 0; j < this.mDistances.length; ++j) {
                    if (this.mDistances[j] <= dist) continue;
                    System.arraycopy(this.mDistances, j, this.mDistances, j + nCodes, this.mDistances.length - j - nCodes);
                    System.arraycopy(allKeys, j, allKeys, j + nCodes, allKeys.length - j - nCodes);
                    for (int c = 0; c < nCodes; ++c) {
                        allKeys[j + c] = key.codes[c];
                        this.mDistances[j + c] = dist;
                    }
                    break;
                }
            }
            if (!isInside) continue;
            primaryIndex = nearestKeyIndices[i];
        }
        if (primaryIndex == -1) {
            primaryIndex = closestKey;
        }
        return primaryIndex;
    }

    public void detectAndSendKey(int x, int y, long eventTime) {
        int index = this.mCurrentKey;
        if (index != -1 && index < this.mKeys.length) {
            Keyboard.Key key = this.mKeys[index];
            if (key.text != null) {
                this.mKeyboardActionListener.onText(key.text);
                this.mKeyboardActionListener.onRelease(-1);
            } else {
                int code = key.codes[0];
                int[] codes = new int[MAX_NEARBY_KEYS];
                Arrays.fill(codes, -1);
                this.getKeyIndices(x, y, codes);
                if (this.mInMultiTap) {
                    if (this.mTapCount != -1) {
                        this.mKeyboardActionListener.onKey(-5, KEY_DELETE);
                    } else {
                        this.mTapCount = 0;
                    }
                    code = key.codes[this.mTapCount];
                }
                this.mKeyboardActionListener.onKey(code, codes);
                this.mKeyboardActionListener.onRelease(code);
            }
            this.mLastSentIndex = index;
            this.mLastTapTime = eventTime;
        }
    }

    public CharSequence getPreviewText(Keyboard.Key key) {
        if (this.mInMultiTap) {
            this.mPreviewLabel.setLength(0);
            this.mPreviewLabel.append((char)key.codes[this.mTapCount < 0 ? 0 : this.mTapCount]);
            return this.adjustCase(this.mPreviewLabel);
        }
        return this.adjustCase(key.label);
    }

    public void showPreview(int keyIndex) {
        int oldKeyIndex = this.mCurrentKeyIndex;
        PopupWindow previewPopup = this.mPreviewPopup;
        this.mCurrentKeyIndex = keyIndex;
        Keyboard.Key[] keys = this.mKeys;
        if (oldKeyIndex != this.mCurrentKeyIndex) {
            if (oldKeyIndex != -1 && keys.length > oldKeyIndex) {
                keys[oldKeyIndex].onReleased(this.mCurrentKeyIndex == -1);
                this.invalidateKey(oldKeyIndex);
            }
            if (this.mCurrentKeyIndex != -1 && keys.length > this.mCurrentKeyIndex) {
                keys[this.mCurrentKeyIndex].onPressed();
                this.invalidateKey(this.mCurrentKeyIndex);
            }
        }
        if (oldKeyIndex != this.mCurrentKeyIndex && this.mShowPreview) {
            this.mHandler.removeMessages(1);
            if (previewPopup.isShowing() && keyIndex == -1) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 60L);
            }
            if (keyIndex != -1) {
                if (previewPopup.isShowing() && this.mPreviewText.getVisibility() == 0) {
                    this.showKey(keyIndex);
                } else {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, keyIndex, 0), 40L);
                }
            }
        }
    }

    public void showKey(int keyIndex) {
        PopupWindow previewPopup = this.mPreviewPopup;
        Keyboard.Key[] keys = this.mKeys;
        Keyboard.Key key = keys[keyIndex];
        if (key.icon != null) {
            this.mPreviewText.setCompoundDrawables(null, null, null, key.iconPreview != null ? key.iconPreview : key.icon);
            this.mPreviewText.setText(null);
        } else {
            this.mPreviewText.setCompoundDrawables(null, null, null, null);
            this.mPreviewText.setText(this.getPreviewText(key));
            if (key.label.length() > 1 && key.codes.length < 2) {
                this.mPreviewText.setTextSize(0, this.mKeyTextSize);
                this.mPreviewText.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                this.mPreviewText.setTextSize(0, this.mPreviewTextSizeLarge);
                this.mPreviewText.setTypeface(Typeface.DEFAULT);
            }
        }
        this.mPreviewText.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
        int popupWidth = Math.max(this.mPreviewText.getMeasuredWidth(), key.width + this.mPreviewText.getPaddingLeft() + this.mPreviewText.getPaddingRight());
        int popupHeight = this.mPreviewHeight;
        ViewGroup.LayoutParams lp = this.mPreviewText.getLayoutParams();
        if (lp != null) {
            lp.width = popupWidth;
            lp.height = popupHeight;
        }
        if (!this.mPreviewCentered) {
            this.mPopupPreviewX = key.x - this.mPreviewText.getPaddingLeft() + this.mPaddingLeft;
            this.mPopupPreviewY = key.y - popupHeight + this.mPreviewOffset;
        } else {
            this.mPopupPreviewX = 160 - this.mPreviewText.getMeasuredWidth() / 2;
            this.mPopupPreviewY = -this.mPreviewText.getMeasuredHeight();
        }
        this.mHandler.removeMessages(2);
        if (this.mOffsetInWindow == null) {
            this.mOffsetInWindow = new int[2];
            this.getLocationInWindow(this.mOffsetInWindow);
            this.mOffsetInWindow[0] = this.mOffsetInWindow[0] + this.mMiniKeyboardOffsetX;
            this.mOffsetInWindow[1] = this.mOffsetInWindow[1] + this.mMiniKeyboardOffsetY;
        }
        this.mPreviewText.getBackground().setState(key.popupResId != 0 ? LONG_PRESSABLE_STATE_SET : EMPTY_STATE_SET);
        if (previewPopup.isShowing()) {
            previewPopup.update(this.mPopupPreviewX + this.mOffsetInWindow[0], this.mPopupPreviewY + this.mOffsetInWindow[1], popupWidth, popupHeight);
        } else {
            previewPopup.setWidth(popupWidth);
            previewPopup.setHeight(popupHeight);
            previewPopup.showAtLocation(this.mPopupParent, 0, this.mPopupPreviewX + this.mOffsetInWindow[0], this.mPopupPreviewY + this.mOffsetInWindow[1]);
        }
        this.mPreviewText.setVisibility(0);
    }

    public void invalidateAllKeys() {
        this.mDirtyRect.union(0, 0, this.getWidth(), this.getHeight());
        this.mDrawPending = true;
        this.invalidate();
    }

    public void invalidateKey(int keyIndex) {
        Keyboard.Key key;
        if (this.mKeys == null) {
            return;
        }
        if (keyIndex < 0 || keyIndex >= this.mKeys.length) {
            return;
        }
        this.mInvalidatedKey = key = this.mKeys[keyIndex];
        this.mDirtyRect.union(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
        this.onBufferDraw();
        this.invalidate(key.x + this.mPaddingLeft, key.y + this.mPaddingTop, key.x + key.width + this.mPaddingLeft, key.y + key.height + this.mPaddingTop);
    }

    public boolean openPopupIfRequired(MotionEvent me) {
        if (this.mPopupLayout == 0) {
            return false;
        }
        if (this.mCurrentKey < 0 || this.mCurrentKey >= this.mKeys.length) {
            return false;
        }
        Keyboard.Key popupKey = this.mKeys[this.mCurrentKey];
        boolean result = this.onLongPress(popupKey);
        if (result) {
            this.mAbortKey = true;
            this.showPreview(-1);
        }
        return result;
    }

    public boolean onLongPress(Keyboard.Key popupKey) {
        int popupKeyboardId = popupKey.popupResId;
        if (popupKeyboardId != 0) {
            this.mMiniKeyboardContainer = this.mMiniKeyboardCache.get(popupKey);
            if (this.mMiniKeyboardContainer == null) {
                LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
                this.mMiniKeyboardContainer = inflater.inflate(this.mPopupLayout, null);
                this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
                View closeButton = this.mMiniKeyboardContainer.findViewById(16908327);
                if (closeButton != null) {
                    closeButton.setOnClickListener(this);
                }
                this.mMiniKeyboard.setOnKeyboardActionListener(new OnKeyboardActionListener(){

                    public void onKey(int primaryCode, int[] keyCodes) {
                        KeyboardView.this.mKeyboardActionListener.onKey(primaryCode, keyCodes);
                        KeyboardView.this.dismissPopupKeyboard();
                    }

                    public void onText(CharSequence text) {
                        KeyboardView.this.mKeyboardActionListener.onText(text);
                        KeyboardView.this.dismissPopupKeyboard();
                    }

                    public void swipeLeft() {
                    }

                    public void swipeRight() {
                    }

                    public void swipeUp() {
                    }

                    public void swipeDown() {
                    }

                    public void onPress(int primaryCode) {
                        KeyboardView.this.mKeyboardActionListener.onPress(primaryCode);
                    }

                    public void onRelease(int primaryCode) {
                        KeyboardView.this.mKeyboardActionListener.onRelease(primaryCode);
                    }
                });
                Keyboard keyboard = popupKey.popupCharacters != null ? new Keyboard(this.getContext(), popupKeyboardId, popupKey.popupCharacters, -1, this.getPaddingLeft() + this.getPaddingRight()) : new Keyboard(this.getContext(), popupKeyboardId);
                this.mMiniKeyboard.setKeyboard(keyboard);
                this.mMiniKeyboard.setPopupParent(this);
                this.mMiniKeyboardContainer.measure(View.MeasureSpec.makeMeasureSpec(this.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.getHeight(), Integer.MIN_VALUE));
                this.mMiniKeyboardCache.put(popupKey, this.mMiniKeyboardContainer);
            } else {
                this.mMiniKeyboard = (KeyboardView)this.mMiniKeyboardContainer.findViewById(16908326);
            }
            if (this.mWindowOffset == null) {
                this.mWindowOffset = new int[2];
                this.getLocationInWindow(this.mWindowOffset);
            }
            this.mPopupX = popupKey.x + this.mPaddingLeft;
            this.mPopupY = popupKey.y + this.mPaddingTop;
            this.mPopupX = this.mPopupX + popupKey.width - this.mMiniKeyboardContainer.getMeasuredWidth();
            this.mPopupY -= this.mMiniKeyboardContainer.getMeasuredHeight();
            int x = this.mPopupX + this.mMiniKeyboardContainer.getPaddingRight() + this.mWindowOffset[0];
            int y = this.mPopupY + this.mMiniKeyboardContainer.getPaddingBottom() + this.mWindowOffset[1];
            this.mMiniKeyboard.setPopupOffset(x < 0 ? 0 : x, y);
            this.mMiniKeyboard.setShifted(this.isShifted());
            this.mPopupKeyboard.setContentView(this.mMiniKeyboardContainer);
            this.mPopupKeyboard.setWidth(this.mMiniKeyboardContainer.getMeasuredWidth());
            this.mPopupKeyboard.setHeight(this.mMiniKeyboardContainer.getMeasuredHeight());
            this.mPopupKeyboard.showAtLocation(this, 0, x, y);
            this.mMiniKeyboardOnScreen = true;
            this.invalidateAllKeys();
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent me) {
        int touchX = (int)me.getX() - this.mPaddingLeft;
        int touchY = (int)me.getY() + this.mVerticalCorrection - this.mPaddingTop;
        int action = me.getAction();
        long eventTime = me.getEventTime();
        int keyIndex = this.getKeyIndices(touchX, touchY, null);
        if (this.mGestureDetector.onTouchEvent(me)) {
            this.showPreview(-1);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            return true;
        }
        if (this.mMiniKeyboardOnScreen) {
            return true;
        }
        switch (action) {
            case 0: {
                Message msg;
                this.mAbortKey = false;
                this.mStartX = touchX;
                this.mStartY = touchY;
                this.mLastCodeX = touchX;
                this.mLastCodeY = touchY;
                this.mLastKeyTime = 0L;
                this.mCurrentKeyTime = 0L;
                this.mLastKey = -1;
                this.mCurrentKey = keyIndex;
                this.mLastMoveTime = this.mDownTime = me.getEventTime();
                this.checkMultiTap(eventTime, keyIndex);
                this.mKeyboardActionListener.onPress(keyIndex != -1 ? this.mKeys[keyIndex].codes[0] : 0);
                if (this.mCurrentKey >= 0 && this.mKeys[this.mCurrentKey].repeatable) {
                    this.mRepeatKeyIndex = this.mCurrentKey;
                    this.repeatKey();
                    msg = this.mHandler.obtainMessage(3);
                    this.mHandler.sendMessageDelayed(msg, 400L);
                }
                if (this.mCurrentKey != -1) {
                    msg = this.mHandler.obtainMessage(4, me);
                    this.mHandler.sendMessageDelayed(msg, 800L);
                }
                this.showPreview(keyIndex);
                break;
            }
            case 2: {
                boolean continueLongPress = false;
                if (keyIndex != -1) {
                    if (this.mCurrentKey == -1) {
                        this.mCurrentKey = keyIndex;
                        this.mCurrentKeyTime = eventTime - this.mDownTime;
                    } else if (keyIndex == this.mCurrentKey) {
                        this.mCurrentKeyTime += eventTime - this.mLastMoveTime;
                        continueLongPress = true;
                    } else {
                        this.resetMultiTap();
                        this.mLastKey = this.mCurrentKey;
                        this.mLastCodeX = this.mLastX;
                        this.mLastCodeY = this.mLastY;
                        this.mLastKeyTime = this.mCurrentKeyTime + eventTime - this.mLastMoveTime;
                        this.mCurrentKey = keyIndex;
                        this.mCurrentKeyTime = 0L;
                    }
                    if (keyIndex != this.mRepeatKeyIndex) {
                        this.mHandler.removeMessages(3);
                        this.mRepeatKeyIndex = -1;
                    }
                }
                if (!continueLongPress) {
                    this.mHandler.removeMessages(4);
                    if (keyIndex != -1) {
                        Message msg = this.mHandler.obtainMessage(4, me);
                        this.mHandler.sendMessageDelayed(msg, 800L);
                    }
                }
                this.showPreview(keyIndex);
                break;
            }
            case 1: {
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(3);
                this.mHandler.removeMessages(4);
                if (keyIndex == this.mCurrentKey) {
                    this.mCurrentKeyTime += eventTime - this.mLastMoveTime;
                } else {
                    this.resetMultiTap();
                    this.mLastKey = this.mCurrentKey;
                    this.mLastKeyTime = this.mCurrentKeyTime + eventTime - this.mLastMoveTime;
                    this.mCurrentKey = keyIndex;
                    this.mCurrentKeyTime = 0L;
                }
                if (this.mCurrentKeyTime < this.mLastKeyTime && this.mLastKey != -1) {
                    this.mCurrentKey = this.mLastKey;
                    touchX = this.mLastCodeX;
                    touchY = this.mLastCodeY;
                }
                this.showPreview(-1);
                Arrays.fill(this.mKeyIndices, -1);
                if (this.mRepeatKeyIndex == -1 && !this.mMiniKeyboardOnScreen && !this.mAbortKey) {
                    this.detectAndSendKey(touchX, touchY, eventTime);
                }
                this.invalidateKey(keyIndex);
                this.mRepeatKeyIndex = -1;
            }
        }
        this.mLastX = touchX;
        this.mLastY = touchY;
        return true;
    }

    public boolean repeatKey() {
        Keyboard.Key key = this.mKeys[this.mRepeatKeyIndex];
        this.detectAndSendKey(key.x, key.y, this.mLastTapTime);
        return true;
    }

    public void swipeRight() {
        this.mKeyboardActionListener.swipeRight();
    }

    public void swipeLeft() {
        this.mKeyboardActionListener.swipeLeft();
    }

    public void swipeUp() {
        this.mKeyboardActionListener.swipeUp();
    }

    public void swipeDown() {
        this.mKeyboardActionListener.swipeDown();
    }

    public void closing() {
        if (this.mPreviewPopup.isShowing()) {
            this.mPreviewPopup.dismiss();
        }
        this.mHandler.removeMessages(3);
        this.mHandler.removeMessages(4);
        this.mHandler.removeMessages(1);
        this.dismissPopupKeyboard();
        this.mBuffer = null;
        this.mCanvas = null;
        this.mMiniKeyboardCache.clear();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closing();
    }

    public void dismissPopupKeyboard() {
        if (this.mPopupKeyboard.isShowing()) {
            this.mPopupKeyboard.dismiss();
            this.mMiniKeyboardOnScreen = false;
            this.invalidateAllKeys();
        }
    }

    public boolean handleBack() {
        if (this.mPopupKeyboard.isShowing()) {
            this.dismissPopupKeyboard();
            return true;
        }
        return false;
    }

    public void resetMultiTap() {
        this.mLastSentIndex = -1;
        this.mTapCount = 0;
        this.mLastTapTime = -1L;
        this.mInMultiTap = false;
    }

    public void checkMultiTap(long eventTime, int keyIndex) {
        if (keyIndex == -1) {
            return;
        }
        Keyboard.Key key = this.mKeys[keyIndex];
        if (key.codes.length > 1) {
            this.mInMultiTap = true;
            if (eventTime < this.mLastTapTime + 800L && keyIndex == this.mLastSentIndex) {
                this.mTapCount = (this.mTapCount + 1) % key.codes.length;
                return;
            }
            this.mTapCount = -1;
            return;
        }
        if (eventTime > this.mLastTapTime + 800L || keyIndex != this.mLastSentIndex) {
            this.resetMultiTap();
        }
    }

    public static interface OnKeyboardActionListener {
        public void onPress(int var1);

        public void onRelease(int var1);

        public void onKey(int var1, int[] var2);

        public void onText(CharSequence var1);

        public void swipeLeft();

        public void swipeRight();

        public void swipeDown();

        public void swipeUp();
    }
}

