/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class PackageItemInfo {
    public String name;
    public String packageName;
    public int labelRes;
    public CharSequence nonLocalizedLabel;
    public int icon;
    public Bundle metaData;

    public PackageItemInfo() {
    }

    public PackageItemInfo(PackageItemInfo orig) {
        this.name = orig.name;
        this.packageName = orig.packageName;
        this.labelRes = orig.labelRes;
        this.nonLocalizedLabel = orig.nonLocalizedLabel;
        this.icon = orig.icon;
        this.metaData = orig.metaData;
    }

    public CharSequence loadLabel(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.labelRes != 0 && (label = pm.getText(this.packageName, this.labelRes, null)) != null) {
            return label;
        }
        if (this.name != null) {
            return this.name;
        }
        return this.packageName;
    }

    public Drawable loadIcon(PackageManager pm) {
        Drawable dr;
        if (this.icon != 0 && (dr = pm.getDrawable(this.packageName, this.icon, null)) != null) {
            return dr;
        }
        return pm.getDefaultActivityIcon();
    }

    public XmlResourceParser loadXmlMetaData(PackageManager pm, String name) {
        int resid;
        if (this.metaData != null && (resid = this.metaData.getInt(name)) != 0) {
            return pm.getXml(this.packageName, resid, null);
        }
        return null;
    }

    public void dumpFront(Printer pw, String prefix) {
        pw.println(prefix + "name=" + this.name);
        pw.println(prefix + "packageName=" + this.packageName);
        pw.println(prefix + "labelRes=0x" + Integer.toHexString(this.labelRes) + " nonLocalizedLabel=" + this.nonLocalizedLabel + " icon=0x" + Integer.toHexString(this.icon));
    }

    public void dumpBack(Printer pw, String prefix) {
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeString(this.name);
        dest.writeString(this.packageName);
        dest.writeInt(this.labelRes);
        TextUtils.writeToParcel(this.nonLocalizedLabel, dest, parcelableFlags);
        dest.writeInt(this.icon);
        dest.writeBundle(this.metaData);
    }

    public PackageItemInfo(Parcel source) {
        this.name = source.readString();
        this.packageName = source.readString();
        this.labelRes = source.readInt();
        this.nonLocalizedLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.icon = source.readInt();
        this.metaData = source.readBundle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayNameComparator
    implements Comparator<PackageItemInfo> {
        public final Collator sCollator = Collator.getInstance();
        public PackageManager mPM;

        public DisplayNameComparator(PackageManager pm) {
            this.mPM = pm;
        }

        @Override
        public int compare(PackageItemInfo aa, PackageItemInfo ab) {
            CharSequence sb;
            CharSequence sa = aa.loadLabel(this.mPM);
            if (sa == null) {
                sa = aa.name;
            }
            if ((sb = ab.loadLabel(this.mPM)) == null) {
                sb = ab.name;
            }
            return this.sCollator.compare(((Object)sa).toString(), ((Object)sb).toString());
        }
    }
}

