/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public abstract class BroadcastReceiver {
    public int mResultCode;
    public String mResultData;
    public Bundle mResultExtras;
    public boolean mAbortBroadcast;
    public boolean mDebugUnregister;
    public boolean mOrderedHint;

    public abstract void onReceive(Context var1, Intent var2);

    public IBinder peekService(Context myContext, Intent service) {
        IActivityManager am = ActivityManagerNative.getDefault();
        IBinder binder = null;
        try {
            binder = am.peekService(service, service.resolveTypeIfNeeded(myContext.getContentResolver()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return binder;
    }

    public void setResultCode(int code) {
        this.checkSynchronousHint();
        this.mResultCode = code;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public void setResultData(String data) {
        this.checkSynchronousHint();
        this.mResultData = data;
    }

    public String getResultData() {
        return this.mResultData;
    }

    public void setResultExtras(Bundle extras) {
        this.checkSynchronousHint();
        this.mResultExtras = extras;
    }

    public Bundle getResultExtras(boolean makeMap) {
        Bundle e = this.mResultExtras;
        if (!makeMap) {
            return e;
        }
        if (e == null) {
            this.mResultExtras = e = new Bundle();
        }
        return e;
    }

    public void setResult(int code, String data, Bundle extras) {
        this.checkSynchronousHint();
        this.mResultCode = code;
        this.mResultData = data;
        this.mResultExtras = extras;
    }

    public boolean getAbortBroadcast() {
        return this.mAbortBroadcast;
    }

    public void abortBroadcast() {
        this.checkSynchronousHint();
        this.mAbortBroadcast = true;
    }

    public void clearAbortBroadcast() {
        this.mAbortBroadcast = false;
    }

    public void setOrderedHint(boolean isOrdered) {
        this.mOrderedHint = isOrdered;
    }

    public void setDebugUnregister(boolean debug) {
        this.mDebugUnregister = debug;
    }

    public boolean getDebugUnregister() {
        return this.mDebugUnregister;
    }

    public void checkSynchronousHint() {
        if (this.mOrderedHint) {
            return;
        }
        RuntimeException e = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
        e.fillInStackTrace();
        Log.e("BroadcastReceiver", e.getMessage(), e);
    }
}

