/*
 * Decompiled with CFR 0.152.
 */
package android.backup;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataInput {
    public int mBackupReader;
    public EntityHeader mHeader = new EntityHeader(null);
    public boolean mHeaderReady;

    public BackupDataInput(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.mBackupReader = BackupDataInput.ctor(fd);
        if (this.mBackupReader == 0) {
            throw new RuntimeException("Native initialization failed with fd=" + fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            BackupDataInput.dtor(this.mBackupReader);
        }
        finally {
            super.finalize();
        }
    }

    public boolean readNextHeader() throws IOException {
        int result = this.readNextHeader_native(this.mBackupReader, this.mHeader);
        if (result == 0) {
            this.mHeaderReady = true;
            return true;
        }
        if (result > 0) {
            this.mHeaderReady = false;
            return false;
        }
        this.mHeaderReady = false;
        throw new IOException("result=0x" + Integer.toHexString(result));
    }

    public String getKey() {
        if (this.mHeaderReady) {
            return this.mHeader.key;
        }
        throw new IllegalStateException("mHeaderReady=false");
    }

    public int getDataSize() {
        if (this.mHeaderReady) {
            return this.mHeader.dataSize;
        }
        throw new IllegalStateException("mHeaderReady=false");
    }

    public int readEntityData(byte[] data, int offset, int size) throws IOException {
        if (this.mHeaderReady) {
            int result = this.readEntityData_native(this.mBackupReader, data, offset, size);
            if (result >= 0) {
                return result;
            }
            throw new IOException("result=0x" + Integer.toHexString(result));
        }
        throw new IllegalStateException("mHeaderReady=false");
    }

    public void skipEntityData() throws IOException {
        if (this.mHeaderReady) {
            int result = this.skipEntityData_native(this.mBackupReader);
            if (result >= 0) {
                return;
            }
            throw new IOException("result=0x" + Integer.toHexString(result));
        }
        throw new IllegalStateException("mHeaderReady=false");
    }

    public static int ctor(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.backup.BackupDataInput#ctor(Ljava/io/FileDescriptor;)I", true, null);
    }

    public static void dtor(int n) {
        OverrideMethod.invokeV("android.backup.BackupDataInput#dtor(I)V", true, null);
    }

    public int readNextHeader_native(int n, EntityHeader entityHeader) {
        return OverrideMethod.invokeI("android.backup.BackupDataInput#readNextHeader_native(ILandroid/backup/BackupDataInput$EntityHeader;)I", true, this);
    }

    public int readEntityData_native(int n, byte[] byArray, int n2, int n3) {
        return OverrideMethod.invokeI("android.backup.BackupDataInput#readEntityData_native(I[BII)I", true, this);
    }

    public int skipEntityData_native(int n) {
        return OverrideMethod.invokeI("android.backup.BackupDataInput#skipEntityData_native(I)I", true, this);
    }

    public static class 1 {
    }

    public static class EntityHeader {
        public String key;
        public int dataSize;

        public EntityHeader() {
        }

        public /* synthetic */ EntityHeader(1 x0) {
            this();
        }
    }
}

