/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.Xfermode;
import com.android.layoutlib.api.ILayoutLog;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.microedition.khronos.opengles.GL;

public class BridgeCanvas
extends Canvas {
    private BufferedImage mBufferedImage;
    private final Stack<Graphics2D> mGraphicsStack = new Stack();
    private final ILayoutLog mLogger;

    public BridgeCanvas(int width, int height, ILayoutLog logger) {
        this.mLogger = logger;
        this.mBufferedImage = new BufferedImage(width, height, 2);
        this.mGraphicsStack.push(this.mBufferedImage.createGraphics());
    }

    public BridgeCanvas(int width, int height) {
        this(width, height, null);
    }

    public BufferedImage getImage() {
        return this.mBufferedImage;
    }

    Graphics2D getGraphics2d() {
        return this.mGraphicsStack.peek();
    }

    void dispose() {
        while (this.mGraphicsStack.size() > 0) {
            this.mGraphicsStack.pop().dispose();
        }
    }

    private Graphics2D getNewGraphics(Paint paint, Graphics2D g) {
        g = (Graphics2D)g.create();
        g.setColor(new Color(paint.getColor()));
        int alpha = paint.getAlpha();
        float falpha = (float)alpha / 255.0f;
        Xfermode xfermode = paint.getXfermode();
        if (xfermode instanceof PorterDuffXfermode) {
            PorterDuff.Mode mode = ((PorterDuffXfermode)xfermode).getMode();
            this.setModeInGraphics(mode, g, falpha);
        } else {
            if (this.mLogger != null && xfermode != null) {
                this.mLogger.warning(String.format("Xfermode '%1$s' is not supported in the Layout Editor.", xfermode.getClass().getCanonicalName()));
            }
            g.setComposite(AlphaComposite.getInstance(3, falpha));
        }
        Shader shader = paint.getShader();
        if (shader instanceof LinearGradient) {
            g.setPaint(((LinearGradient)shader).getPaint());
        } else if (this.mLogger != null && shader != null) {
            this.mLogger.warning(String.format("Shader '%1$s' is not supported in the Layout Editor.", shader.getClass().getCanonicalName()));
        }
        return g;
    }

    private void setModeInGraphics(PorterDuff.Mode mode, Graphics2D g, float falpha) {
        switch (mode) {
            case CLEAR: {
                g.setComposite(AlphaComposite.getInstance(1, falpha));
                break;
            }
            case DARKEN: {
                break;
            }
            case DST: {
                g.setComposite(AlphaComposite.getInstance(9, falpha));
                break;
            }
            case DST_ATOP: {
                g.setComposite(AlphaComposite.getInstance(11, falpha));
                break;
            }
            case DST_IN: {
                g.setComposite(AlphaComposite.getInstance(6, falpha));
                break;
            }
            case DST_OUT: {
                g.setComposite(AlphaComposite.getInstance(8, falpha));
                break;
            }
            case DST_OVER: {
                g.setComposite(AlphaComposite.getInstance(4, falpha));
                break;
            }
            case LIGHTEN: {
                break;
            }
            case MULTIPLY: {
                break;
            }
            case SCREEN: {
                break;
            }
            case SRC: {
                g.setComposite(AlphaComposite.getInstance(2, falpha));
                break;
            }
            case SRC_ATOP: {
                g.setComposite(AlphaComposite.getInstance(10, falpha));
                break;
            }
            case SRC_IN: {
                g.setComposite(AlphaComposite.getInstance(5, falpha));
                break;
            }
            case SRC_OUT: {
                g.setComposite(AlphaComposite.getInstance(7, falpha));
                break;
            }
            case SRC_OVER: {
                g.setComposite(AlphaComposite.getInstance(3, falpha));
                break;
            }
            case XOR: {
                g.setComposite(AlphaComposite.getInstance(12, falpha));
            }
        }
    }

    public void finalize() throws Throwable {
    }

    public void translate(float dx, float dy) {
        this.getGraphics2d().translate(dx, dy);
    }

    public int save() {
        Graphics2D g = (Graphics2D)this.getGraphics2d().create();
        this.mGraphicsStack.push(g);
        return this.mGraphicsStack.size() - 1;
    }

    public int save(int saveFlags) {
        return this.save();
    }

    public void restore() {
        this.mGraphicsStack.pop();
    }

    public void restoreToCount(int saveCount) {
        while (this.mGraphicsStack.size() > saveCount) {
            this.mGraphicsStack.pop();
        }
    }

    public int getSaveCount() {
        return this.mGraphicsStack.size() - 1;
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return this.clipRect(left, top, right, bottom);
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        this.getGraphics2d().clipRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
        return true;
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        this.getGraphics2d().clipRect(left, top, right - left, bottom - top);
        return true;
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return this.clipRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean clipRect(Rect rect) {
        return this.clipRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return this.clipRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean clipRect(RectF rect) {
        return this.clipRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return false;
    }

    public boolean quickReject(Path path, Canvas.EdgeType type) {
        return false;
    }

    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return false;
    }

    public boolean getClipBounds(Rect bounds) {
        Rectangle rect = this.getGraphics2d().getClipBounds();
        if (rect != null) {
            bounds.left = rect.x;
            bounds.top = rect.y;
            bounds.right = rect.x + rect.width;
            bounds.bottom = rect.y + rect.height;
            return true;
        }
        return false;
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        Graphics2D g = this.getGraphics2d();
        Color c = g.getColor();
        Composite composite = g.getComposite();
        int alpha = color2 >>> 24;
        float falpha = (float)alpha / 255.0f;
        this.setModeInGraphics(mode, g, falpha);
        g.setColor(new Color(color2));
        this.getGraphics2d().fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setComposite(composite);
        g.setColor(c);
    }

    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor(a << 24 | r << 16 | g << 8 | b, PorterDuff.Mode.SRC_OVER);
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | r << 16 | g << 8 | b, PorterDuff.Mode.SRC_OVER);
    }

    public int getWidth() {
        return this.mBufferedImage.getWidth();
    }

    public int getHeight() {
        return this.mBufferedImage.getHeight();
    }

    public void drawPaint(Paint paint) {
        this.drawColor(paint.getColor());
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.drawBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), (int)left, (int)top, (int)left + bitmap.getWidth(), (int)top + bitmap.getHeight(), paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        throw new UnsupportedOperationException();
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        if (src == null) {
            this.drawBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), dst.left, dst.top, dst.right, dst.bottom, paint);
        } else {
            this.drawBitmap(bitmap, src.left, src.top, src.width(), src.height(), dst.left, dst.top, dst.right, dst.bottom, paint);
        }
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        if (src == null) {
            this.drawBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), (int)dst.left, (int)dst.top, (int)dst.right, (int)dst.bottom, paint);
        } else {
            this.drawBitmap(bitmap, src.left, src.top, src.width(), src.height(), (int)dst.left, (int)dst.top, (int)dst.right, (int)dst.bottom, paint);
        }
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        throw new UnsupportedOperationException();
    }

    private void drawBitmap(Bitmap bitmap, int sleft, int stop, int sright, int sbottom, int dleft, int dtop, int dright, int dbottom, Paint paint) {
        BufferedImage image = bitmap.getImage();
        Graphics2D g = this.getGraphics2d();
        Composite c = null;
        if (paint.isFilterBitmap()) {
            g = (Graphics2D)g.create();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        if (paint.getAlpha() != 255) {
            c = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)paint.getAlpha() / 255.0f));
        }
        g.drawImage(image, dleft, dtop, dright, dbottom, sleft, stop, sright, sbottom, null);
        if (paint.isFilterBitmap()) {
            g.dispose();
        }
        if (c != null) {
            g.setComposite(c);
        }
    }

    public void rotate(float degrees, float px, float py) {
        if (degrees != 0.0f) {
            Graphics2D g = this.getGraphics2d();
            g.translate(px, py);
            g.rotate(Math.toRadians(degrees));
            g.translate(-px, -py);
        }
    }

    public void rotate(float degrees) {
        this.getGraphics2d().rotate(Math.toRadians(degrees));
    }

    public void scale(float sx, float sy, float px, float py) {
        Graphics2D g = this.getGraphics2d();
        g.translate(px, py);
        g.scale(sx, sy);
        g.translate(-px, -py);
    }

    public void scale(float sx, float sy) {
        this.getGraphics2d().scale(sx, sy);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = (Graphics2D)g.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(paint.getFont());
        g.setColor(new Color(paint.getColor()));
        int alpha = paint.getAlpha();
        float falpha = (float)alpha / 255.0f;
        g.setComposite(AlphaComposite.getInstance(3, falpha));
        if (paint.getTextAlign() != Paint.Align.LEFT) {
            float m = paint.measureText(text, index, count);
            if (paint.getTextAlign() == Paint.Align.CENTER) {
                x -= m / 2.0f;
            } else if (paint.getTextAlign() == Paint.Align.RIGHT) {
                x -= m;
            }
        }
        g.drawChars(text, index, count, (int)x, (int)y);
        g.dispose();
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        this.drawText(((Object)text).toString().toCharArray(), start, end - start, x, y, paint);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        this.drawText(text.toCharArray(), 0, text.length(), x, y, paint);
    }

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        this.drawText(text.toCharArray(), start, end - start, x, y, paint);
    }

    public void drawRect(RectF rect, Paint paint) {
        this.doDrawRect((int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.doDrawRect((int)left, (int)top, (int)(right - left), (int)(bottom - top), paint);
    }

    public void drawRect(Rect r, Paint paint) {
        this.doDrawRect(r.left, r.top, r.width(), r.height(), paint);
    }

    private final void doDrawRect(int left, int top, int width, int height, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        Paint.Style style2 = paint.getStyle();
        if (style2 == Paint.Style.FILL || style2 == Paint.Style.FILL_AND_STROKE) {
            g.fillRect(left, top, width, height);
        }
        if (style2 == Paint.Style.STROKE || style2 == Paint.Style.FILL_AND_STROKE) {
            g.drawRect(left, top, width, height);
        }
        g.dispose();
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        Paint.Style style2 = paint.getStyle();
        int arcWidth = (int)(rx * 2.0f);
        int arcHeight = (int)(ry * 2.0f);
        if (style2 == Paint.Style.FILL || style2 == Paint.Style.FILL_AND_STROKE) {
            g.fillRoundRect((int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), arcWidth, arcHeight);
        }
        if (style2 == Paint.Style.STROKE || style2 == Paint.Style.FILL_AND_STROKE) {
            g.drawRoundRect((int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), arcWidth, arcHeight);
        }
        g.dispose();
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        g.drawLine((int)startX, (int)startY, (int)stopX, (int)stopY);
        g.dispose();
    }

    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        for (int i = 0; i < count; i += 4) {
            g.drawLine((int)pts[i + offset], (int)pts[i + offset + 1], (int)pts[i + offset + 2], (int)pts[i + offset + 3]);
        }
        g.dispose();
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        Paint.Style style2 = paint.getStyle();
        int size = (int)(radius * 2.0f);
        if (style2 == Paint.Style.FILL || style2 == Paint.Style.FILL_AND_STROKE) {
            g.fillOval((int)(cx - radius), (int)(cy - radius), size, size);
        }
        if (style2 == Paint.Style.STROKE || style2 == Paint.Style.FILL_AND_STROKE) {
            g.drawOval((int)(cx - radius), (int)(cy - radius), size, size);
        }
        g.dispose();
    }

    public void drawOval(RectF oval, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        Paint.Style style2 = paint.getStyle();
        if (style2 == Paint.Style.FILL || style2 == Paint.Style.FILL_AND_STROKE) {
            g.fillOval((int)oval.left, (int)oval.top, (int)oval.width(), (int)oval.height());
        }
        if (style2 == Paint.Style.STROKE || style2 == Paint.Style.FILL_AND_STROKE) {
            g.drawOval((int)oval.left, (int)oval.top, (int)oval.width(), (int)oval.height());
        }
        g.dispose();
    }

    public void drawPath(Path path, Paint paint) {
        Graphics2D g = this.getGraphics2d();
        g = this.getNewGraphics(paint, g);
        Paint.Style style2 = paint.getStyle();
        if (style2 == Paint.Style.FILL || style2 == Paint.Style.FILL_AND_STROKE) {
            g.fill(path.getAwtShape());
        }
        if (style2 == Paint.Style.STROKE || style2 == Paint.Style.FILL_AND_STROKE) {
            g.draw(path.getAwtShape());
        }
        g.dispose();
    }

    public void setMatrix(Matrix matrix) {
        this.restore();
        this.save();
        Graphics2D g = this.getGraphics2d();
        g.setTransform(matrix.getTransform());
        if (this.mLogger != null && matrix.hasPerspective()) {
            this.mLogger.warning("android.graphics.Canvas#setMatrix(android.graphics.Matrix) only supports affine transformations in the Layout Editor.");
        }
    }

    public boolean clipPath(Path path, Region.Op op) {
        return super.clipPath(path, op);
    }

    public boolean clipPath(Path path) {
        return super.clipPath(path);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return super.clipRegion(region, op);
    }

    public boolean clipRegion(Region region) {
        return super.clipRegion(region);
    }

    public void concat(Matrix matrix) {
        super.concat(matrix);
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(oval, startAngle, sweepAngle, useCenter, paint);
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        super.drawBitmapMesh(bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint);
    }

    public void drawPicture(Picture picture, Rect dst) {
        super.drawPicture(picture, dst);
    }

    public void drawPicture(Picture picture, RectF dst) {
        super.drawPicture(picture, dst);
    }

    public void drawPicture(Picture picture) {
        super.drawPicture(picture);
    }

    public void drawPoint(float x, float y, Paint paint) {
        super.drawPoint(x, y, paint);
    }

    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        super.drawPoints(pts, offset, count, paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        super.drawPoints(pts, paint);
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        super.drawPosText(text, index, count, pos, paint);
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
        super.drawPosText(text, pos, paint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float offset, float offset2, Paint paint) {
        super.drawTextOnPath(text, index, count, path, offset, offset2, paint);
    }

    public void drawTextOnPath(String text, Path path, float offset, float offset2, Paint paint) {
        super.drawTextOnPath(text, path, offset, offset2, paint);
    }

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        super.drawVertices(mode, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint);
    }

    public DrawFilter getDrawFilter() {
        return super.getDrawFilter();
    }

    public GL getGL() {
        return super.getGL();
    }

    public Matrix getMatrix() {
        return super.getMatrix();
    }

    public void getMatrix(Matrix ctm) {
        super.getMatrix(ctm);
    }

    public boolean isOpaque() {
        return super.isOpaque();
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return super.saveLayer(left, top, right, bottom, paint, saveFlags);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        return super.saveLayer(bounds, paint, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        return super.saveLayerAlpha(left, top, right, bottom, alpha, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        return super.saveLayerAlpha(bounds, alpha, saveFlags);
    }

    public void setBitmap(Bitmap bitmap) {
        super.setBitmap(bitmap);
    }

    public void setDrawFilter(DrawFilter filter) {
        super.setDrawFilter(filter);
    }

    public void setViewport(int width, int height) {
        super.setViewport(width, height);
    }

    public void skew(float sx, float sy) {
        super.skew(sx, sy);
    }
}

