/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.ContentResolver;
import android.os.Environment;
import android.os.SystemClock;
import android.provider.Settings;
import android.security.MessageDigest;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockPatternUtils {
    public static final String TAG = "LockPatternUtils";
    public static final String LOCK_PATTERN_FILE = "/system/gesture.key";
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 3;
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static final String PATTERN_EVER_CHOSEN = "lockscreen.patterneverchosen";
    public final ContentResolver mContentResolver;
    public static String sLockPatternFilename;

    public LockPatternUtils(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
        if (sLockPatternFilename == null) {
            sLockPatternFilename = Environment.getDataDirectory().getAbsolutePath() + LOCK_PATTERN_FILE;
        }
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern) {
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPatternFilename, "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            return Arrays.equals(stored, LockPatternUtils.patternToHash(pattern));
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        catch (IOException ioe) {
            return true;
        }
    }

    public boolean savedPatternExists() {
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPatternFilename, "r");
            byte first = raf.readByte();
            raf.close();
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN);
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern) {
        byte[] hash = LockPatternUtils.patternToHash(pattern);
        try {
            RandomAccessFile raf = new RandomAccessFile(sLockPatternFilename, "rw");
            if (pattern == null) {
                raf.setLength(0L);
            } else {
                raf.write(hash, 0, hash.length);
            }
            raf.close();
            this.setBoolean(PATTERN_EVER_CHOSEN, true);
        }
        catch (FileNotFoundException fnfe) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPatternFilename);
        }
        catch (IOException ioe) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPatternFilename);
        }
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    public static String patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        return new String(res);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    public boolean isLockPatternEnabled() {
        return this.getBoolean("lock_pattern_autolock");
    }

    public void setLockPatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_autolock", enabled);
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern");
    }

    public void setVisiblePatternEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_visible_pattern", enabled);
    }

    public boolean isTactileFeedbackEnabled() {
        return this.getBoolean("lock_pattern_tactile_feedback_enabled");
    }

    public void setTactileFeedbackEnabled(boolean enabled) {
        this.setBoolean("lock_pattern_tactile_feedback_enabled", enabled);
    }

    public long setLockoutAttemptDeadline() {
        long deadline = SystemClock.elapsedRealtime() + 30000L;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, deadline);
        return deadline;
    }

    public long getLockoutAttemptDeadline() {
        long now;
        long deadline = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) || deadline > now + 30000L) {
            return 0L;
        }
        return deadline;
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY);
    }

    public void setPermanentlyLocked(boolean locked) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, locked);
        if (!locked) {
            this.setLockPatternEnabled(false);
            this.saveLockPattern(null);
        }
    }

    public String getNextAlarm() {
        String nextAlarm = Settings.System.getString(this.mContentResolver, "next_alarm_formatted");
        if (nextAlarm == null || TextUtils.isEmpty(nextAlarm)) {
            return null;
        }
        return nextAlarm;
    }

    public boolean getBoolean(String systemSettingKey) {
        return 1 == Settings.System.getInt(this.mContentResolver, systemSettingKey, 0);
    }

    public void setBoolean(String systemSettingKey, boolean enabled) {
        Settings.System.putInt(this.mContentResolver, systemSettingKey, enabled ? 1 : 0);
    }

    public long getLong(String systemSettingKey, long def) {
        return Settings.System.getLong(this.mContentResolver, systemSettingKey, def);
    }

    public void setLong(String systemSettingKey, long value) {
        Settings.System.putLong(this.mContentResolver, systemSettingKey, value);
    }
}

