/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;

public abstract class Connection {
    public static int PRESENTATION_ALLOWED = 1;
    public static int PRESENTATION_RESTRICTED = 2;
    public static int PRESENTATION_UNKNOWN = 3;
    public static int PRESENTATION_PAYPHONE = 4;
    public Object userData;

    public abstract String getAddress();

    public abstract Call getCall();

    public abstract long getCreateTime();

    public abstract long getConnectTime();

    public abstract long getDisconnectTime();

    public abstract long getDurationMillis();

    public abstract long getHoldDurationMillis();

    public abstract DisconnectCause getDisconnectCause();

    public abstract boolean isIncoming();

    public Call.State getState() {
        Call c = this.getCall();
        if (c == null) {
            return Call.State.IDLE;
        }
        return c.getState();
    }

    public boolean isAlive() {
        return this.getState().isAlive();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userdata) {
        this.userData = userdata;
    }

    public abstract void hangup() throws CallStateException;

    public abstract void separate() throws CallStateException;

    public abstract PostDialState getPostDialState();

    public abstract String getRemainingPostDialString();

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void cancelPostDial();

    public abstract int getNumberPresentation();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostDialState {
        NOT_STARTED,
        STARTED,
        WAIT,
        WILD,
        COMPLETE,
        CANCELLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisconnectCause {
        NOT_DISCONNECTED,
        INCOMING_MISSED,
        NORMAL,
        LOCAL,
        BUSY,
        CONGESTION,
        MMI,
        INVALID_NUMBER,
        LOST_SIGNAL,
        LIMIT_EXCEEDED,
        INCOMING_REJECTED,
        POWER_OFF,
        OUT_OF_SERVICE,
        SIM_ERROR,
        CALL_BARRED,
        FDN_BLOCKED,
        CS_RESTRICTED,
        CS_RESTRICTED_NORMAL,
        CS_RESTRICTED_EMERGENCY;

    }
}

