/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.widget.CursorTreeAdapter;
import android.widget.ImageView;
import android.widget.ResourceCursorTreeAdapter;
import android.widget.TextView;

public abstract class SimpleCursorTreeAdapter
extends ResourceCursorTreeAdapter {
    public int[] mGroupFrom;
    public int[] mGroupTo;
    public int[] mChildFrom;
    public int[] mChildTo;

    public SimpleCursorTreeAdapter(Context context, Cursor cursor, int collapsedGroupLayout, int expandedGroupLayout, String[] groupFrom, int[] groupTo, int childLayout, int lastChildLayout, String[] childFrom, int[] childTo) {
        super(context, cursor, collapsedGroupLayout, expandedGroupLayout, childLayout, lastChildLayout);
        this.init(groupFrom, groupTo, childFrom, childTo);
    }

    public SimpleCursorTreeAdapter(Context context, Cursor cursor, int collapsedGroupLayout, int expandedGroupLayout, String[] groupFrom, int[] groupTo, int childLayout, String[] childFrom, int[] childTo) {
        super(context, cursor, collapsedGroupLayout, expandedGroupLayout, childLayout);
        this.init(groupFrom, groupTo, childFrom, childTo);
    }

    public SimpleCursorTreeAdapter(Context context, Cursor cursor, int groupLayout, String[] groupFrom, int[] groupTo, int childLayout, String[] childFrom, int[] childTo) {
        super(context, cursor, groupLayout, childLayout);
        this.init(groupFrom, groupTo, childFrom, childTo);
    }

    public void init(String[] groupFromNames, int[] groupTo, String[] childFromNames, int[] childTo) {
        CursorTreeAdapter.MyCursorHelper tmpCursorHelper;
        this.mGroupTo = groupTo;
        this.mChildTo = childTo;
        this.initGroupFromColumns(groupFromNames);
        if (this.getGroupCount() > 0 && (tmpCursorHelper = this.getChildrenCursorHelper(0, true)) != null) {
            this.initChildrenFromColumns(childFromNames, tmpCursorHelper.getCursor());
            this.deactivateChildrenCursorHelper(0);
        }
    }

    public void initFromColumns(Cursor cursor, String[] fromColumnNames, int[] fromColumns) {
        for (int i = fromColumnNames.length - 1; i >= 0; --i) {
            fromColumns[i] = cursor.getColumnIndexOrThrow(fromColumnNames[i]);
        }
    }

    public void initGroupFromColumns(String[] groupFromNames) {
        this.mGroupFrom = new int[groupFromNames.length];
        this.initFromColumns(this.mGroupCursorHelper.getCursor(), groupFromNames, this.mGroupFrom);
    }

    public void initChildrenFromColumns(String[] childFromNames, Cursor childCursor) {
        this.mChildFrom = new int[childFromNames.length];
        this.initFromColumns(childCursor, childFromNames, this.mChildFrom);
    }

    public void bindView(View view, Context context, Cursor cursor, int[] from, int[] to) {
        for (int i = 0; i < to.length; ++i) {
            View v = view.findViewById(to[i]);
            if (v == null) continue;
            String text = cursor.getString(from[i]);
            if (text == null) {
                text = "";
            }
            if (v instanceof TextView) {
                ((TextView)v).setText(text);
                continue;
            }
            if (v instanceof ImageView) {
                this.setViewImage((ImageView)v, text);
                continue;
            }
            throw new IllegalStateException("SimpleCursorAdapter can bind values only to TextView and ImageView!");
        }
    }

    public void bindChildView(View view, Context context, Cursor cursor, boolean isLastChild) {
        this.bindView(view, context, cursor, this.mChildFrom, this.mChildTo);
    }

    public void bindGroupView(View view, Context context, Cursor cursor, boolean isExpanded) {
        this.bindView(view, context, cursor, this.mGroupFrom, this.mGroupTo);
    }

    public void setViewImage(ImageView v, String value) {
        try {
            v.setImageResource(Integer.parseInt(value));
        }
        catch (NumberFormatException nfe) {
            v.setImageURI(Uri.parse(value));
        }
    }
}

