/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.SparseIntArray;
import android.widget.SectionIndexer;
import java.text.Collator;

public class AlphabetIndexer
extends DataSetObserver
implements SectionIndexer {
    public Cursor mDataCursor;
    public int mColumnIndex;
    public CharSequence mAlphabet;
    public int mAlphabetLength;
    public SparseIntArray mAlphaMap;
    public Collator mCollator;
    public String[] mAlphabetArray;

    public AlphabetIndexer(Cursor cursor, int sortedColumnIndex, CharSequence alphabet) {
        this.mDataCursor = cursor;
        this.mColumnIndex = sortedColumnIndex;
        this.mAlphabet = alphabet;
        this.mAlphabetLength = alphabet.length();
        this.mAlphabetArray = new String[this.mAlphabetLength];
        for (int i = 0; i < this.mAlphabetLength; ++i) {
            this.mAlphabetArray[i] = Character.toString(this.mAlphabet.charAt(i));
        }
        this.mAlphaMap = new SparseIntArray(this.mAlphabetLength);
        if (cursor != null) {
            cursor.registerDataSetObserver(this);
        }
        this.mCollator = Collator.getInstance();
        this.mCollator.setStrength(0);
    }

    public Object[] getSections() {
        return this.mAlphabetArray;
    }

    public void setCursor(Cursor cursor) {
        if (this.mDataCursor != null) {
            this.mDataCursor.unregisterDataSetObserver(this);
        }
        this.mDataCursor = cursor;
        if (cursor != null) {
            this.mDataCursor.registerDataSetObserver(this);
        }
        this.mAlphaMap.clear();
    }

    public int compare(String word, String letter) {
        return this.mCollator.compare(word.substring(0, 1), letter);
    }

    public int getPositionForSection(int sectionIndex) {
        char prevLetter;
        int prevLetterPos;
        SparseIntArray alphaMap = this.mAlphaMap;
        Cursor cursor = this.mDataCursor;
        if (cursor == null || this.mAlphabet == null) {
            return 0;
        }
        if (sectionIndex <= 0) {
            return 0;
        }
        if (sectionIndex >= this.mAlphabetLength) {
            sectionIndex = this.mAlphabetLength - 1;
        }
        int savedCursorPos = cursor.getPosition();
        int count = cursor.getCount();
        int start = 0;
        int end = count;
        char letter = this.mAlphabet.charAt(sectionIndex);
        String targetLetter = Character.toString(letter);
        char key = letter;
        int pos = alphaMap.get(key, Integer.MIN_VALUE);
        if (Integer.MIN_VALUE != pos) {
            if (pos < 0) {
                end = pos = -pos;
            } else {
                return pos;
            }
        }
        if (sectionIndex > 0 && (prevLetterPos = alphaMap.get(prevLetter = this.mAlphabet.charAt(sectionIndex - 1), Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            start = Math.abs(prevLetterPos);
        }
        pos = (end + start) / 2;
        while (pos < end) {
            cursor.moveToPosition(pos);
            String curName = cursor.getString(this.mColumnIndex);
            if (curName == null) {
                if (pos == 0) break;
                --pos;
                continue;
            }
            int diff = this.compare(curName, targetLetter);
            if (diff != 0) {
                if (diff < 0) {
                    start = pos + 1;
                    if (start >= count) {
                        pos = count;
                        break;
                    }
                } else {
                    end = pos;
                }
            } else {
                if (start == pos) break;
                end = pos;
            }
            pos = (start + end) / 2;
        }
        alphaMap.put(key, pos);
        cursor.moveToPosition(savedCursorPos);
        return pos;
    }

    public int getSectionForPosition(int position) {
        int savedCursorPos = this.mDataCursor.getPosition();
        this.mDataCursor.moveToPosition(position);
        this.mDataCursor.moveToPosition(savedCursorPos);
        String curName = this.mDataCursor.getString(this.mColumnIndex);
        for (int i = 0; i < this.mAlphabetLength; ++i) {
            char letter = this.mAlphabet.charAt(i);
            String targetLetter = Character.toString(letter);
            if (this.compare(curName, targetLetter) != 0) continue;
            return i;
        }
        return 0;
    }

    public void onChanged() {
        super.onChanged();
        this.mAlphaMap.clear();
    }

    public void onInvalidated() {
        super.onInvalidated();
        this.mAlphaMap.clear();
    }
}

