/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.webkit.CookieManager;
import android.webkit.PerfChecker;
import com.android.tools.layoutlib.create.OverrideMethod;

public class JWebCoreJavaBridge
extends Handler {
    public static final int TIMER_MESSAGE = 1;
    public static final int FUNCPTR_MESSAGE = 2;
    public static final String LOGTAG = "webkit-timers";
    public int mNativeBridge;
    public boolean mHasInstantTimer;
    public int mPauseTimerRefCount;

    public JWebCoreJavaBridge() {
        this.nativeConstructor();
    }

    public void finalize() {
        this.nativeFinalize();
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                PerfChecker checker = new PerfChecker();
                this.mHasInstantTimer = false;
                this.sharedTimerFired();
                checker.responseAlert("sharedTimer");
                break;
            }
            case 2: {
                this.nativeServiceFuncPtrQueue();
            }
        }
    }

    public void signalServiceFuncPtrQueue() {
        Message msg = this.obtainMessage(2);
        this.sendMessage(msg);
    }

    public void nativeServiceFuncPtrQueue() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeServiceFuncPtrQueue()V", true, this);
    }

    public void pause() {
        if (--this.mPauseTimerRefCount == 0) {
            this.setDeferringTimers(true);
        }
    }

    public void resume() {
        if (++this.mPauseTimerRefCount == 1) {
            this.setDeferringTimers(false);
        }
    }

    public void setCacheSize(int n) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#setCacheSize(I)V", true, this);
    }

    public void setCookies(String url, String docUrl, String value) {
        if (value.contains("\r") || value.contains("\n")) {
            int size = value.length();
            StringBuilder buffer = new StringBuilder(size);
            int i = 0;
            while (i != -1 && i < size) {
                int newi;
                int ir = value.indexOf(13, i);
                int in = value.indexOf(10, i);
                int n = ir == -1 ? in : (in == -1 ? ir : (newi = ir < in ? ir : in));
                if (newi > i) {
                    buffer.append(value.subSequence(i, newi));
                } else if (newi == -1) {
                    buffer.append(value.subSequence(i, size));
                    break;
                }
                i = newi + 1;
            }
            value = buffer.toString();
        }
        CookieManager.getInstance().setCookie(url, value);
    }

    public String cookies(String url) {
        return CookieManager.getInstance().getCookie(url);
    }

    public boolean cookiesEnabled() {
        return CookieManager.getInstance().acceptCookie();
    }

    public void setSharedTimer(long timemillis) {
        if (timemillis <= 0L) {
            if (this.mHasInstantTimer) {
                return;
            }
            this.mHasInstantTimer = true;
            Message msg = this.obtainMessage(1);
            this.sendMessageDelayed(msg, timemillis);
        } else {
            Message msg = this.obtainMessage(1);
            this.sendMessageDelayed(msg, timemillis);
        }
    }

    public void stopSharedTimer() {
        this.removeMessages(1);
        this.mHasInstantTimer = false;
    }

    public void nativeConstructor() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeConstructor()V", true, this);
    }

    public void nativeFinalize() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeFinalize()V", true, this);
    }

    public void sharedTimerFired() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#sharedTimerFired()V", true, this);
    }

    public void setDeferringTimers(boolean bl) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#setDeferringTimers(Z)V", true, this);
    }

    public void setNetworkOnLine(boolean bl) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#setNetworkOnLine(Z)V", true, this);
    }
}

