/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.Headers;
import android.os.FileUtils;
import android.util.Log;
import android.webkit.HttpDateTime;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    public static final String LOGTAG = "cache";
    public static final String HEADER_KEY_IFMODIFIEDSINCE = "if-modified-since";
    public static final String HEADER_KEY_IFNONEMATCH = "if-none-match";
    public static final String NO_STORE = "no-store";
    public static final String NO_CACHE = "no-cache";
    public static final String PRIVATE = "private";
    public static final String MAX_AGE = "max-age";
    public static long CACHE_THRESHOLD = 0x600000L;
    public static long CACHE_TRIM_AMOUNT = 0x200000L;
    public static boolean mDisabled;
    public static int mRefCount;
    public static int mTrimCacheCount;
    public static final int TRIM_CACHE_INTERVAL = 5;
    public static WebViewDatabase mDataBase;
    public static File mBaseDir;
    public static boolean mClearCacheOnInit;

    public static void init(Context context) {
        mDataBase = WebViewDatabase.getInstance(context);
        mBaseDir = new File(context.getCacheDir(), "webviewCache");
        if (CacheManager.createCacheDirectory() && mClearCacheOnInit) {
            CacheManager.removeAllCacheFiles();
            mClearCacheOnInit = false;
        }
    }

    public static boolean createCacheDirectory() {
        if (!mBaseDir.exists()) {
            if (!mBaseDir.mkdirs()) {
                Log.w(LOGTAG, "Unable to create webviewCache directory");
                return false;
            }
            FileUtils.setPermissions(mBaseDir.toString(), 505, -1, -1);
            WebViewCore.endCacheTransaction();
            mDataBase.clearCache();
            WebViewCore.startCacheTransaction();
            return true;
        }
        return false;
    }

    public static File getCacheFileBaseDir() {
        return mBaseDir;
    }

    public static void setCacheDisabled(boolean disabled) {
        if (disabled == mDisabled) {
            return;
        }
        mDisabled = disabled;
        if (mDisabled) {
            CacheManager.removeAllCacheFiles();
        }
    }

    public static boolean cacheDisabled() {
        return mDisabled;
    }

    public static boolean enableTransaction() {
        if (++mRefCount == 1) {
            mDataBase.startCacheTransaction();
            return true;
        }
        return false;
    }

    public static boolean disableTransaction() {
        if (mRefCount == 0) {
            Log.e(LOGTAG, "disableTransaction is out of sync");
        }
        if (--mRefCount == 0) {
            mDataBase.endCacheTransaction();
            return true;
        }
        return false;
    }

    public static boolean startCacheTransaction() {
        return mDataBase.startCacheTransaction();
    }

    public static boolean endCacheTransaction() {
        boolean ret = mDataBase.endCacheTransaction();
        if (++mTrimCacheCount >= 5) {
            mTrimCacheCount = 0;
            CacheManager.trimCacheIfNeeded();
        }
        return ret;
    }

    public static CacheResult getCacheFile(String url, Map<String, String> headers) {
        if (mDisabled) {
            return null;
        }
        CacheResult result = mDataBase.getCache(url);
        if (result != null) {
            if (result.contentLength == 0L) {
                if (!CacheManager.checkCacheRedirect(result.httpStatusCode)) {
                    mDataBase.removeCache(url);
                    return null;
                }
            } else {
                File src = new File(mBaseDir, result.localPath);
                try {
                    result.inStream = new FileInputStream(src);
                }
                catch (FileNotFoundException e) {
                    mDataBase.removeCache(url);
                    return null;
                }
            }
        } else {
            return null;
        }
        if (headers != null && result.expires >= 0L && result.expires <= System.currentTimeMillis()) {
            if (result.lastModified == null && result.etag == null) {
                return null;
            }
            if (result.etag != null) {
                headers.put(HEADER_KEY_IFNONEMATCH, result.etag);
            }
            if (result.lastModified != null) {
                headers.put(HEADER_KEY_IFMODIFIEDSINCE, result.lastModified);
            }
        }
        return result;
    }

    public static CacheResult createCacheFile(String url, int statusCode, Headers headers, String mimeType, boolean forceCache) {
        if (!forceCache && mDisabled) {
            return null;
        }
        if (statusCode == 303) {
            return null;
        }
        if (CacheManager.checkCacheRedirect(statusCode) && !headers.getSetCookie().isEmpty()) {
            return null;
        }
        CacheResult ret = CacheManager.parseHeaders(statusCode, headers, mimeType);
        if (ret != null) {
            CacheManager.setupFiles(url, ret);
            try {
                ret.outStream = new FileOutputStream(ret.outFile);
            }
            catch (FileNotFoundException e) {
                if (CacheManager.createCacheDirectory()) {
                    try {
                        ret.outStream = new FileOutputStream(ret.outFile);
                    }
                    catch (FileNotFoundException e2) {
                        return null;
                    }
                }
                return null;
            }
            ret.mimeType = mimeType;
        }
        return ret;
    }

    public static void saveCacheFile(String url, CacheResult cacheRet) {
        try {
            cacheRet.outStream.close();
        }
        catch (IOException e) {
            return;
        }
        if (!cacheRet.outFile.exists()) {
            return;
        }
        cacheRet.contentLength = cacheRet.outFile.length();
        if (CacheManager.checkCacheRedirect(cacheRet.httpStatusCode)) {
            cacheRet.contentLength = 0L;
            cacheRet.localPath = new String();
            cacheRet.outFile.delete();
        } else if (cacheRet.contentLength == 0L) {
            cacheRet.outFile.delete();
            return;
        }
        mDataBase.addCache(url, cacheRet);
    }

    public static boolean removeAllCacheFiles() {
        if (mBaseDir == null) {
            mClearCacheOnInit = true;
            return true;
        }
        Runnable clearCache = new Runnable(){

            public void run() {
                try {
                    String[] files = mBaseDir.list();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            new File(mBaseDir, files[i]).delete();
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                mDataBase.clearCache();
            }
        };
        new Thread(clearCache).start();
        return true;
    }

    public static boolean cacheEmpty() {
        return mDataBase.hasCache();
    }

    public static void trimCacheIfNeeded() {
        if (mDataBase.getCacheTotalSize() > CACHE_THRESHOLD) {
            ArrayList<String> pathList = mDataBase.trimCache(CACHE_TRIM_AMOUNT);
            int size = pathList.size();
            for (int i = 0; i < size; ++i) {
                new File(mBaseDir, pathList.get(i)).delete();
            }
        }
    }

    public static boolean checkCacheRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 307;
    }

    public static void setupFiles(String url, CacheResult cacheRet) {
        int hashCode = url.hashCode();
        StringBuffer ret = new StringBuffer(8);
        CacheManager.appendAsHex(hashCode, ret);
        String path = ret.toString();
        File file = new File(mBaseDir, path);
        boolean checkOldPath = true;
        while (file.exists()) {
            if (checkOldPath) {
                WebViewCore.endCacheTransaction();
                CacheResult oldResult = mDataBase.getCache(url);
                WebViewCore.startCacheTransaction();
                if (oldResult != null && oldResult.contentLength > 0L) {
                    if (path.equals(oldResult.localPath)) {
                        path = oldResult.localPath;
                        break;
                    }
                    path = oldResult.localPath;
                    file = new File(mBaseDir, path);
                    break;
                }
                checkOldPath = false;
            }
            ret = new StringBuffer(8);
            CacheManager.appendAsHex(++hashCode, ret);
            path = ret.toString();
            file = new File(mBaseDir, path);
        }
        cacheRet.localPath = path;
        cacheRet.outFile = file;
    }

    public static void appendAsHex(int i, StringBuffer ret) {
        String hex = Integer.toHexString(i);
        switch (hex.length()) {
            case 1: {
                ret.append("0000000");
                break;
            }
            case 2: {
                ret.append("000000");
                break;
            }
            case 3: {
                ret.append("00000");
                break;
            }
            case 4: {
                ret.append("0000");
                break;
            }
            case 5: {
                ret.append("000");
                break;
            }
            case 6: {
                ret.append("00");
                break;
            }
            case 7: {
                ret.append("0");
            }
        }
        ret.append(hex);
    }

    public static CacheResult parseHeaders(int statusCode, Headers headers, String mimeType) {
        String cacheControl;
        String etag;
        String lastModified;
        CacheResult ret = new CacheResult();
        ret.httpStatusCode = statusCode;
        String location = headers.getLocation();
        if (location != null) {
            ret.location = location;
        }
        ret.expires = -1L;
        String expires = headers.getExpires();
        if (expires != null) {
            try {
                ret.expires = HttpDateTime.parse(expires);
            }
            catch (IllegalArgumentException ex) {
                if ("-1".equals(expires) || "0".equals(expires)) {
                    ret.expires = 0L;
                }
                Log.e(LOGTAG, "illegal expires: " + expires);
            }
        }
        if ((lastModified = headers.getLastModified()) != null) {
            ret.lastModified = lastModified;
        }
        if ((etag = headers.getEtag()) != null) {
            ret.etag = etag;
        }
        if ((cacheControl = headers.getCacheControl()) != null) {
            String[] controls = cacheControl.toLowerCase().split("[ ,;]");
            for (int i = 0; i < controls.length; ++i) {
                if (NO_STORE.equals(controls[i])) {
                    return null;
                }
                if (NO_CACHE.equals(controls[i]) || PRIVATE.equals(controls[i])) {
                    ret.expires = 0L;
                    continue;
                }
                if (!controls[i].startsWith(MAX_AGE)) continue;
                int separator = controls[i].indexOf(61);
                if (separator < 0) {
                    separator = controls[i].indexOf(58);
                }
                if (separator <= 0) continue;
                String s = controls[i].substring(separator + 1);
                try {
                    long sec = Long.parseLong(s);
                    if (sec < 0L) continue;
                    ret.expires = System.currentTimeMillis() + 1000L * sec;
                    continue;
                }
                catch (NumberFormatException ex) {
                    if ("1d".equals(s)) {
                        ret.expires = System.currentTimeMillis() + 86400000L;
                        continue;
                    }
                    Log.e(LOGTAG, "exception in parseHeaders for max-age:" + controls[i].substring(separator + 1));
                    ret.expires = 0L;
                }
            }
        }
        if (NO_CACHE.equals(headers.getPragma())) {
            ret.expires = 0L;
        }
        if (ret.expires == -1L) {
            if (ret.httpStatusCode == 301) {
                ret.expires = Long.MAX_VALUE;
            } else if (ret.httpStatusCode == 302 || ret.httpStatusCode == 307) {
                ret.expires = 0L;
            } else if (ret.lastModified == null) {
                ret.expires = !mimeType.startsWith("text/html") ? System.currentTimeMillis() + 86400000L : 0L;
            } else {
                long lastmod = System.currentTimeMillis() + 86400000L;
                try {
                    lastmod = HttpDateTime.parse(ret.lastModified);
                }
                catch (IllegalArgumentException ex) {
                    Log.e(LOGTAG, "illegal lastModified: " + ret.lastModified);
                }
                long difference = System.currentTimeMillis() - lastmod;
                ret.expires = difference > 0L ? System.currentTimeMillis() + difference / 5L : lastmod;
            }
        }
        return ret;
    }

    static {
        mTrimCacheCount = 0;
        mClearCacheOnInit = false;
    }

    public static class CacheResult {
        public int httpStatusCode;
        public long contentLength;
        public long expires;
        public String localPath;
        public String lastModified;
        public String etag;
        public String mimeType;
        public String location;
        public String encoding;
        public InputStream inStream;
        public OutputStream outStream;
        public File outFile;

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public long getExpires() {
            return this.expires;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getETag() {
            return this.etag;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public InputStream getInputStream() {
            return this.inStream;
        }

        public OutputStream getOutputStream() {
            return this.outStream;
        }

        public void setInputStream(InputStream stream) {
            this.inStream = stream;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }
    }
}

