/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;

public abstract class WindowOrientationListener {
    public static final String TAG = "WindowOrientationListener";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public SensorManager mSensorManager;
    public boolean mEnabled = false;
    public int mRate;
    public Sensor mSensor;
    public SensorEventListener mSensorEventListener;
    public int mSensorRotation = -1;

    public WindowOrientationListener(Context context) {
        this(context, 3);
    }

    public WindowOrientationListener(Context context, int rate) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl();
        }
    }

    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (!this.mEnabled) {
            this.mSensorRotation = -1;
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
        }
    }

    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (this.mEnabled) {
            this.mSensorRotation = -1;
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
        }
    }

    public int getCurrentRotation() {
        return this.mSensorRotation;
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    public abstract void onOrientationChanged(int var1);

    public class SensorEventListenerImpl
    implements SensorEventListener {
        public static final int _DATA_X = 0;
        public static final int _DATA_Y = 1;
        public static final int _DATA_Z = 2;
        public static final int PIVOT = 20;
        public static final int PIVOT_UPPER = 65;
        public static final int PIVOT_LOWER = -10;
        public static final int PL_UPPER = 295;
        public static final int LP_LOWER = 320;
        public static final int PL_LOWER = 270;
        public static final int LP_UPPER = 359;
        public static final int LANDSCAPE_LOWER = 235;
        public static final int PORTRAIT_LOWER = 60;
        public static final float PL_LF_UPPER = 0.5555556f;
        public static final float PL_LF_LOWER = 0.8333333f;
        public static final float LP_LF_UPPER = 0.8666667f;
        public static final float LP_LF_LOWER = 1.3f;

        public void onSensorChanged(SensorEvent event) {
            float[] values = event.values;
            float X = values[0];
            float Y = values[1];
            float Z = values[2];
            float OneEightyOverPi = 57.29578f;
            float gravity = (float)Math.sqrt(X * X + Y * Y + Z * Z);
            float zyangle = (float)Math.asin(Z / gravity) * OneEightyOverPi;
            int rotation = -1;
            if (zyangle <= 65.0f && zyangle >= -10.0f) {
                int orientation;
                float angle = (float)Math.atan2(Y, -X) * OneEightyOverPi;
                for (orientation = 90 - Math.round(angle); orientation >= 360; orientation -= 360) {
                }
                while (orientation < 0) {
                    orientation += 360;
                }
                if (orientation >= 270 && orientation <= 359) {
                    float delta = zyangle - 20.0f;
                    if (WindowOrientationListener.this.mSensorRotation == 1) {
                        float threshold = delta < 0.0f ? 320.0f - 1.3f * delta : 320.0f + 0.8666667f * delta;
                        rotation = (float)orientation >= threshold ? 0 : 1;
                    } else {
                        float threshold = delta < 0.0f ? 295.0f + 0.8333333f * delta : 295.0f - 0.5555556f * delta;
                        rotation = (float)orientation <= threshold ? 1 : 0;
                    }
                } else if (orientation >= 235 && orientation < 320) {
                    rotation = 1;
                } else if (orientation >= 295 || orientation <= 60) {
                    rotation = 0;
                }
                if (rotation != -1 && rotation != WindowOrientationListener.this.mSensorRotation) {
                    WindowOrientationListener.this.mSensorRotation = rotation;
                    WindowOrientationListener.this.onOrientationChanged(WindowOrientationListener.this.mSensorRotation);
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

