/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.view.MotionEvent;

public class VelocityTracker {
    public static final String TAG = "VelocityTracker";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public static final int NUM_PAST = 10;
    public static final int LONGEST_PAST_TIME = 200;
    public static final VelocityTracker[] mPool = new VelocityTracker[1];
    public final float[] mPastX = new float[10];
    public final float[] mPastY = new float[10];
    public final long[] mPastTime = new long[10];
    public float mYVelocity;
    public float mXVelocity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VelocityTracker obtain() {
        VelocityTracker[] velocityTrackerArray = mPool;
        synchronized (mPool) {
            VelocityTracker vt = mPool[0];
            if (vt != null) {
                vt.clear();
                VelocityTracker.mPool[0] = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return vt;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new VelocityTracker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        VelocityTracker[] velocityTrackerArray = mPool;
        synchronized (mPool) {
            VelocityTracker.mPool[0] = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void clear() {
        this.mPastTime[0] = 0L;
    }

    public void addMovement(MotionEvent ev) {
        long time = ev.getEventTime();
        int N = ev.getHistorySize();
        for (int i = 0; i < N; ++i) {
            this.addPoint(ev.getHistoricalX(i), ev.getHistoricalY(i), ev.getHistoricalEventTime(i));
        }
        this.addPoint(ev.getX(), ev.getY(), time);
    }

    public void addPoint(float x, float y, long time) {
        int i;
        int drop = -1;
        long[] pastTime = this.mPastTime;
        for (i = 0; i < 10 && pastTime[i] != 0L; ++i) {
            if (pastTime[i] >= time - 200L) continue;
            drop = i;
        }
        if (i == 10 && drop < 0) {
            drop = 0;
        }
        if (drop == i) {
            --drop;
        }
        float[] pastX = this.mPastX;
        float[] pastY = this.mPastY;
        if (drop >= 0) {
            int start = drop + 1;
            int count = 10 - drop - 1;
            System.arraycopy(pastX, start, pastX, 0, count);
            System.arraycopy(pastY, start, pastY, 0, count);
            System.arraycopy(pastTime, start, pastTime, 0, count);
            i -= drop + 1;
        }
        pastX[i] = x;
        pastY[i] = y;
        pastTime[i] = time;
        if (++i < 10) {
            pastTime[i] = 0L;
        }
    }

    public void computeCurrentVelocity(int units) {
        int N;
        float[] pastX = this.mPastX;
        float[] pastY = this.mPastY;
        long[] pastTime = this.mPastTime;
        float oldestX = pastX[0];
        float oldestY = pastY[0];
        long oldestTime = pastTime[0];
        float accumX = 0.0f;
        float accumY = 0.0f;
        for (N = 0; N < 10 && pastTime[N] != 0L; ++N) {
        }
        if (N > 3) {
            --N;
        }
        for (int i = 1; i < N; ++i) {
            int dur = (int)(pastTime[i] - oldestTime);
            if (dur == 0) continue;
            float dist = pastX[i] - oldestX;
            float vel = dist / (float)dur * (float)units;
            accumX = accumX == 0.0f ? vel : (accumX + vel) * 0.5f;
            dist = pastY[i] - oldestY;
            vel = dist / (float)dur * (float)units;
            accumY = accumY == 0.0f ? vel : (accumY + vel) * 0.5f;
        }
        this.mXVelocity = accumX;
        this.mYVelocity = accumY;
    }

    public float getXVelocity() {
        return this.mXVelocity;
    }

    public float getYVelocity() {
        return this.mYVelocity;
    }
}

