/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLog {
    public static final byte INT = 0;
    public static final byte LONG = 1;
    public static final byte STRING = 2;
    public static final byte LIST = 3;

    public static int writeEvent(int n, int n2) {
        return OverrideMethod.invokeI("android.util.EventLog#writeEvent(II)I", true, null);
    }

    public static int writeEvent(int n, long l) {
        return OverrideMethod.invokeI("android.util.EventLog#writeEvent(IJ)I", true, null);
    }

    public static int writeEvent(int n, String string2) {
        return OverrideMethod.invokeI("android.util.EventLog#writeEvent(ILjava/lang/String;)I", true, null);
    }

    public static int writeEvent(int n, List list) {
        return OverrideMethod.invokeI("android.util.EventLog#writeEvent(ILandroid/util/EventLog$List;)I", true, null);
    }

    public static int writeEvent(int tag, Object ... list) {
        return EventLog.writeEvent(tag, new List(list));
    }

    public static void readEvents(int[] nArray, Collection<Event> collection) throws IOException {
        OverrideMethod.invokeV("android.util.EventLog#readEvents([ILjava/util/Collection;)V", true, null);
    }

    public static class Event {
        public final ByteBuffer mBuffer;
        public static final int LENGTH_OFFSET = 0;
        public static final int PROCESS_OFFSET = 4;
        public static final int THREAD_OFFSET = 8;
        public static final int SECONDS_OFFSET = 12;
        public static final int NANOSECONDS_OFFSET = 16;
        public static final int PAYLOAD_START = 20;
        public static final int TAG_OFFSET = 20;
        public static final int DATA_START = 24;

        public Event(byte[] data) {
            this.mBuffer = ByteBuffer.wrap(data);
            this.mBuffer.order(ByteOrder.nativeOrder());
        }

        public int getProcessId() {
            return this.mBuffer.getInt(4);
        }

        public int getThreadId() {
            return this.mBuffer.getInt(8);
        }

        public long getTimeNanos() {
            return (long)this.mBuffer.getInt(12) * 1000000000L + (long)this.mBuffer.getInt(16);
        }

        public int getTag() {
            return this.mBuffer.getInt(20);
        }

        public synchronized Object getData() {
            this.mBuffer.limit(20 + this.mBuffer.getShort(0));
            this.mBuffer.position(24);
            return this.decodeObject();
        }

        public Object decodeObject() {
            if (this.mBuffer.remaining() < 1) {
                return null;
            }
            switch (this.mBuffer.get()) {
                case 0: {
                    if (this.mBuffer.remaining() < 4) {
                        return null;
                    }
                    return this.mBuffer.getInt();
                }
                case 1: {
                    if (this.mBuffer.remaining() < 8) {
                        return null;
                    }
                    return this.mBuffer.getLong();
                }
                case 2: {
                    try {
                        if (this.mBuffer.remaining() < 4) {
                            return null;
                        }
                        int length = this.mBuffer.getInt();
                        if (length < 0 || this.mBuffer.remaining() < length) {
                            return null;
                        }
                        int start = this.mBuffer.position();
                        this.mBuffer.position(start + length);
                        return new String(this.mBuffer.array(), start, length, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                case 3: {
                    if (this.mBuffer.remaining() < 1) {
                        return null;
                    }
                    int length = this.mBuffer.get();
                    if (length <= 0) {
                        return null;
                    }
                    Object[] array2 = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        array2[i] = this.decodeObject();
                        if (array2[i] != null) continue;
                        return null;
                    }
                    return new List(array2);
                }
            }
            return null;
        }
    }

    public static class List {
        public Object[] mItems;

        public Object getItem(int pos) {
            return this.mItems[pos];
        }

        public byte getNumItems() {
            return (byte)this.mItems.length;
        }

        public List(Object ... items) throws IllegalArgumentException {
            if (items.length > 127) {
                throw new IllegalArgumentException("A List must have fewer than 127 items in it.");
            }
            if (items.length < 1) {
                throw new IllegalArgumentException("A List must have at least one item in it.");
            }
            for (int i = 0; i < items.length; ++i) {
                Object item = items[i];
                if (item == null) {
                    items[i] = "";
                    continue;
                }
                if (item instanceof List || item instanceof String || item instanceof Integer || item instanceof Long) continue;
                throw new IllegalArgumentException("Attempt to create a List with illegal item type.");
            }
            this.mItems = items;
        }
    }
}

