/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.StringReader;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlToSpannedConverter
implements ContentHandler {
    public static final float[] HEADER_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    public String mSource;
    public XMLReader mReader;
    public SpannableStringBuilder mSpannableStringBuilder;
    public Html.ImageGetter mImageGetter;
    public Html.TagHandler mTagHandler;

    public HtmlToSpannedConverter(String source, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser) {
        this.mSource = source;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
    }

    public Spanned convert() {
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        ParagraphStyle[] obj = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class);
        for (int i = 0; i < obj.length; ++i) {
            int start = this.mSpannableStringBuilder.getSpanStart(obj[i]);
            int end = this.mSpannableStringBuilder.getSpanEnd(obj[i]);
            if (end - 2 >= 0 && this.mSpannableStringBuilder.charAt(end - 1) == '\n' && this.mSpannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.mSpannableStringBuilder.removeSpan(obj[i]);
                continue;
            }
            this.mSpannableStringBuilder.setSpan(obj[i], start, end, 51);
        }
        return this.mSpannableStringBuilder;
    }

    public void handleStartTag(String tag, Attributes attributes) {
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("p")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            } else if (tag.equalsIgnoreCase("div")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            } else if (tag.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold(null));
            } else if (tag.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold(null));
            } else if (tag.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Big(null));
            } else if (tag.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Small(null));
            } else if (tag.equalsIgnoreCase("font")) {
                HtmlToSpannedConverter.startFont(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("blockquote")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Blockquote(null));
            } else if (tag.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Monospace(null));
            } else if (tag.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.startA(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Underline(null));
            } else if (tag.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Super(null));
            } else if (tag.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Sub(null));
            } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Header(tag.charAt(1) - 49));
            } else if (tag.equalsIgnoreCase("img")) {
                HtmlToSpannedConverter.startImg(this.mSpannableStringBuilder, attributes, this.mImageGetter);
            } else if (this.mTagHandler != null) {
                this.mTagHandler.handleTag(true, tag, this.mSpannableStringBuilder, this.mReader);
            }
        }
    }

    public void handleEndTag(String tag) {
        if (tag.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("b")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("strong")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
        } else if (tag.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
        } else if (tag.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Blockquote.class, new QuoteSpan());
        } else if (tag.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.endA(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
        } else if (tag.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
        } else if (tag.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
        } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endHeader(this.mSpannableStringBuilder);
        } else if (this.mTagHandler != null) {
            this.mTagHandler.handleTag(false, tag, this.mSpannableStringBuilder, this.mReader);
        }
    }

    public static void handleP(SpannableStringBuilder text) {
        int len = text.length();
        if (len >= 1 && text.charAt(len - 1) == '\n') {
            if (len >= 2 && text.charAt(len - 2) == '\n') {
                return;
            }
            text.append("\n");
            return;
        }
        if (len != 0) {
            text.append("\n\n");
        }
    }

    public static void handleBr(SpannableStringBuilder text) {
        text.append("\n");
    }

    public static Object getLast(Spanned text, Class kind) {
        T[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return objs[objs.length - 1];
    }

    public static void start(SpannableStringBuilder text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    public static void end(SpannableStringBuilder text, Class kind, Object repl) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, kind);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            text.setSpan(repl, where, len, 33);
        }
    }

    public static void startImg(SpannableStringBuilder text, Attributes attributes, Html.ImageGetter img) {
        String src = attributes.getValue("", "src");
        Drawable d = null;
        if (img != null) {
            d = img.getDrawable(src);
        }
        if (d == null) {
            d = Resources.getSystem().getDrawable(17302143);
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        }
        int len = text.length();
        text.append("\ufffc");
        text.setSpan(new ImageSpan(d, src), len, text.length(), 33);
    }

    public static void startFont(SpannableStringBuilder text, Attributes attributes) {
        String color2 = attributes.getValue("", "color");
        String face = attributes.getValue("", "face");
        int len = text.length();
        text.setSpan(new Font(color2, face), len, len, 17);
    }

    public static void endFont(SpannableStringBuilder text) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, Font.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            Font f = (Font)obj;
            if (f.mColor != null) {
                int c = -1;
                if (f.mColor.equalsIgnoreCase("aqua")) {
                    c = 65535;
                } else if (f.mColor.equalsIgnoreCase("black")) {
                    c = 0;
                } else if (f.mColor.equalsIgnoreCase("blue")) {
                    c = 255;
                } else if (f.mColor.equalsIgnoreCase("fuchsia")) {
                    c = 0xFF00FF;
                } else if (f.mColor.equalsIgnoreCase("green")) {
                    c = 32768;
                } else if (f.mColor.equalsIgnoreCase("grey")) {
                    c = 0x808080;
                } else if (f.mColor.equalsIgnoreCase("lime")) {
                    c = 65280;
                } else if (f.mColor.equalsIgnoreCase("maroon")) {
                    c = 0x800000;
                } else if (f.mColor.equalsIgnoreCase("navy")) {
                    c = 128;
                } else if (f.mColor.equalsIgnoreCase("olive")) {
                    c = 0x808000;
                } else if (f.mColor.equalsIgnoreCase("purple")) {
                    c = 0x800080;
                } else if (f.mColor.equalsIgnoreCase("red")) {
                    c = 0xFF0000;
                } else if (f.mColor.equalsIgnoreCase("silver")) {
                    c = 0xC0C0C0;
                } else if (f.mColor.equalsIgnoreCase("teal")) {
                    c = 32896;
                } else if (f.mColor.equalsIgnoreCase("white")) {
                    c = 0xFFFFFF;
                } else if (f.mColor.equalsIgnoreCase("yellow")) {
                    c = 0xFFFF00;
                } else {
                    try {
                        c = XmlUtils.convertValueToInt(f.mColor, -1);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (c != -1) {
                    text.setSpan(new ForegroundColorSpan(c | 0xFF000000), where, len, 33);
                }
            }
            if (f.mFace != null) {
                text.setSpan(new TypefaceSpan(f.mFace), where, len, 33);
            }
        }
    }

    public static void startA(SpannableStringBuilder text, Attributes attributes) {
        String href = attributes.getValue("", "href");
        int len = text.length();
        text.setSpan(new Href(href), len, len, 17);
    }

    public static void endA(SpannableStringBuilder text) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, Href.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            Href h = (Href)obj;
            if (h.mHref != null) {
                text.setSpan(new URLSpan(h.mHref), where, len, 33);
            }
        }
    }

    public static void endHeader(SpannableStringBuilder text) {
        int len;
        Object obj = HtmlToSpannedConverter.getLast(text, Header.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        for (len = text.length(); len > where && text.charAt(len - 1) == '\n'; --len) {
        }
        if (where != len) {
            Header h = (Header)obj;
            text.setSpan(new RelativeSizeSpan(HEADER_SIZES[h.mLevel]), where, len, 33);
            text.setSpan(new StyleSpan(1), where, len, 33);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mSpannableStringBuilder.append(sb);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public static class 1 {
    }

    public static class Header {
        public int mLevel;

        public Header(int level) {
            this.mLevel = level;
        }
    }

    public static class Href {
        public String mHref;

        public Href(String href) {
            this.mHref = href;
        }
    }

    public static class Font {
        public String mColor;
        public String mFace;

        public Font(String color2, String face) {
            this.mColor = color2;
            this.mFace = face;
        }
    }

    public static class Sub {
        public Sub() {
        }

        public /* synthetic */ Sub(1 x0) {
            this();
        }
    }

    public static class Super {
        public Super() {
        }

        public /* synthetic */ Super(1 x0) {
            this();
        }
    }

    public static class Blockquote {
        public Blockquote() {
        }

        public /* synthetic */ Blockquote(1 x0) {
            this();
        }
    }

    public static class Monospace {
        public Monospace() {
        }

        public /* synthetic */ Monospace(1 x0) {
            this();
        }
    }

    public static class Small {
        public Small() {
        }

        public /* synthetic */ Small(1 x0) {
            this();
        }
    }

    public static class Big {
        public Big() {
        }

        public /* synthetic */ Big(1 x0) {
            this();
        }
    }

    public static class Underline {
        public Underline() {
        }

        public /* synthetic */ Underline(1 x0) {
            this();
        }
    }

    public static class Italic {
        public Italic() {
        }

        public /* synthetic */ Italic(1 x0) {
            this();
        }
    }

    public static class Bold {
        public Bold() {
        }

        public /* synthetic */ Bold(1 x0) {
            this();
        }
    }
}

