/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import com.android.tools.layoutlib.create.OverrideMethod;

public class SystemProperties {
    public static final int PROP_NAME_MAX = 31;
    public static final int PROP_VALUE_MAX = 91;

    public static String native_get(String string2) {
        return (String)OverrideMethod.invokeA("android.os.SystemProperties#native_get(Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static String native_get(String string2, String string3) {
        return (String)OverrideMethod.invokeA("android.os.SystemProperties#native_get(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    public static void native_set(String string2, String string3) {
        OverrideMethod.invokeV("android.os.SystemProperties#native_set(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    public static String get(String key) {
        if (key.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get(key);
    }

    public static String get(String key, String def) {
        if (key.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        return SystemProperties.native_get(key, def);
    }

    public static int getInt(String key, int def) {
        try {
            return Integer.parseInt(SystemProperties.get(key));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static long getLong(String key, long def) {
        try {
            return Long.parseLong(SystemProperties.get(key));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static boolean getBoolean(String key, boolean def) {
        String value = SystemProperties.get(key);
        if (value.equals("")) {
            return def;
        }
        if (value.equals("0")) {
            return false;
        }
        if (value.equals("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("n") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off")) {
            return false;
        }
        if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on")) {
            return true;
        }
        return def;
    }

    public static void set(String key, String val) {
        if (key.length() > 31) {
            throw new IllegalArgumentException("key.length > 31");
        }
        if (val != null && val.length() > 91) {
            throw new IllegalArgumentException("val.length > 91");
        }
        SystemProperties.native_set(key, val);
    }
}

