/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class FileUtils {
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");

    public static boolean getFileStatus(String string2, FileStatus fileStatus) {
        return OverrideMethod.invokeI("android.os.FileUtils#getFileStatus(Ljava/lang/String;Landroid/os/FileUtils$FileStatus;)Z", true, null) != 0;
    }

    public static int setPermissions(String string2, int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.os.FileUtils#setPermissions(Ljava/lang/String;III)I", true, null);
    }

    public static int getPermissions(String string2, int[] nArray) {
        return OverrideMethod.invokeI("android.os.FileUtils#getPermissions(Ljava/lang/String;[I)I", true, null);
    }

    public static int getFatVolumeId(String string2) {
        return OverrideMethod.invokeI("android.os.FileUtils#getFatVolumeId(Ljava/lang/String;)I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File srcFile, File destFile) {
        boolean result = false;
        try {
            FileInputStream in = new FileInputStream(srcFile);
            try {
                result = FileUtils.copyToFile(in, destFile);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyToFile(InputStream inputStream, File destFile) {
        try {
            FileOutputStream out = new FileOutputStream(destFile);
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isFilenameSafe(File file) {
        return SAFE_FILENAME_PATTERN.matcher(file.getPath()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, int max, String ellipsis) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            int len;
            if (max > 0) {
                byte[] data = new byte[max + 1];
                int length = ((InputStream)input).read(data);
                if (length <= 0) {
                    String string2 = "";
                    return string2;
                }
                if (length <= max) {
                    String string3 = new String(data, 0, length);
                    return string3;
                }
                if (ellipsis == null) {
                    String string4 = new String(data, 0, max);
                    return string4;
                }
                String string5 = new String(data, 0, max) + ellipsis;
                return string5;
            }
            if (max < 0) {
                String string6;
                int len2;
                boolean rolled = false;
                byte[] last = null;
                byte[] data = null;
                do {
                    if (last != null) {
                        rolled = true;
                    }
                    byte[] tmp = last;
                    last = data;
                    data = tmp;
                    if (data != null) continue;
                    data = new byte[-max];
                } while ((len2 = ((InputStream)input).read(data)) == data.length);
                if (last == null && len2 <= 0) {
                    string6 = "";
                    return string6;
                }
                if (last == null) {
                    string6 = new String(data, 0, len2);
                    return string6;
                }
                if (len2 > 0) {
                    rolled = true;
                    System.arraycopy(last, len2, last, 0, last.length - len2);
                    System.arraycopy(data, 0, last, last.length - len2, len2);
                }
                if (ellipsis == null || !rolled) {
                    string6 = new String(last);
                    return string6;
                }
                string6 = ellipsis + new String(last);
                return string6;
            }
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            do {
                if ((len = ((InputStream)input).read(data)) <= 0) continue;
                contents.write(data, 0, len);
            } while (len == data.length);
            String string7 = contents.toString();
            return string7;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public static class FileStatus {
        public int dev;
        public int ino;
        public int mode;
        public int nlink;
        public int uid;
        public int gid;
        public int rdev;
        public long size;
        public int blksize;
        public long blocks;
        public long atime;
        public long mtime;
        public long ctime;
    }
}

