/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.SystemProperties;
import android.provider.Settings;
import junit.framework.Assert;

public class Proxy {
    public static final String PROXY_CHANGE_ACTION = "android.intent.action.PROXY_CHANGE";

    public static String getHost(Context ctx) {
        ContentResolver contentResolver = ctx.getContentResolver();
        Assert.assertNotNull(contentResolver);
        String host = Settings.Secure.getString(contentResolver, "http_proxy");
        if (host != null) {
            int i = host.indexOf(58);
            if (i == -1) {
                return null;
            }
            return host.substring(0, i);
        }
        return Proxy.getDefaultHost();
    }

    public static int getPort(Context ctx) {
        ContentResolver contentResolver = ctx.getContentResolver();
        Assert.assertNotNull(contentResolver);
        String host = Settings.Secure.getString(contentResolver, "http_proxy");
        if (host != null) {
            int i = host.indexOf(58);
            if (i == -1) {
                return -1;
            }
            return Integer.parseInt(host.substring(i + 1));
        }
        return Proxy.getDefaultPort();
    }

    public static String getDefaultHost() {
        String host = SystemProperties.get("net.gprs.http-proxy");
        if (host != null) {
            Uri u = Uri.parse(host);
            host = u.getHost();
            return host;
        }
        return null;
    }

    public static int getDefaultPort() {
        String host = SystemProperties.get("net.gprs.http-proxy");
        if (host != null) {
            Uri u = Uri.parse(host);
            return u.getPort();
        }
        return -1;
    }
}

