/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.ddm.DdmHandleAppName;
import android.os.Debug;
import android.os.Process;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleHello
extends ChunkHandler {
    public static final int CHUNK_HELO = DdmHandleHello.type("HELO");
    public static final int CHUNK_WAIT = DdmHandleHello.type("WAIT");
    public static DdmHandleHello mInstance = new DdmHandleHello();

    public static void register() {
        DdmServer.registerHandler(CHUNK_HELO, mInstance);
    }

    public void connected() {
        byte[] data = new byte[]{0, 1, 2, 3, 4, -4, -3, -2, -1, 127};
        Chunk testChunk = new Chunk(ChunkHandler.type("TEST"), data, 1, data.length - 2);
        DdmServer.sendChunk(testChunk);
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        ByteBuffer in = DdmHandleHello.wrapChunk(request);
        int serverProtoVers = in.getInt();
        String vmName = System.getProperty("java.vm.name", "?");
        String vmVersion = System.getProperty("java.vm.version", "?");
        String vmIdent = vmName + " v" + vmVersion;
        String appName = DdmHandleAppName.getAppName();
        ByteBuffer out = ByteBuffer.allocate(16 + vmIdent.length() * 2 + appName.length() * 2);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(1);
        out.putInt(Process.myPid());
        out.putInt(vmIdent.length());
        out.putInt(appName.length());
        DdmHandleHello.putString(out, vmIdent);
        DdmHandleHello.putString(out, appName);
        Chunk reply = new Chunk(CHUNK_HELO, out);
        if (Debug.waitingForDebugger()) {
            DdmHandleHello.sendWAIT(0);
        }
        return reply;
    }

    public static void sendWAIT(int reason) {
        byte[] data = new byte[]{(byte)reason};
        Chunk waitChunk = new Chunk(CHUNK_WAIT, data, 0, 1);
        DdmServer.sendChunk(waitChunk);
    }
}

