/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ComponentCallbacks;
import android.content.ContentProviderNative;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.ISyncAdapter;
import android.content.SyncAdapter;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.CursorToBulkCursorAdaptor;
import android.database.CursorWindow;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.FileNotFoundException;

public abstract class ContentProvider
implements ComponentCallbacks {
    public Context mContext = null;
    public String mReadPermission;
    public String mWritePermission;
    public Transport mTransport = new Transport();

    public static ContentProvider coerceToLocalContentProvider(IContentProvider abstractInterface) {
        if (abstractInterface instanceof Transport) {
            return ((Transport)abstractInterface).getContentProvider();
        }
        return null;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setReadPermission(String permission2) {
        this.mReadPermission = permission2;
    }

    public String getReadPermission() {
        return this.mReadPermission;
    }

    public void setWritePermission(String permission2) {
        this.mWritePermission = permission2;
    }

    public String getWritePermission() {
        return this.mWritePermission;
    }

    public abstract boolean onCreate();

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    public abstract String getType(Uri var1);

    public abstract Uri insert(Uri var1, ContentValues var2);

    public int bulkInsert(Uri uri, ContentValues[] values) {
        int numValues = values.length;
        for (int i = 0; i < numValues; ++i) {
            this.insert(uri, values[i]);
        }
        return numValues;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        throw new FileNotFoundException("No files supported by provider at " + uri);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor fd = this.openFile(uri, mode);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    public ParcelFileDescriptor openFileHelper(Uri uri, String mode) throws FileNotFoundException {
        int count;
        Cursor c = this.query(uri, new String[]{"_data"}, null, null, null);
        int n = count = c != null ? c.getCount() : 0;
        if (count != 1) {
            if (c != null) {
                c.close();
            }
            if (count == 0) {
                throw new FileNotFoundException("No entry for " + uri);
            }
            throw new FileNotFoundException("Multiple items at " + uri);
        }
        c.moveToFirst();
        int i = c.getColumnIndex("_data");
        String path = i >= 0 ? c.getString(i) : null;
        c.close();
        if (path == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int modeBits = ContentResolver.modeToMode(uri, mode);
        return ParcelFileDescriptor.open(new File(path), modeBits);
    }

    public SyncAdapter getSyncAdapter() {
        return null;
    }

    public boolean isTemporary() {
        return false;
    }

    public IContentProvider getIContentProvider() {
        return this.mTransport;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        if (this.mContext == null) {
            this.mContext = context;
            if (info != null) {
                this.setReadPermission(info.readPermission);
                this.setWritePermission(info.writePermission);
            }
            this.onCreate();
        }
    }

    public class Transport
    extends ContentProviderNative {
        public ContentProvider getContentProvider() {
            return ContentProvider.this;
        }

        public IBulkCursor bulkQuery(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, IContentObserver observer, CursorWindow window) {
            this.checkReadPermission(uri);
            Cursor cursor = ContentProvider.this.query(uri, projection, selection, selectionArgs, sortOrder);
            if (cursor == null) {
                return null;
            }
            String wperm = ContentProvider.this.getWritePermission();
            return new CursorToBulkCursorAdaptor(cursor, observer, ContentProvider.this.getClass().getName(), wperm == null || ContentProvider.this.getContext().checkCallingOrSelfPermission(ContentProvider.this.getWritePermission()) == 0, window);
        }

        public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
            this.checkReadPermission(uri);
            return ContentProvider.this.query(uri, projection, selection, selectionArgs, sortOrder);
        }

        public String getType(Uri uri) {
            return ContentProvider.this.getType(uri);
        }

        public Uri insert(Uri uri, ContentValues initialValues) {
            this.checkWritePermission(uri);
            return ContentProvider.this.insert(uri, initialValues);
        }

        public int bulkInsert(Uri uri, ContentValues[] initialValues) {
            this.checkWritePermission(uri);
            return ContentProvider.this.bulkInsert(uri, initialValues);
        }

        public int delete(Uri uri, String selection, String[] selectionArgs) {
            this.checkWritePermission(uri);
            return ContentProvider.this.delete(uri, selection, selectionArgs);
        }

        public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
            this.checkWritePermission(uri);
            return ContentProvider.this.update(uri, values, selection, selectionArgs);
        }

        public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
            if (mode != null && mode.startsWith("rw")) {
                this.checkWritePermission(uri);
            } else {
                this.checkReadPermission(uri);
            }
            return ContentProvider.this.openFile(uri, mode);
        }

        public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
            if (mode != null && mode.startsWith("rw")) {
                this.checkWritePermission(uri);
            } else {
                this.checkReadPermission(uri);
            }
            return ContentProvider.this.openAssetFile(uri, mode);
        }

        public ISyncAdapter getSyncAdapter() {
            this.checkWritePermission(null);
            SyncAdapter sa = ContentProvider.this.getSyncAdapter();
            return sa != null ? sa.getISyncAdapter() : null;
        }

        public void checkReadPermission(Uri uri) {
            String rperm = ContentProvider.this.getReadPermission();
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            if (ContentProvider.this.getContext().checkUriPermission(uri, rperm, null, pid, uid, 1) == 0) {
                return;
            }
            String msg = "Permission Denial: reading " + ContentProvider.this.getClass().getName() + " uri " + uri + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + rperm;
            throw new SecurityException(msg);
        }

        public void checkWritePermission(Uri uri) {
            String wperm = ContentProvider.this.getWritePermission();
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            if (ContentProvider.this.getContext().checkUriPermission(uri, null, wperm, pid, uid, 2) == 0) {
                return;
            }
            String msg = "Permission Denial: writing " + ContentProvider.this.getClass().getName() + " uri " + uri + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + wperm;
            throw new SecurityException(msg);
        }
    }
}

