/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.AccountMonitor;
import android.accounts.AccountMonitorListener;
import android.content.AbstractTableMerger;
import android.content.ContentValues;
import android.content.Context;
import android.content.SyncContext;
import android.content.SyncResult;
import android.content.SyncStateContentProviderHelper;
import android.content.SyncableContentProvider;
import android.content.TempProviderSyncAdapter;
import android.content.TempProviderSyncResult;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSyncableContentProvider
extends SyncableContentProvider {
    public static final String TAG = "SyncableContentProvider";
    public SQLiteOpenHelper mOpenHelper;
    public SQLiteDatabase mDb;
    public final String mDatabaseName;
    public final int mDatabaseVersion;
    public final Uri mContentUri;
    public AccountMonitor mAccountMonitor;
    public String mSyncingAccount;
    public SyncStateContentProviderHelper mSyncState = null;
    public static final String[] sAccountProjection = new String[]{"_sync_account"};
    public boolean mIsTemporary;
    public AbstractTableMerger mCurrentMerger = null;
    public boolean mIsMergeCancelled = false;
    public static final String SYNC_ACCOUNT_WHERE_CLAUSE = "_sync_account=?";
    public boolean mContainsDiffs;

    @Override
    public boolean isTemporary() {
        return this.mIsTemporary;
    }

    public AbstractSyncableContentProvider(String dbName, int dbVersion, Uri contentUri) {
        this.mDatabaseName = dbName;
        this.mDatabaseVersion = dbVersion;
        this.mContentUri = contentUri;
        this.mIsTemporary = false;
        this.setContainsDiffs(false);
    }

    @Override
    public void close() {
        if (this.mOpenHelper != null) {
            this.mOpenHelper.close();
        }
    }

    @Override
    public void bootstrapDatabase(SQLiteDatabase db) {
    }

    @Override
    public abstract boolean upgradeDatabase(SQLiteDatabase var1, int var2, int var3);

    @Override
    public void onDatabaseOpened(SQLiteDatabase db) {
    }

    @Override
    public boolean onCreate() {
        if (this.isTemporary()) {
            throw new IllegalStateException("onCreate() called for temp provider");
        }
        this.mOpenHelper = new DatabaseHelper(this.getContext(), this.mDatabaseName);
        this.mSyncState = new SyncStateContentProviderHelper(this.mOpenHelper);
        AccountMonitorListener listener = new AccountMonitorListener(){

            public void onAccountsUpdated(String[] accounts) {
                AbstractSyncableContentProvider.this.mDb = AbstractSyncableContentProvider.this.mOpenHelper.getWritableDatabase();
                AbstractSyncableContentProvider.this.onAccountsChanged(accounts);
                TempProviderSyncAdapter syncAdapter = (TempProviderSyncAdapter)AbstractSyncableContentProvider.this.getSyncAdapter();
                if (syncAdapter != null) {
                    syncAdapter.onAccountsChanged(accounts);
                }
            }
        };
        this.mAccountMonitor = new AccountMonitor(this.getContext(), listener);
        return true;
    }

    @Override
    public AbstractSyncableContentProvider getTemporaryInstance() {
        AbstractSyncableContentProvider temp;
        try {
            temp = (AbstractSyncableContentProvider)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to instantiate class, this should never happen", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccess while instantiating class, this should never happen", e);
        }
        temp.mIsTemporary = true;
        temp.setContainsDiffs(true);
        AbstractSyncableContentProvider abstractSyncableContentProvider = temp;
        abstractSyncableContentProvider.getClass();
        temp.mOpenHelper = abstractSyncableContentProvider.new DatabaseHelper(null, null);
        temp.mSyncState = new SyncStateContentProviderHelper(temp.mOpenHelper);
        if (!this.isTemporary()) {
            this.mSyncState.copySyncState(this.mOpenHelper.getReadableDatabase(), temp.mOpenHelper.getWritableDatabase(), this.getSyncingAccount());
        }
        return temp;
    }

    @Override
    public SQLiteDatabase getDatabase() {
        if (this.mDb == null) {
            this.mDb = this.mOpenHelper.getWritableDatabase();
        }
        return this.mDb;
    }

    @Override
    public boolean getContainsDiffs() {
        return this.mContainsDiffs;
    }

    @Override
    public void setContainsDiffs(boolean containsDiffs) {
        if (containsDiffs && !this.isTemporary()) {
            throw new IllegalStateException("only a temporary provider can contain diffs");
        }
        this.mContainsDiffs = containsDiffs;
    }

    @Override
    public Iterable<? extends AbstractTableMerger> getMergers() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(Uri url, ContentValues values, String selection, String[] selectionArgs) {
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransaction();
        try {
            if (this.isTemporary() && this.mSyncState.matches(url)) {
                int numRows = this.mSyncState.asContentProvider().update(url, values, selection, selectionArgs);
                this.mDb.setTransactionSuccessful();
                int n = numRows;
                return n;
            }
            int result = this.updateInternal(url, values, selection, selectionArgs);
            this.mDb.setTransactionSuccessful();
            if (!this.isTemporary() && result > 0) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            }
            int n = result;
            return n;
        }
        finally {
            this.mDb.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Uri url, String selection, String[] selectionArgs) {
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransaction();
        try {
            if (this.isTemporary() && this.mSyncState.matches(url)) {
                int numRows = this.mSyncState.asContentProvider().delete(url, selection, selectionArgs);
                this.mDb.setTransactionSuccessful();
                int n = numRows;
                return n;
            }
            int result = this.deleteInternal(url, selection, selectionArgs);
            this.mDb.setTransactionSuccessful();
            if (!this.isTemporary() && result > 0) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            }
            int n = result;
            return n;
        }
        finally {
            this.mDb.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri insert(Uri url, ContentValues values) {
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransaction();
        try {
            if (this.isTemporary() && this.mSyncState.matches(url)) {
                Uri result = this.mSyncState.asContentProvider().insert(url, values);
                this.mDb.setTransactionSuccessful();
                Uri uri = result;
                return uri;
            }
            Uri result = this.insertInternal(url, values);
            this.mDb.setTransactionSuccessful();
            if (!this.isTemporary() && result != null) {
                this.getContext().getContentResolver().notifyChange(url, null, this.changeRequiresLocalSync(url));
            }
            Uri uri = result;
            return uri;
        }
        finally {
            this.mDb.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bulkInsert(Uri uri, ContentValues[] values) {
        int size = values.length;
        int completed = 0;
        boolean isSyncStateUri = this.mSyncState.matches(uri);
        this.mDb = this.mOpenHelper.getWritableDatabase();
        this.mDb.beginTransaction();
        try {
            for (int i = 0; i < size; ++i) {
                Uri result;
                if (this.isTemporary() && isSyncStateUri) {
                    result = this.mSyncState.asContentProvider().insert(uri, values[i]);
                } else {
                    result = this.insertInternal(uri, values[i]);
                    this.mDb.yieldIfContended();
                }
                if (result == null) continue;
                ++completed;
            }
            this.mDb.setTransactionSuccessful();
        }
        finally {
            this.mDb.endTransaction();
        }
        if (!this.isTemporary() && completed == size) {
            this.getContext().getContentResolver().notifyChange(uri, null, this.changeRequiresLocalSync(uri));
        }
        return completed;
    }

    @Override
    public boolean changeRequiresLocalSync(Uri uri) {
        return true;
    }

    @Override
    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        this.mDb = this.mOpenHelper.getReadableDatabase();
        if (this.isTemporary() && this.mSyncState.matches(url)) {
            return this.mSyncState.asContentProvider().query(url, projection, selection, selectionArgs, sortOrder);
        }
        return this.queryInternal(url, projection, selection, selectionArgs, sortOrder);
    }

    @Override
    public void onSyncStart(SyncContext context, String account) {
        if (TextUtils.isEmpty(account)) {
            throw new IllegalArgumentException("you passed in an empty account");
        }
        this.mSyncingAccount = account;
    }

    @Override
    public void onSyncStop(SyncContext context, boolean success) {
    }

    @Override
    public String getSyncingAccount() {
        return this.mSyncingAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(SyncContext context, SyncableContentProvider diffs, TempProviderSyncResult result, SyncResult syncResult) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            AbstractSyncableContentProvider abstractSyncableContentProvider = this;
            synchronized (abstractSyncableContentProvider) {
                this.mIsMergeCancelled = false;
            }
            Iterable<? extends AbstractTableMerger> mergers = this.getMergers();
            try {
                for (AbstractTableMerger abstractTableMerger : mergers) {
                    AbstractSyncableContentProvider abstractSyncableContentProvider2 = this;
                    synchronized (abstractSyncableContentProvider2) {
                        if (this.mIsMergeCancelled) {
                            break;
                        }
                        this.mCurrentMerger = abstractTableMerger;
                    }
                    abstractTableMerger.merge(context, this.getSyncingAccount(), diffs, result, syncResult, this);
                }
                if (this.mIsMergeCancelled) {
                    return;
                }
                if (diffs != null) {
                    this.mSyncState.copySyncState(((AbstractSyncableContentProvider)diffs).mOpenHelper.getReadableDatabase(), this.mOpenHelper.getWritableDatabase(), this.getSyncingAccount());
                }
            }
            finally {
                AbstractSyncableContentProvider abstractSyncableContentProvider3 = this;
                synchronized (abstractSyncableContentProvider3) {
                    this.mCurrentMerger = null;
                }
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSyncCanceled() {
        AbstractSyncableContentProvider abstractSyncableContentProvider = this;
        synchronized (abstractSyncableContentProvider) {
            this.mIsMergeCancelled = true;
            if (this.mCurrentMerger != null) {
                this.mCurrentMerger.onMergeCancelled();
            }
        }
    }

    @Override
    public boolean isMergeCancelled() {
        return this.mIsMergeCancelled;
    }

    @Override
    public abstract int updateInternal(Uri var1, ContentValues var2, String var3, String[] var4);

    @Override
    public abstract int deleteInternal(Uri var1, String var2, String[] var3);

    @Override
    public abstract Uri insertInternal(Uri var1, ContentValues var2);

    @Override
    public abstract Cursor queryInternal(Uri var1, String[] var2, String var3, String[] var4, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAccountsChanged(String[] accountsArray) {
        HashMap<String, Boolean> accounts = new HashMap<String, Boolean>();
        for (String account : accountsArray) {
            accounts.put(account, false);
        }
        accounts.put("non_syncable", false);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Map<String, String> tableMap = db.getSyncedTables();
        Vector<String> tables = new Vector<String>();
        tables.addAll(tableMap.keySet());
        tables.addAll(tableMap.values());
        db.beginTransaction();
        try {
            this.mSyncState.onAccountsChanged(accountsArray);
            for (String table : tables) {
                this.deleteRowsForRemovedAccounts(accounts, table, "_sync_account");
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRowsForRemovedAccounts(Map<String, Boolean> accounts, String table, String accountColumnName) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Cursor c = db.query(table, sAccountProjection, null, null, accountColumnName, null, null);
        try {
            while (c.moveToNext()) {
                String account = c.getString(0);
                if (TextUtils.isEmpty(account) || accounts.containsKey(account)) continue;
                int numDeleted = db.delete(table, accountColumnName + "=?", new String[]{account});
            }
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeAccount(String account) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Map<String, String> tableMap = db.getSyncedTables();
        ArrayList<String> tables = new ArrayList<String>();
        tables.addAll(tableMap.keySet());
        tables.addAll(tableMap.values());
        db.beginTransaction();
        try {
            this.mSyncState.discardSyncData(db, account);
            for (String table : tables) {
                db.delete(table, SYNC_ACCOUNT_WHERE_CLAUSE, new String[]{account});
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    @Override
    public byte[] readSyncDataBytes(String account) {
        return this.mSyncState.readSyncDataBytes(this.mOpenHelper.getReadableDatabase(), account);
    }

    @Override
    public void writeSyncDataBytes(String account, byte[] data) {
        this.mSyncState.writeSyncDataBytes(this.mOpenHelper.getWritableDatabase(), account, data);
    }

    public class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context, String name) {
            super(context, name, null, AbstractSyncableContentProvider.this.mDatabaseVersion);
        }

        public void onCreate(SQLiteDatabase db) {
            AbstractSyncableContentProvider.this.bootstrapDatabase(db);
            AbstractSyncableContentProvider.this.mSyncState.createDatabase(db);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (!AbstractSyncableContentProvider.this.upgradeDatabase(db, oldVersion, newVersion)) {
                AbstractSyncableContentProvider.this.mSyncState.discardSyncData(db, null);
                AbstractSyncableContentProvider.this.getContext().getContentResolver().startSync(AbstractSyncableContentProvider.this.mContentUri, new Bundle());
            }
        }

        public void onOpen(SQLiteDatabase db) {
            AbstractSyncableContentProvider.this.onDatabaseOpened(db);
            AbstractSyncableContentProvider.this.mSyncState.onDatabaseOpened(db);
        }
    }
}

