/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.IBluetoothDevice;
import android.bluetooth.IBluetoothDeviceCallback;
import android.os.RemoteException;
import android.util.Log;
import java.io.UnsupportedEncodingException;

public class BluetoothDevice {
    public static final int BLUETOOTH_STATE_OFF = 0;
    public static final int BLUETOOTH_STATE_TURNING_ON = 1;
    public static final int BLUETOOTH_STATE_ON = 2;
    public static final int BLUETOOTH_STATE_TURNING_OFF = 3;
    public static final int SCAN_MODE_NONE = 0;
    public static final int SCAN_MODE_CONNECTABLE = 1;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 3;
    public static final int RESULT_FAILURE = -1;
    public static final int RESULT_SUCCESS = 0;
    public static final int BOND_NOT_BONDED = 0;
    public static final int BOND_BONDED = 1;
    public static final int BOND_BONDING = 2;
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    public static final int UNBOND_REASON_REMOVED = 6;
    public static final String TAG = "BluetoothDevice";
    public final IBluetoothDevice mService;
    public static final int ADDRESS_LENGTH = 17;

    public BluetoothDevice(IBluetoothDevice service) {
        this.mService = service;
    }

    public boolean isEnabled() {
        try {
            return this.mService.isEnabled();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public int getBluetoothState() {
        try {
            return this.mService.getBluetoothState();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1000;
        }
    }

    public boolean enable() {
        try {
            return this.mService.enable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disable() {
        try {
            return this.mService.disable(true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String getAddress() {
        try {
            return this.mService.getAddress();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getName() {
        try {
            return this.mService.getName();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public boolean setName(String name) {
        try {
            return this.mService.setName(name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String getVersion() {
        try {
            return this.mService.getVersion();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getRevision() {
        try {
            return this.mService.getRevision();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getManufacturer() {
        try {
            return this.mService.getManufacturer();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getCompany() {
        try {
            return this.mService.getCompany();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public int getScanMode() {
        try {
            return this.mService.getScanMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1012;
        }
    }

    public void setScanMode(int scanMode) {
        try {
            this.mService.setScanMode(scanMode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public int getDiscoverableTimeout() {
        try {
            return this.mService.getDiscoverableTimeout();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1;
        }
    }

    public void setDiscoverableTimeout(int timeout) {
        try {
            this.mService.setDiscoverableTimeout(timeout);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public boolean startDiscovery() {
        return this.startDiscovery(true);
    }

    public boolean startDiscovery(boolean resolveNames) {
        try {
            return this.mService.startDiscovery(resolveNames);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public void cancelDiscovery() {
        try {
            this.mService.cancelDiscovery();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    public boolean isDiscovering() {
        try {
            return this.mService.isDiscovering();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean startPeriodicDiscovery() {
        try {
            return this.mService.startPeriodicDiscovery();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean stopPeriodicDiscovery() {
        try {
            return this.mService.stopPeriodicDiscovery();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean isPeriodicDiscovery() {
        try {
            return this.mService.isPeriodicDiscovery();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String[] listRemoteDevices() {
        try {
            return this.mService.listRemoteDevices();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String[] listAclConnections() {
        try {
            return this.mService.listAclConnections();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public boolean isAclConnected(String address) {
        try {
            return this.mService.isAclConnected(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disconnectRemoteDeviceAcl(String address) {
        try {
            return this.mService.disconnectRemoteDeviceAcl(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean createBond(String address) {
        try {
            return this.mService.createBond(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean cancelBondProcess(String address) {
        try {
            return this.mService.cancelBondProcess(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean removeBond(String address) {
        try {
            return this.mService.removeBond(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String[] listBonds() {
        try {
            return this.mService.listBonds();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public int getBondState(String address) {
        try {
            return this.mService.getBondState(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1012;
        }
    }

    public String getRemoteName(String address) {
        try {
            return this.mService.getRemoteName(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getRemoteVersion(String address) {
        try {
            return this.mService.getRemoteVersion(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getRemoteRevision(String address) {
        try {
            return this.mService.getRemoteRevision(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getRemoteManufacturer(String address) {
        try {
            return this.mService.getRemoteManufacturer(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String getRemoteCompany(String address) {
        try {
            return this.mService.getRemoteCompany(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public boolean getRemoteServiceChannel(String address, short uuid16, IBluetoothDeviceCallback callback) {
        try {
            return this.mService.getRemoteServiceChannel(address, uuid16, callback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public int getRemoteClass(String address) {
        try {
            return this.mService.getRemoteClass(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -16777216;
        }
    }

    public byte[] getRemoteFeatures(String address) {
        try {
            return this.mService.getRemoteFeatures(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String lastSeen(String address) {
        try {
            return this.mService.lastSeen(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public String lastUsed(String address) {
        try {
            return this.mService.lastUsed(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public boolean setPin(String address, byte[] pin) {
        try {
            return this.mService.setPin(address, pin);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean cancelPin(String address) {
        try {
            return this.mService.cancelPin(address);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public static byte[] convertPinToBytes(String pin) {
        byte[] pinBytes;
        if (pin == null) {
            return null;
        }
        try {
            pinBytes = pin.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e(TAG, "UTF8 not supported?!?");
            return null;
        }
        if (pinBytes.length <= 0 || pinBytes.length > 16) {
            return null;
        }
        return pinBytes;
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (Character.digit(c, 16) != -1) continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

