/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExcludingLookup
extends Lookup {
    private Lookup delegate;
    private Object classes;

    ExcludingLookup(Lookup lookup, Class[] classArray) {
        this.delegate = lookup;
        this.classes = classArray.length == 1 ? classArray[0] : classArray;
    }

    public String toString() {
        return "ExcludingLookup: " + this.delegate + " excludes: " + Arrays.asList(this.classes());
    }

    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (template == null) {
            throw new NullPointerException();
        }
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return Lookup.EMPTY.lookup(template);
        }
        return new R<T>(template.getType(), this.delegate.lookup(template));
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(clazz)) {
            return null;
        }
        T t = this.delegate.lookup(clazz);
        if (this.isObjectAccessible(clazz, t, 0)) {
            return t;
        }
        return null;
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return null;
        }
        Lookup.Item<T> item = this.delegate.lookupItem(template);
        if (this.isObjectAccessible(template.getType(), item, 2)) {
            return item;
        }
        return null;
    }

    private boolean areSubclassesOfThisClassAlwaysExcluded(Class<?> clazz) {
        Class<?>[] classArray = this.classes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    final Class<?>[] classes() {
        if (this.classes instanceof Class[]) {
            return (Class[])this.classes;
        }
        return new Class[]{(Class)this.classes};
    }

    private static boolean isAccessible(Class<?>[] classArray, Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (clazz2 != classArray[i]) continue;
            return false;
        }
        if (clazz == clazz2) {
            return true;
        }
        if (ExcludingLookup.isAccessible(classArray, clazz, clazz2.getSuperclass())) {
            return true;
        }
        Class<?>[] classArray2 = clazz2.getInterfaces();
        for (int i = 0; i < classArray2.length; ++i) {
            if (!ExcludingLookup.isAccessible(classArray, clazz, classArray2[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean isObjectAccessible(Class clazz, Object object, int n) {
        if (object == null) {
            return false;
        }
        return ExcludingLookup.isObjectAccessible(this.classes(), clazz, object, n);
    }

    static final boolean isObjectAccessible(Class[] classArray, Class clazz, Object object, int n) {
        if (object == null) {
            return false;
        }
        switch (n) {
            case 0: {
                return ExcludingLookup.isAccessible(classArray, clazz, object.getClass());
            }
            case 1: {
                return ExcludingLookup.isAccessible(classArray, clazz, (Class)object);
            }
            case 2: {
                Lookup.Item item = (Lookup.Item)object;
                return ExcludingLookup.isAccessible(classArray, clazz, item.getType());
            }
        }
        throw new IllegalStateException("Type: " + n);
    }

    final <E, T extends Collection<E>> T filter(Class<?>[] classArray, Class<?> clazz, T t, int n, T t2) {
        Collection collection = null;
        while (true) {
            for (E e : t) {
                if (!ExcludingLookup.isObjectAccessible(classArray, clazz, e, n)) {
                    if (collection != null) continue;
                    collection = t2;
                    continue;
                }
                if (collection == null) continue;
                collection.add(e);
            }
            break;
        }
        return (T)(collection != null ? collection : (Collection)t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result source;
        private Reference<R<T>> result;

        public WeakResult(R<T> r, Lookup.Result<T> result) {
            this.result = new WeakReference<R<R<T>>>(r);
            this.source = result;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            R<T> r = this.result.get();
            if (r != null) {
                r.beforeLookup(template);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            R<T> r = this.result.get();
            if (r != null) {
                r.collectFires(collection);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            R<T> r = this.result.get();
            if (r != null) {
                r.resultChanged(lookupEvent);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class R<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result<T> result;
        private WeakResult<T> weak;
        private Object listeners;
        private Class<?> from;

        R(Class<?> clazz, Lookup.Result<T> result) {
            this.from = clazz;
            this.result = result;
            this.weak = new WeakResult<T>(this, result);
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            if (this.result instanceof WaitableResult) {
                ((WaitableResult)this.result).beforeLookup(template);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener lookupListener) {
            boolean bl;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(true, lookupListener, this.listeners);
                bl = this.listeners != null;
            }
            if (bl) {
                this.result.addLookupListener(this.weak);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            boolean bl;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(false, lookupListener, this.listeners);
                bl = this.listeners == null;
            }
            if (bl) {
                this.result.removeLookupListener(this.weak);
            }
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.openCol(this.result.allInstances(), 0);
        }

        private <S> Collection<S> openCol(Collection<S> collection, int n) {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, collection, n, new ArrayList(collection.size()));
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allClasses(), 1, new HashSet());
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.openCol(this.result.allItems(), 2);
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            if (lookupEvent.getSource() == this.result) {
                this.collectFires(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> collection) {
            Object[] objectArray = this;
            synchronized (this) {
                Serializable serializable;
                Object[] objectArray2;
                if (this.listeners == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    objectArray2 = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    serializable = (ArrayList)this.listeners;
                    objectArray2 = serializable.toArray(new LookupListener[serializable.size()]);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                objectArray = objectArray2;
                serializable = new LookupEvent((Lookup.Result)this);
                AbstractLookup.notifyListeners(objectArray, (LookupEvent)serializable, collection);
                return;
            }
        }
    }
}

