/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.TimeLineView;
import java.util.ArrayList;
import java.util.HashMap;

class ThreadData
implements TimeLineView.Row {
    private int mId;
    private String mName;
    private long mGlobalStartTime = -1L;
    private long mGlobalEndTime = -1L;
    private long mLastEventTime;
    private long mCpuTime;
    private Call mRoot;
    private Call mCurrent;
    private Call mLastContextSwitch;
    private ArrayList<Call> mStack = new ArrayList();
    private HashMap<MethodData, Integer> mStackMethods = new HashMap();
    private boolean mIsEmpty;

    ThreadData(int id, String name, MethodData topLevel) {
        this.mId = id;
        this.mName = String.format("[%d] %s", id, name);
        this.mCurrent = this.mRoot = new Call(this.mName, topLevel);
        this.mIsEmpty = true;
    }

    public boolean isEmpty() {
        return this.mIsEmpty;
    }

    public String getName() {
        return this.mName;
    }

    public Call getCalltreeRoot() {
        return this.mRoot;
    }

    void handleCall(Call call, long globalTime) {
        this.mIsEmpty = false;
        long currentTime = call.mThreadStartTime;
        if (currentTime < this.mLastEventTime) {
            System.err.printf("ThreadData: '%1$s' call time (%2$d) is less than previous time (%3$d) for thread '%4$s'\n", call.getName(), currentTime, this.mLastEventTime, this.mName);
            System.exit(1);
        }
        long elapsed = currentTime - this.mLastEventTime;
        this.mCpuTime += elapsed;
        if (call.getMethodAction() == 0) {
            this.enter(call, elapsed);
        } else {
            this.exit(call, elapsed, globalTime);
        }
        this.mLastEventTime = currentTime;
        this.mGlobalEndTime = globalTime;
    }

    private void enter(Call c, long elapsed) {
        Call caller = this.mCurrent;
        this.push(c);
        MethodData md = c.mMethodData;
        Integer num = this.mStackMethods.get(md);
        if (num == null) {
            num = 0;
        } else if (num > 0) {
            c.setRecursive(true);
        }
        num = num + 1;
        this.mStackMethods.put(md, num);
        this.mCurrent = c;
        caller.addExclusiveTime(elapsed);
    }

    private void exit(Call c, long elapsed, long globalTime) {
        this.mCurrent.mGlobalEndTime = globalTime;
        Call top = this.pop();
        if (top == null) {
            return;
        }
        if (this.mCurrent.mMethodData != c.mMethodData) {
            String error = "Method exit (" + c.getName() + ") does not match current method (" + this.mCurrent.getName() + ")";
            throw new RuntimeException(error);
        }
        long duration = c.mThreadStartTime - this.mCurrent.mThreadStartTime;
        Call caller = this.top();
        this.mCurrent.addExclusiveTime(elapsed);
        this.mCurrent.addInclusiveTime(duration, caller);
        if (caller == null) {
            caller = this.mRoot;
        }
        this.mCurrent = caller;
    }

    public void push(Call c) {
        this.mStack.add(c);
    }

    public Call pop() {
        ArrayList<Call> stack = this.mStack;
        if (stack.size() == 0) {
            return null;
        }
        Call top = stack.get(stack.size() - 1);
        stack.remove(stack.size() - 1);
        MethodData md = top.mMethodData;
        Integer num = this.mStackMethods.get(md);
        if (num != null) {
            if ((num = Integer.valueOf(num - 1)) <= 0) {
                this.mStackMethods.remove(md);
            } else {
                this.mStackMethods.put(md, num);
            }
        }
        return top;
    }

    public Call top() {
        ArrayList<Call> stack = this.mStack;
        if (stack.size() == 0) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    public long endTrace() {
        while (this.mCurrent != this.mRoot) {
            long duration = this.mLastEventTime - this.mCurrent.mThreadStartTime;
            this.pop();
            Call caller = this.top();
            this.mCurrent.addInclusiveTime(duration, caller);
            this.mCurrent.mGlobalEndTime = this.mGlobalEndTime;
            if (caller == null) {
                caller = this.mRoot;
            }
            this.mCurrent = caller;
        }
        return this.mLastEventTime;
    }

    public String toString() {
        return this.mName;
    }

    public int getId() {
        return this.mId;
    }

    public void setCpuTime(long cpuTime) {
        this.mCpuTime = cpuTime;
    }

    public long getCpuTime() {
        return this.mCpuTime;
    }

    public void setGlobalStartTime(long globalStartTime) {
        this.mGlobalStartTime = globalStartTime;
    }

    public long getGlobalStartTime() {
        return this.mGlobalStartTime;
    }

    public void setLastEventTime(long lastEventTime) {
        this.mLastEventTime = lastEventTime;
    }

    public long getLastEventTime() {
        return this.mLastEventTime;
    }

    public void setGlobalEndTime(long globalEndTime) {
        this.mGlobalEndTime = globalEndTime;
    }

    public long getGlobalEndTime() {
        return this.mGlobalEndTime;
    }

    public void setLastContextSwitch(Call lastContextSwitch) {
        this.mLastContextSwitch = lastContextSwitch;
    }

    public Call getLastContextSwitch() {
        return this.mLastContextSwitch;
    }
}

