/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.InstrumentationResultParser;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class RemoteAndroidTestRunner {
    private final String mPackageName;
    private final String mRunnerName;
    private IDevice mRemoteDevice;
    private Map<String, String> mArgMap;
    private InstrumentationResultParser mParser;
    private static final String LOG_TAG = "RemoteAndroidTest";
    private static final String DEFAULT_RUNNER_NAME = "android.test.InstrumentationTestRunner";
    private static final char CLASS_SEPARATOR = ',';
    private static final char METHOD_SEPARATOR = '#';
    private static final char RUNNER_SEPARATOR = '/';
    private static final String CLASS_ARG_NAME = "class";
    private static final String LOG_ARG_NAME = "log";
    private static final String DEBUG_ARG_NAME = "debug";
    private static final String COVERAGE_ARG_NAME = "coverage";
    private static final String PACKAGE_ARG_NAME = "package";

    public RemoteAndroidTestRunner(String packageName, String runnerName, IDevice remoteDevice) {
        this.mPackageName = packageName;
        this.mRunnerName = runnerName;
        this.mRemoteDevice = remoteDevice;
        this.mArgMap = new Hashtable<String, String>();
    }

    public RemoteAndroidTestRunner(String packageName, IDevice remoteDevice) {
        this(packageName, null, remoteDevice);
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getRunnerName() {
        if (this.mRunnerName == null) {
            return DEFAULT_RUNNER_NAME;
        }
        return this.mRunnerName;
    }

    private String getRunnerPath() {
        return this.getPackageName() + '/' + this.getRunnerName();
    }

    public void setClassName(String className) {
        this.addInstrumentationArg(CLASS_ARG_NAME, className);
    }

    public void setClassNames(String[] classNames) {
        StringBuilder classArgBuilder = new StringBuilder();
        for (int i = 0; i < classNames.length; ++i) {
            if (i != 0) {
                classArgBuilder.append(',');
            }
            classArgBuilder.append(classNames[i]);
        }
        this.setClassName(classArgBuilder.toString());
    }

    public void setMethodName(String className, String testName) {
        this.setClassName(className + '#' + testName);
    }

    public void setTestPackageName(String packageName) {
        this.addInstrumentationArg(PACKAGE_ARG_NAME, packageName);
    }

    public void addInstrumentationArg(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name or value arguments cannot be null");
        }
        this.mArgMap.put(name, value);
    }

    public void addBooleanArg(String name, boolean value) {
        this.addInstrumentationArg(name, Boolean.toString(value));
    }

    public void setLogOnly(boolean logOnly) {
        this.addBooleanArg(LOG_ARG_NAME, logOnly);
    }

    public void setDebug(boolean debug) {
        this.addBooleanArg(DEBUG_ARG_NAME, debug);
    }

    public void setCoverage(boolean coverage) {
        this.addBooleanArg(COVERAGE_ARG_NAME, coverage);
    }

    public void run(ITestRunListener listener) {
        String runCaseCommandStr = String.format("am instrument -w -r %s %s", this.getArgsCommand(), this.getRunnerPath());
        Log.d(LOG_TAG, runCaseCommandStr);
        this.mParser = new InstrumentationResultParser(listener);
        try {
            this.mRemoteDevice.executeShellCommand(runCaseCommandStr, this.mParser);
        }
        catch (IOException e) {
            Log.e(LOG_TAG, e);
            listener.testRunFailed(e.toString());
        }
    }

    public void cancel() {
        if (this.mParser != null) {
            this.mParser.cancel();
        }
    }

    private String getArgsCommand() {
        StringBuilder commandBuilder = new StringBuilder();
        for (Map.Entry<String, String> argPair : this.mArgMap.entrySet()) {
            String argCmd = String.format(" -e %s %s", argPair.getKey(), argPair.getValue());
            commandBuilder.append(argCmd);
        }
        return commandBuilder.toString();
    }
}

