/*
 * Decompiled with CFR 0.152.
 */
package com.google.map;

public final class Zoom {
    private final int equatorPixels;
    private final int zoomLevel;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 22;
    private static final int MAX_DOUBLEZOOM_LEVEL = 7;
    private static final Zoom[] zoomArray = new Zoom[22];
    private static final int EARTH_CIRCUMFERENCE_METERS = 40076000;

    private Zoom(int n, int n2) {
        this.zoomLevel = n;
        this.equatorPixels = n2;
    }

    public int getPixelsForDistance(int n) {
        return Math.max((int)((long)n * (long)this.equatorPixels / 40076000L), 1);
    }

    public int getMetersPerPixel() {
        return Math.max(40076000 / this.equatorPixels, 1);
    }

    public static Zoom getZoom(int n) {
        Zoom zoom = null;
        if (n >= 1 && n <= 22) {
            zoom = zoomArray[n - 1];
        }
        return zoom;
    }

    public int getZoomRatio(Zoom zoom) {
        return zoom.equatorPixels / this.equatorPixels;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public int getEquatorPixels() {
        return this.equatorPixels;
    }

    public boolean isMoreZoomedIn(Zoom zoom) {
        return this.zoomLevel > zoom.zoomLevel;
    }

    public Zoom getNextHigherZoom() {
        if (this.zoomLevel < 7) {
            return Zoom.getZoom(this.zoomLevel + 2);
        }
        return Zoom.getZoom(this.zoomLevel + 1);
    }

    public int changePixelsToTargetZoomlevel(int n, int n2) {
        if (this.zoomLevel < n2) {
            return n << n2 - this.zoomLevel;
        }
        return n >> this.zoomLevel - n2;
    }

    public Zoom getNextLowerZoom() {
        if (this.zoomLevel <= 7) {
            return Zoom.getZoom(this.zoomLevel - 2);
        }
        return Zoom.getZoom(this.zoomLevel - 1);
    }

    public String toString() {
        return super.toString();
    }

    static {
        int n = 256;
        for (int i = 1; i <= 22; ++i) {
            Zoom.zoomArray[i - 1] = new Zoom(i, n);
            n *= 2;
        }
    }
}

