/*
 * Decompiled with CFR 0.152.
 */
package com.google.map;

import com.google.common.io.protocol.ProtoBuf;
import com.google.common.util.MathUtil;
import com.google.common.util.text.TextUtil;
import com.google.googlenav.proto.GmmMessageTypes;
import com.google.map.Geometry;
import com.google.map.Zoom;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public class MapPoint
implements Geometry {
    private final int pixelCoordX;
    private final int pixelCoordY;
    private final int latitudeE6;
    private final int longitudeE6;
    public static final int E6 = 1000000;
    private static final int E7 = 10000000;
    private static final int E6_360 = 360000000;
    private static final int E9 = 1000000000;
    private static final int MAX_DIF = 5000000;
    private static final int PIXEL_COORDS_ZOOM_LEVEL = 22;
    private static final Zoom PIXEL_COORDS_ZOOM;
    private static final int MAX_LATITUDE = 80000000;
    static int[] mercatorValues;
    static int[] reverseMercatorValues;
    private static final char DELIMITER = ',';
    private static final char DECIMAL = '.';

    private static int adjustLongitude(int n) {
        while (n < -180000000) {
            n += 360000000;
        }
        while (n > 180000000) {
            n -= 360000000;
        }
        return n;
    }

    private static int adjustPixelX(int n, int n2) {
        while (n >= n2) {
            n -= n2;
        }
        while (n < 0) {
            n += n2;
        }
        return n;
    }

    private static int adjustPixelY(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        if (n >= n2) {
            return n2 - 1;
        }
        return n;
    }

    public MapPoint(int n, int n2) {
        n2 = MapPoint.adjustLongitude(n2);
        if (n > 80000000) {
            n = 80000000;
        }
        if (n < -80000000) {
            n = -80000000;
        }
        this.latitudeE6 = n;
        this.longitudeE6 = n2;
        this.pixelCoordX = MapPoint.getXPixelFromLon(n2, PIXEL_COORDS_ZOOM);
        this.pixelCoordY = MapPoint.getYPixelFromLat(n, PIXEL_COORDS_ZOOM);
    }

    public MapPoint(int n, int n2, int n3) {
        Zoom zoom = Zoom.getZoom(n3);
        n = MapPoint.adjustPixelX(n, zoom.getEquatorPixels());
        n2 = MapPoint.adjustPixelY(n2, zoom.getEquatorPixels());
        this.pixelCoordX = zoom.changePixelsToTargetZoomlevel(n, 22);
        this.pixelCoordY = zoom.changePixelsToTargetZoomlevel(n2, 22);
        this.latitudeE6 = MapPoint.getLatitudeFromY(this.pixelCoordY, PIXEL_COORDS_ZOOM);
        this.longitudeE6 = MapPoint.getLongitudeFromX(this.pixelCoordX, PIXEL_COORDS_ZOOM);
    }

    public MapPoint(int n, int n2, int n3, int n4, int n5) {
        n5 = MapPoint.adjustLongitude(n5);
        this.latitudeE6 = n4;
        this.longitudeE6 = n5;
        Zoom zoom = Zoom.getZoom(n3);
        n = MapPoint.adjustPixelX(n, zoom.getEquatorPixels());
        n2 = MapPoint.adjustPixelY(n2, zoom.getEquatorPixels());
        this.pixelCoordX = zoom.changePixelsToTargetZoomlevel(n, 22);
        this.pixelCoordY = zoom.changePixelsToTargetZoomlevel(n2, 22);
    }

    public int getType() {
        return 1;
    }

    public int getXPixel(Zoom zoom) {
        return PIXEL_COORDS_ZOOM.changePixelsToTargetZoomlevel(this.pixelCoordX, zoom.getZoomLevel());
    }

    public static int getXPixelFromLon(int n, Zoom zoom) {
        return (int)((long)zoom.getEquatorPixels() / 2L + (long)n * (long)zoom.getEquatorPixels() / 360000000L);
    }

    private static int[] getMercatorValues() {
        if (mercatorValues == null) {
            mercatorValues = new int[84];
            try {
                byte[] byArray = new byte[]{-1, -16, -67, -115, 15, 66, 115, 15, 66, 115, 15, 67, -93, 15, 70, 6, 15, 73, -103, 15, 78, 97, 15, 84, 94, 15, 91, -109, 15, 100, 2, 15, 109, -80, 15, 120, -97, 15, -124, -44, 15, -110, 84, 15, -95, 38, 15, -79, 78, 15, -62, -45, 15, -43, -67, 15, -22, 21, 15, -1, -31, 16, 23, 45, 16, 48, 1, 16, 74, 107, 16, 102, 116, 16, -124, 43, 16, -93, -100, 16, -60, -41, 16, -25, -19, 17, 12, -18, 17, 51, -20, 17, 92, -4, 17, -120, 52, 17, -75, -87, 17, -27, 118, 18, 23, -76, 18, 76, -127, 18, -125, -3, 18, -66, 70, 18, -5, -124, 19, 59, -37, 19, 127, 119, 19, -58, -122, 20, 17, 56, 20, 95, -60, 20, -78, 100, 21, 9, 87, 21, 100, -27, 21, -59, 86, 22, 42, -1, 22, -106, 58, 23, 7, 109, 23, 127, 2, 23, -3, 117, 24, -125, 72, 25, 17, 20, 25, -89, 120, 26, 71, 46, 26, -15, 3, 27, -91, -39, 28, 102, -77, 29, 52, -77, 30, 17, 31, 30, -3, 111, 31, -5, 74, 33, 12, -105, 34, 51, -120, 35, 114, -91, 36, -52, -30, 38, 69, -76, 39, -31, 42, 41, -92, 25, 43, -108, 70, 45, -72, -91, 48, 25, -84, 50, -63, -63, 53, -67, -47, 57, 30, 28, 60, -9, 105, 65, 100, -96, 70, -119, 82, 76, -107, 115, 83, -53, 79, 92, -119, 52, 103, 90, 12};
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                MapPoint.readMercatorValues(byteArrayInputStream, mercatorValues);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't read mercator.dat");
            }
        }
        return mercatorValues;
    }

    public static int getYPixelFromLat(int n, Zoom zoom) {
        int n2 = MapPoint.getMercatorIndex(n);
        int n3 = Math.abs(n) % 1000000;
        int[] nArray = MapPoint.getMercatorValues();
        int n4 = (-1 * nArray[n2 - 1] + 3 * nArray[n2] - 3 * nArray[n2 + 1] + nArray[n2 + 2]) / 6;
        int n5 = (3 * nArray[n2 - 1] - 6 * nArray[n2] + 3 * nArray[n2 + 1]) / 6;
        int n6 = (-2 * nArray[n2 - 1] - 3 * nArray[n2] + 6 * nArray[n2 + 1] - nArray[n2 + 2]) / 6;
        int n7 = nArray[n2];
        int n8 = (int)((long)n4 * (long)n3 * (long)n3 / 1000000L * (long)n3 / 1000000L / 1000000L + (long)n5 * (long)n3 * (long)n3 / 1000000L / 1000000L + (long)n6 * (long)n3 / 1000000L + (long)n7);
        if (n < 0) {
            n8 = -n8;
        }
        int n9 = (int)((long)zoom.getEquatorPixels() / 2L - (long)(MapPoint.mercatorToPixelsTimesTen(n8, zoom) / 10));
        return n9;
    }

    public int getYPixel(Zoom zoom) {
        return PIXEL_COORDS_ZOOM.changePixelsToTargetZoomlevel(this.pixelCoordY, zoom.getZoomLevel());
    }

    private static int[] getReverseMercatorValues() {
        if (reverseMercatorValues == null) {
            reverseMercatorValues = new int[141];
            try {
                byte[] byArray = new byte[]{-1, -28, -119, -24, 27, 118, 24, 27, 118, 24, 27, 111, 42, 27, 97, 85, 27, 76, -82, 27, 49, 75, 27, 15, 79, 26, -26, -26, 26, -72, 61, 26, -125, -114, 26, 73, 22, 26, 9, 25, 25, -61, -35, 25, 121, -81, 25, 42, -34, 24, -41, -70, 24, -128, -103, 24, 37, -51, 23, -57, -82, 23, 102, -115, 23, 2, -64, 22, -100, -101, 22, 52, 109, 21, -54, -122, 21, 95, 48, 20, -14, -72, 20, -123, 97, 20, 23, 111, 19, -87, 33, 19, 58, -76, 18, -52, 94, 18, 94, 85, 17, -16, -56, 17, -125, -26, 17, 23, -42, 16, -84, -64, 16, 66, -61, 15, -38, 2, 15, 114, -106, 15, 12, -103, 14, -88, 32, 14, 69, 64, 13, -28, 7, 13, -124, -122, 13, 38, -58, 12, -54, -45, 12, 112, -75, 12, 24, 113, 11, -62, 10, 11, 109, -121, 11, 26, -27, 10, -54, 40, 10, 123, 77, 10, 46, 82, 9, -29, 52, 9, -103, -16, 9, 82, -126, 9, 12, -29, 8, -55, 14, 8, -122, -2, 8, 70, -86, 8, 8, 13, 7, -53, 30, 7, -113, -41, 7, 86, 45, 7, 30, 27, 6, -25, -104, 6, -78, -102, 6, 127, 26, 6, 77, 15, 6, 28, 114, 5, -19, 56, 5, -65, 89, 5, -110, -50, 5, 103, -114, 5, 61, -111, 5, 20, -51, 4, -19, 59, 4, -58, -43, 4, -95, -113, 4, 125, 102, 4, 90, 78, 4, 56, 65, 4, 23, 58, 3, -9, 47, 3, -40, 26, 3, -71, -13, 3, -100, -75, 3, -128, 88, 3, 100, -41, 3, 74, 43, 3, 48, 76, 3, 23, 55, 2, -2, -28, 2, -25, 79, 2, -48, 114, 2, -70, 70, 2, -92, -56, 2, -113, -15, 2, 123, -67, 2, 104, 40, 2, 85, 43, 2, 66, -61, 2, 48, -20, 2, 31, -96, 2, 14, -35, 1, -2, -100, 1, -18, -36, 1, -33, -106, 1, -48, -53, 1, -62, 114, 1, -76, -118, 1, -89, 17, 1, -102, 1, 1, -115, 88, 1, -127, 18, 1, 117, 47, 1, 105, -89, 1, 94, 124, 1, 83, -88, 1, 73, 42, 1, 62, -1, 1, 53, 35, 1, 43, -105, 1, 34, 84, 1, 25, 91, 1, 16, -86, 1, 8, 60, 1, 0, 17, 0, -8, 40, 0, -16, 124, 0, -23, 13, 0, -31, -40, 0, -38, -34, 0, -44, 25, 0, -51, -117, 0, -57, 48, 0, -63, 8, 0, -69, 16, 0, -75, 71};
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                MapPoint.readMercatorValues(byteArrayInputStream, reverseMercatorValues);
            }
            catch (IOException iOException) {
                throw new RuntimeException("rmercator.dat is incorrect");
            }
        }
        return reverseMercatorValues;
    }

    public int getLatitude() {
        return this.latitudeE6;
    }

    public int getLatitudeE7() {
        return this.latitudeE6 * 10;
    }

    private static int getLatitudeFromY(int n, Zoom zoom) {
        int n2;
        int n3;
        int n4;
        int[] nArray = MapPoint.getReverseMercatorValues();
        int n5 = MapPoint.pixelsToMercator(zoom.getEquatorPixels() / 2 - n, zoom);
        int n6 = Math.abs(n5) / 5000000 + 1;
        if (n6 >= nArray.length - 2) {
            return n5 > 0 ? 80000000 : -80000000;
        }
        int n7 = (-1 * nArray[n6 - 1] + 3 * nArray[n6] - 3 * nArray[n6 + 1] + nArray[n6 + 2]) / 6;
        int n8 = Math.abs(n5) % 5000000;
        int n9 = (int)((long)n7 * (long)n8 * (long)n8 / 5000000L * (long)n8 / 5000000L / 5000000L + (long)(n4 = (3 * nArray[n6 - 1] - 6 * nArray[n6] + 3 * nArray[n6 + 1]) / 6) * (long)n8 * (long)n8 / 5000000L / 5000000L + (long)(n3 = (-2 * nArray[n6 - 1] - 3 * nArray[n6] + 6 * nArray[n6 + 1] - nArray[n6 + 2]) / 6) * (long)n8 / 5000000L + (long)(n2 = nArray[n6]));
        if (n9 > 80000000) {
            n9 = 80000000;
        }
        if (n5 < 0) {
            n9 = -n9;
        }
        return n9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMercatorValues(InputStream inputStream, int[] nArray) throws IOException {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            nArray[0] = dataInputStream.readInt();
            for (int i = 1; i < nArray.length; ++i) {
                nArray[i] = nArray[i - 1] + (dataInputStream.readUnsignedByte() << 16 | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte());
            }
        }
        finally {
            inputStream.close();
        }
    }

    public int getLongitude() {
        return this.longitudeE6;
    }

    public int getLongitudeE7() {
        return this.longitudeE6 * 10;
    }

    private static int getLongitudeFromX(int n, Zoom zoom) {
        return (int)((long)(n - zoom.getEquatorPixels() / 2) * 360000000L / (long)zoom.getEquatorPixels());
    }

    public String toString() {
        return MapPoint.latLonToString(this.latitudeE6, this.longitudeE6);
    }

    public ProtoBuf toMapPointProto() {
        ProtoBuf protoBuf = new ProtoBuf(GmmMessageTypes.MAP_POINT_PROTO);
        protoBuf.setInt(1, this.latitudeE6);
        protoBuf.setInt(2, this.longitudeE6);
        return protoBuf;
    }

    public static String latLonToString(int n, int n2) {
        return TextUtil.e6ToString((int)n) + ',' + TextUtil.e6ToString((int)n2);
    }

    public static MapPoint fromString(String string) {
        int n = string.indexOf(44);
        if (n != -1) {
            try {
                String[] stringArray = TextUtil.split((String)string, (char)',');
                int n2 = MapPoint.stringToLatLonE6(stringArray[0]);
                int n3 = MapPoint.stringToLatLonE6(stringArray[1]);
                return new MapPoint(n2, n3);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static MapPoint fromProto(ProtoBuf protoBuf) {
        int n = protoBuf.getInt(1);
        int n2 = protoBuf.getInt(2);
        return new MapPoint(n, n2);
    }

    public static int stringToLatLonE6(String string) throws NumberFormatException {
        int n = (string = string.trim()).indexOf(46);
        if (n != -1) {
            String[] stringArray = TextUtil.split((String)string, (char)'.');
            if (stringArray.length > 2) {
                throw new NumberFormatException("Coordinate has more than one decimal point: " + string);
            }
            int n2 = Integer.parseInt(stringArray[0]);
            boolean bl = stringArray[0].indexOf("-") != -1;
            String string2 = stringArray[1].substring(0, Math.min(6, stringArray[1].length()));
            if (string2.length() == 0 || string2.charAt(0) < '0' || string2.charAt(0) > '9') {
                throw new NumberFormatException("Invalid fractional part in \"" + string + "\"");
            }
            string2 = TextUtil.pad((String)string2, (int)6, (char)'0');
            int n3 = Integer.parseInt(string2);
            return n2 * 1000000 + n3 * (bl ? -1 : 1);
        }
        return Integer.parseInt(string) * 1000000;
    }

    public MapPoint pointDegreeOffset(int n, int n2) {
        int n3 = this.latitudeE6 + n;
        int n4 = this.longitudeE6 + n2;
        int n5 = this.pixelCoordX;
        int n6 = this.pixelCoordY;
        if (n != 0) {
            n6 = MapPoint.getYPixelFromLat(n3, PIXEL_COORDS_ZOOM);
        }
        if (n2 != 0) {
            n5 = MapPoint.getXPixelFromLon(n4, PIXEL_COORDS_ZOOM);
        }
        return new MapPoint(n5, n6, 22, n3, n4);
    }

    public MapPoint pixelOffset(int n, int n2, Zoom zoom) {
        int n3 = zoom.changePixelsToTargetZoomlevel(n, 22) + this.pixelCoordX;
        int n4 = zoom.changePixelsToTargetZoomlevel(n2, 22) + this.pixelCoordY;
        int n5 = this.latitudeE6;
        if (n2 != 0) {
            n5 = MapPoint.getLatitudeFromY(n4, PIXEL_COORDS_ZOOM);
        }
        int n6 = this.longitudeE6;
        if (n != 0) {
            n6 += (int)((long)n * 360000000L / (long)zoom.getEquatorPixels());
        }
        return new MapPoint(n3, n4, 22, n5, n6);
    }

    private static int mercatorToPixelsTimesTen(int n, Zoom zoom) {
        return (int)((long)n * (long)zoom.getEquatorPixels() * 10L / 360000000L);
    }

    private static int getMercatorIndex(int n) {
        return Math.abs(n) / 1000000 + 1;
    }

    private static int pixelsToMercator(int n, Zoom zoom) {
        return (int)((long)n * 1000000000L / (long)zoom.getEquatorPixels());
    }

    public long distanceSquared(MapPoint mapPoint) {
        return (long)(this.latitudeE6 - mapPoint.latitudeE6) * (long)(this.latitudeE6 - mapPoint.latitudeE6) / 100L + (long)(this.longitudeE6 - mapPoint.longitudeE6) * (long)(this.longitudeE6 - mapPoint.longitudeE6) / 100L;
    }

    public long distanceSquaredMercator(MapPoint mapPoint) {
        long l = Math.abs((long)(this.latitudeE6 - mapPoint.latitudeE6));
        long l2 = Math.abs((long)(this.longitudeE6 - mapPoint.longitudeE6));
        l2 = l2 > 180000000L ? 360000000L - l2 : l2;
        int n = (Math.abs(this.latitudeE6) + Math.abs(mapPoint.latitudeE6)) / 2000000;
        l2 = l2 * (long)MathUtil.cos((int)n) / 250L;
        return MapPoint.microDegreesToMeters(l) * MapPoint.microDegreesToMeters(l) + MapPoint.microDegreesToMeters(l2) * MapPoint.microDegreesToMeters(l2);
    }

    private static long microDegreesToMeters(long l) {
        return l * 4L / 36L;
    }

    public long metersToLongitudeMicroDegrees(long l) {
        return MapPoint.metersToLatitudeMicroDegrees(l) * 250L / (long)MathUtil.cos((int)(Math.abs(this.latitudeE6) / 1000000));
    }

    public static long metersToLatitudeMicroDegrees(long l) {
        return l * 36L / 4L;
    }

    public long pixelDistanceSquared(MapPoint mapPoint, Zoom zoom) {
        int n = mapPoint.getXPixel(zoom) - this.getXPixel(zoom);
        int n2 = mapPoint.getYPixel(zoom) - this.getYPixel(zoom);
        return (long)n * (long)n + (long)n2 * (long)n2;
    }

    public static void writePoint(MapPoint mapPoint, DataOutput dataOutput) throws IOException {
        if (mapPoint != null) {
            mapPoint.writePoint(dataOutput);
        } else {
            dataOutput.writeInt(0);
            dataOutput.writeInt(0);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        MapPoint.writePoint(this, dataOutput);
    }

    public MapPoint getDefiningPoint() {
        return this;
    }

    public static MapPoint readPoint(DataInput dataInput) throws IOException {
        return new MapPoint(dataInput.readInt(), dataInput.readInt());
    }

    public static MapPoint getMapPointFromXY(int n, int n2, int n3) {
        return new MapPoint(n, n2, n3);
    }

    private void writePoint(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.latitudeE6);
        dataOutput.writeInt(this.longitudeE6);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapPoint)) {
            return false;
        }
        MapPoint mapPoint = (MapPoint)object;
        return this.latitudeE6 == mapPoint.latitudeE6 && this.longitudeE6 == mapPoint.longitudeE6 || this.pixelCoordX == mapPoint.pixelCoordX && this.pixelCoordY == mapPoint.pixelCoordY;
    }

    public int hashCode() {
        int n = this.latitudeE6;
        n = 29 * n + this.longitudeE6;
        return n;
    }

    static {
        mercatorValues = null;
        reverseMercatorValues = null;
        PIXEL_COORDS_ZOOM = Zoom.getZoom(22);
    }
}

