/*
 * Decompiled with CFR 0.152.
 */
package com.google.image.compression.jpeg;

import com.google.image.compression.jpeg.AnalyzeJpegHeader;
import com.google.image.compression.jpeg.GenerateJpegHeader;
import com.google.image.compression.jpeg.JpegHeaderParams;

public class JpegUtil {
    public static final int QUALITY_ALGORITHM_JAVAX_IMAGEIO = 0;
    public static final int QUALITY_ALGORITHM_LIBJPEG = 1;
    private static final byte[][] JPEG_QUANT_TABLES = new byte[][]{{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99}, {17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99}};
    public static final int QUANT_TYPE_LUMINANCE = 0;
    public static final int QUANT_TYPE_CHROMINANCE = 1;
    private static final int[] imageIoScaleFactor = new int[]{-1, 1677721601, 838860801, 559240577, 0x19000001, 0x14000001, 279620289, 239674513, 209715201, 186413505, 0xA000001, 152520145, 139810145, 129055513, 119837257, 0x6AAAAA9, 104857601, 0x5E1E1E1, 93206753, 88301137, 0x5000001, 79891505, 76260073, 72944417, 69905073, 0x4000001, 64527757, 62137837, 59918629, 57852473, 0x3555555, 54120053, 52428801, 50840049, 49344753, 47934905, 46603377, 45343829, 44150569, 43018505, 41943041, 40920041, 39945753, 39016781, 38130037, 37282705, 36472209, 35696205, 34952537, 34239217, 0x2000001, 32883345, 32212257, 31541169, 30870077, 0x1CCCCCD, 29527901, 28856813, 28185725, 27514637, 0x1999999, 26172457, 25501369, 24830281, 24159193, 0x1666669, 22817013, 22145925, 21474837, 20803749, 0x1333335, 19461573, 18790481, 18119393, 17448305, 0x1000001, 16106129, 15435041, 14763953, 14092861, 0xCCCCCD, 12750685, 12079597, 11408509, 10737421, 0x999999, 9395241, 8724153, 8053065, 7381977, 0x666669, 6039797, 5368709, 4697621, 4026533, 0x333335, 2684357, 2013265, 1342177, 671089, 1};
    private static final int IMAGE_IO_SCALE = 0x1000000;

    private JpegUtil() {
    }

    public static byte getQuantizationTableEntry(int n, int n2) {
        return JPEG_QUANT_TABLES[n][n2];
    }

    public static byte getScaledQuantizationFactor(int n, int n2, int n3) {
        int n4;
        switch (n3) {
            case 0: {
                if (n == 99 && n2 == 36) {
                    n4 = 138;
                    break;
                }
                n4 = (int)(((long)n * (long)imageIoScaleFactor[n2] / 0x1000000L + 1L) / 2L);
                break;
            }
            case 1: {
                int n5 = n2 < 50 ? Math.min(5000 / n2, 5000) : Math.max(200 - 2 * n2, 0);
                n4 = (n * n5 + 50) / 100;
                break;
            }
            default: {
                throw new IllegalArgumentException("qualityAlgorithm");
            }
        }
        if (n4 < 1) {
            n4 = 1;
        } else if (n4 > 255) {
            n4 = 255;
        }
        return (byte)n4;
    }

    public static synchronized byte[] getQuantTable(int n, int n2, int n3) {
        int n4 = 154 * n + 77 * n3 + (n2 - 24);
        byte[] byArray = new byte[64];
        byte[] byArray2 = JPEG_QUANT_TABLES[n];
        for (int i = 0; i < 64; ++i) {
            byArray[i] = JpegUtil.getScaledQuantizationFactor(byArray2[i] & 0xFF, n2, n3);
        }
        return byArray;
    }

    static void prependStandardHeader(byte[] byArray, int n, int n2, byte[] byArray2, int n3, JpegHeaderParams jpegHeaderParams) {
        int n4 = jpegHeaderParams.getVariant();
        int n5 = jpegHeaderParams.getWidth();
        int n6 = jpegHeaderParams.getHeight();
        int n7 = jpegHeaderParams.getQuality();
        int n8 = jpegHeaderParams.getQualityAlgorithm();
        if (n4 != 0) {
            throw new IllegalArgumentException("variant");
        }
        int n9 = GenerateJpegHeader.getHeaderLength(n4);
        System.arraycopy(byArray, n, byArray2, n3 + n9, n2);
        GenerateJpegHeader.generate(byArray2, n3, n4, n5, n6, n7, n8);
    }

    public static byte[] compactJpeg(byte[] byArray, int n, int n2) {
        JpegHeaderParams jpegHeaderParams = null;
        try {
            jpegHeaderParams = AnalyzeJpegHeader.analyze(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        int n3 = jpegHeaderParams.getWidth();
        int n4 = jpegHeaderParams.getHeight();
        int n5 = jpegHeaderParams.getHeaderLength();
        byte[] byArray3 = new byte[n2 - n5 + 11];
        byArray3[0] = 67;
        byArray3[1] = 74;
        byArray3[2] = 80;
        byArray3[3] = 71;
        byArray3[4] = (byte)jpegHeaderParams.getVariant();
        byArray3[5] = (byte)(n3 >> 8);
        byArray3[6] = (byte)(n3 & 0xFF);
        byArray3[7] = (byte)(n4 >> 8);
        byArray3[8] = (byte)(n4 & 0xFF);
        byArray3[9] = (byte)jpegHeaderParams.getQuality();
        byArray3[10] = (byte)jpegHeaderParams.getQualityAlgorithm();
        System.arraycopy(byArray, n + n5, byArray3, 11, n2 - n5);
        return byArray3;
    }

    public static byte[] compactJpeg(byte[] byArray) {
        return JpegUtil.compactJpeg(byArray, 0, byArray.length);
    }

    public static byte[] uncompactJpeg(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray[n] == -1 && byArray[n + 1] == -40) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        if (byArray[n] != 67 || byArray[n + 1] != 74 || byArray[n + 2] != 80 || byArray[n + 3] != 71) {
            throw new IllegalArgumentException("Input is not in compact JPEG format");
        }
        int n4 = byArray[n + 4] & 0xFF;
        int n5 = (byArray[n + 5] & 0xFF) << 8 | byArray[n + 6] & 0xFF;
        int n6 = (byArray[n + 7] & 0xFF) << 8 | byArray[n + 8] & 0xFF;
        int n7 = byArray[n + 9] & 0xFF;
        int n8 = byArray[n + 10] & 0xFF;
        try {
            n3 = GenerateJpegHeader.getHeaderLength(n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown variant " + n4);
        }
        byte[] byArray3 = new byte[n3 + n2 - 11];
        JpegHeaderParams jpegHeaderParams = new JpegHeaderParams(n4, n5, n6, n7, n8, n3);
        JpegUtil.prependStandardHeader(byArray, n + 11, n2 - 11, byArray3, 0, jpegHeaderParams);
        return byArray3;
    }

    public static byte[] uncompactJpeg(byte[] byArray) {
        return JpegUtil.uncompactJpeg(byArray, 0, byArray.length);
    }
}

