/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.googlenav.map.Tile;
import com.google.googlenav.map.TrafficReading;
import java.io.DataInput;
import java.io.IOException;

public class TrafficTile {
    static final byte[] TRAFFIC_HEADER = new byte[]{84, 82, 65, 70};
    private final Tile location;
    private TrafficReading[][] readings;
    private long dataTime = Long.MIN_VALUE;
    private long lastAccess;
    private boolean isRightSideDrive = true;

    public TrafficTile(Tile tile) {
        this.location = tile;
    }

    public Tile getLocation() {
        return this.location;
    }

    public boolean isComplete() {
        return this.readings != null;
    }

    public TrafficReading[][] getReadings() {
        return this.readings;
    }

    public long getDataTime() {
        return this.isEmpty() ? Config.getInstance().getClock().relativeTimeMillis() : this.dataTime;
    }

    protected void setData(long l, TrafficReading[][] trafficReadingArray) {
        this.dataTime = l;
        this.readings = trafficReadingArray;
    }

    public int getRoadCount() {
        return this.readings.length;
    }

    public static TrafficTile read(DataInput dataInput) throws IOException {
        TrafficTile trafficTile = new TrafficTile(Tile.read(dataInput));
        short s = dataInput.readShort();
        trafficTile.readData(dataInput);
        return trafficTile;
    }

    public void readData(DataInput dataInput) throws IOException {
        int n;
        byte[] byArray = new byte[4];
        dataInput.readFully(byArray);
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == TRAFFIC_HEADER[n]) continue;
            throw new IOException("Bad traffic header @ " + n + " = " + byArray[n]);
        }
        n = dataInput.readUnsignedShort();
        TrafficReading[][] trafficReadingArray = new TrafficReading[n][];
        for (int i = 0; i < n; ++i) {
            dataInput.readUTF();
            dataInput.readUTF();
            this.isRightSideDrive = dataInput.readBoolean();
            trafficReadingArray[i] = TrafficReading.readPath(this.location, dataInput);
        }
        this.setData(Config.getInstance().getClock().relativeTimeMillis(), trafficReadingArray);
    }

    public void setLastAccess(long l) {
        this.lastAccess = l;
    }

    long getLastAccess() {
        return this.lastAccess;
    }

    public boolean isEmpty() {
        return this.readings != null && this.readings.length == 0;
    }

    public boolean isRightSideDrive() {
        return this.isRightSideDrive;
    }
}

