/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.map.MapPoint;
import com.google.map.Zoom;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Tile {
    private final int xIndex;
    private final int yIndex;
    private final Zoom zoom;
    private final byte flags;
    private final int hashCode;
    public static final int TILE_SIZE = 128;
    public static final byte IS_KEYHOLE = 3;
    public static final byte IS_MAP_ATLAS = 2;
    public static final byte IS_TRAFFIC = 4;
    public static final byte IS_TRAFFIC_PNG = 7;
    public static final byte IS_HYBRID = 6;
    public static final byte ATLAS_TYPE = 2;
    public static final byte IS_CLICKABLE_LAYER = 8;
    static final int SIZE_IN_FLASH = 10;
    private static final int TILE_OBJECT_CACHE_SIZE = 131;
    private static final Tile[] tileObjectCache = new Tile[131];

    public static Tile getTile(byte by, MapPoint mapPoint, Zoom zoom) {
        return Tile.getTile(by, Tile.getXTileIndex(mapPoint, zoom), Tile.getYTileIndex(mapPoint, zoom), zoom);
    }

    public static Tile getTile(byte by, Tile tile) {
        return Tile.getTile(by, tile.xIndex, tile.yIndex, tile.zoom);
    }

    public static Tile getTile(byte by, int n, int n2, Zoom zoom) {
        Tile tile;
        int n3;
        int n4;
        if ((n %= zoom.getEquatorPixels() / 128) < 0) {
            n += zoom.getEquatorPixels() / 128;
        }
        if ((n4 = (n3 = Tile.calculateHashCode(n, n2, zoom, by)) % 131) < 0) {
            n4 += 131;
        }
        if ((tile = tileObjectCache[n4]) != null && tile.flags == by && tile.xIndex == n && tile.yIndex == n2 && tile.zoom == zoom) {
            return tile;
        }
        Tile.tileObjectCache[n4] = tile = new Tile(by, n, n2, zoom, n3);
        return tile;
    }

    private Tile(byte by, int n, int n2, Zoom zoom, int n3) {
        if (zoom == null) {
            throw new IllegalArgumentException("Zoom cannot be null");
        }
        this.flags = by;
        this.xIndex = n;
        this.yIndex = n2;
        this.zoom = zoom;
        this.hashCode = n3;
    }

    public static byte getSatType() {
        return Config.isChinaVersion() ? (byte)3 : 6;
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public Zoom getZoom() {
        return this.zoom;
    }

    public String toString() {
        return "(" + this.xIndex + ", " + this.yIndex + ", " + this.zoom + ")";
    }

    public boolean isKeyhole() {
        return this.flags == 3;
    }

    public boolean isTraffic() {
        return this.flags == 4 || this.flags == 7;
    }

    public boolean isClickableLayer() {
        return this.flags == 8;
    }

    public int getXPixelTopLeft() {
        return this.xIndex * 128;
    }

    public int getYPixelTopLeft() {
        return this.yIndex * 128;
    }

    public Tile getZoomParent(boolean bl) {
        Zoom zoom;
        Tile tile = null;
        Zoom zoom2 = zoom = bl ? Zoom.getZoom(this.zoom.getZoomLevel() - 1) : this.zoom.getNextLowerZoom();
        if (zoom != null) {
            int n = this.xIndex;
            int n2 = this.yIndex;
            if (n < 0) {
                --n;
            }
            if (n2 < 0) {
                --n2;
            }
            tile = Tile.getTile(this.flags, n / 2, n2 / 2, zoom);
        }
        return tile;
    }

    public static Tile read(DataInput dataInput) throws IOException {
        try {
            return Tile.getTile(dataInput.readByte(), dataInput.readInt(), dataInput.readInt(), Zoom.getZoom(dataInput.readUnsignedByte()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.flags);
        dataOutput.writeInt(this.xIndex);
        dataOutput.writeInt(this.yIndex);
        dataOutput.writeByte(this.zoom.getZoomLevel());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Tile)) {
            return false;
        }
        Tile tile = (Tile)object;
        return this.xIndex == tile.xIndex && this.yIndex == tile.yIndex && this.zoom == tile.zoom && this.flags == tile.flags;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    private static int calculateHashCode(int n, int n2, Zoom zoom, int n3) {
        return ((n * 29 + n2) * 29 + zoom.getZoomLevel()) * 4 + n3;
    }

    public boolean notValid() {
        return this.yIndex < 0 || this.yIndex >= this.zoom.getEquatorPixels() / 128;
    }

    public static int getXTileIndex(MapPoint mapPoint, Zoom zoom) {
        return mapPoint.getXPixel(zoom) / 128;
    }

    public static int getYTileIndex(MapPoint mapPoint, Zoom zoom) {
        return mapPoint.getYPixel(zoom) / 128;
    }
}

