/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlenav.map;

import com.google.common.Config;
import com.google.common.Log;
import com.google.common.StaticUtil;
import com.google.common.graphics.GoogleGraphics;
import com.google.common.graphics.GoogleImage;
import com.google.common.graphics.ImageFactory;
import com.google.common.ui.RepaintListener;
import com.google.common.util.RuntimeCheck;
import com.google.common.util.Stopwatch;
import com.google.googlenav.map.Tile;
import com.google.image.compression.jpeg.JpegUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class MapTile
implements Runnable {
    private static volatile Vector tileQueue = null;
    private static final Object queueLock = new Object();
    private static final Object threadWaitLock = new Object();
    private static RepaintListener repaintListener;
    private static volatile boolean stopThread;
    private static volatile boolean decodingThreadRunning;
    private static Boolean needDecodeThread;
    public static final int FORMAT_FLAG_COMPACT_0 = 1;
    public static final int FORMAT_FLAG_COMPACT_3 = 2;
    public static final int FORMAT_FLAG_PNG = 4;
    public static final int FORMAT_FLAG_JPEG = 8;
    public static final int FORMAT_FLAG_GIF = 16;
    public static final int FORMAT_FLAG_CJPG0 = 32;
    public static final int FORMAT_FLAG_TRAFFIC_VECTOR_2 = 128;
    public static final byte TEXT_SIZE_DESKTOP = 0;
    public static final byte TEXT_SIZE_SMALL = 1;
    public static final byte TEXT_SIZE_MEDIUM = 2;
    public static final byte TEXT_SIZE_LARGE = 3;
    static int textSize;
    public static final int MAP_FORMAT_FLAG = 4;
    private static final byte[] CJPG_HEADER;
    private byte[] data;
    private GoogleImage mapImage;
    private boolean hasScaledImage;
    private GoogleImage baseMapImage;
    private long lastAccessTime;
    private long firstPaintTime;
    private long lastPaintTime;
    private int completePaintCount;
    private final Tile location;
    private final boolean isTemp;
    private boolean isPreCached;
    private static GoogleImage loadingImage;
    private static GoogleImage notLoadingImage;
    private static GoogleImage notAvailableImage;
    public static final int BASE_IMAGE_VERSION = 0;
    private int imageVersion;
    static final int FLASH_BLOCK_OVERHEAD = 12;
    private static final long MAX_RUN_TIME = 500L;
    private static final long PAUSE_TIME = 60L;
    private static final long MAX_DECODE_TIME = 70L;
    private static final String IMAGE_RESOURCE_EXT = "png";
    private static final long MAX_OUT_OF_VIEWPORT_TIME = 2000L;

    public MapTile(Tile tile) {
        this(tile, null, false);
    }

    public MapTile(Tile tile, boolean bl) {
        this(tile, null, bl);
    }

    public MapTile(Tile tile, GoogleImage googleImage) {
        this(tile, googleImage, false);
    }

    public MapTile(Tile tile, GoogleImage googleImage, boolean bl) {
        this.location = tile;
        this.isTemp = bl;
        this.mapImage = googleImage;
        this.hasScaledImage = googleImage != null;
        this.lastAccessTime = 0L;
        this.imageVersion = 0;
    }

    public MapTile(Tile tile, byte[] byArray) {
        this.location = tile;
        this.isTemp = false;
        this.lastAccessTime = 0L;
        this.hasScaledImage = false;
        this.setData(byArray);
    }

    public void removeScaledImage() {
        if (this.hasScaledImage) {
            this.hasScaledImage = false;
            this.mapImage = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public Tile getLocation() {
        return this.location;
    }

    public synchronized void compact() {
        if (this.isComplete()) {
            this.mapImage = null;
            this.baseMapImage = null;
            this.imageVersion = 0;
        }
    }

    public boolean isComplete() {
        return this.data != null;
    }

    public boolean hasImage() {
        return this.mapImage != null;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final void setLastAccessTime(long l) {
        this.lastAccessTime = l;
    }

    public void setPaint(long l, long l2) {
        if (this.completePaintCount == 0 && this.lastPaintTime != l2 && l - this.lastPaintTime > 2000L) {
            this.firstPaintTime = 0L;
        }
        if (this.firstPaintTime == 0L) {
            this.firstPaintTime = l;
        }
        this.lastPaintTime = l;
        if (this.hasImage() && !this.hasScaledImage && this.completePaintCount < Integer.MAX_VALUE) {
            ++this.completePaintCount;
        }
    }

    public long getFirstPaintTime() {
        return this.firstPaintTime;
    }

    public long getLastPaintTime() {
        return this.lastPaintTime;
    }

    public int getCompletePaintCount() {
        return this.completePaintCount;
    }

    public int getDataSize() {
        return this.data != null ? this.data.length : 0;
    }

    private synchronized void createImage() {
        if (this.mapImage == null || this.hasScaledImage) {
            Stopwatch stopwatch = new Stopwatch().start();
            if (needDecodeThread == null) {
                System.gc();
                stopwatch.reset().start();
            } else if (needDecodeThread.booleanValue() && !decodingThreadRunning) {
                MapTile.startDecodeThread();
            }
            GoogleImage googleImage = this.data.length == 0 ? MapTile.getNotAvailableImage() : (this.data.length == 3 ? MapTile.getImageFromUnicolor(this.data) : (MapTile.equalBytes(this.data, 0, CJPG_HEADER) ? MapTile.getImageFromCjpg(this.data) : Config.getInstance().getImageFactory().createImage(this.data, 0, this.data.length)));
            this.setImage(googleImage, 0);
            if (needDecodeThread == null) {
                long l = stopwatch.elapsedTime();
                if (l > 70L) {
                    needDecodeThread = Boolean.TRUE;
                    MapTile.startDecodeThread();
                } else {
                    needDecodeThread = Boolean.FALSE;
                }
            }
            this.hasScaledImage = false;
            stopwatch.stop();
            if (stopwatch.elapsedTime() > 30L) {
                // empty if block
            }
        }
    }

    public void setImage(GoogleImage googleImage, int n) {
        if (n == 0) {
            this.baseMapImage = googleImage;
        }
        this.mapImage = googleImage;
        this.imageVersion = n;
    }

    public void restoreBaseImage() {
        this.mapImage = this.baseMapImage;
        this.imageVersion = 0;
    }

    public int getImageVersion() {
        return this.imageVersion;
    }

    public boolean hasScaledImage() {
        return this.hasScaledImage;
    }

    public GoogleImage getImage() {
        return this.getImage(Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleImage getImage(long l) {
        GoogleImage googleImage;
        boolean bl = false;
        MapTile mapTile = this;
        synchronized (mapTile) {
            this.lastAccessTime = l == Long.MIN_VALUE ? Config.getInstance().getClock().currentTimeMillis() : l;
            if ((this.mapImage == null || this.hasScaledImage) && this.isComplete()) {
                if (decodingThreadRunning) {
                    MapTile.queueImageDecoding(this);
                    return this.mapImage == null ? this.getTempImage() : this.mapImage;
                }
                try {
                    this.createImage();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    bl = true;
                }
            }
            if (this.mapImage == null) {
                googleImage = this.getTempImage();
            } else {
                if (this.mapImage.getHeight() != 128 || this.mapImage.getWidth() != 128) {
                    throw new IllegalArgumentException("wrong image size: " + this.mapImage.getWidth() + " " + this.mapImage.getHeight());
                }
                googleImage = this.mapImage;
            }
        }
        if (bl) {
            StaticUtil.handleOutOfMemory();
        }
        return googleImage;
    }

    private GoogleImage getTempImage() {
        if (notLoadingImage == null || loadingImage == null) {
            MapTile.createTempImages();
        }
        return this.isTemp ? notLoadingImage : loadingImage;
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.location.write(dataOutput);
        dataOutput.writeShort(this.data.length);
        dataOutput.write(this.data);
    }

    public static MapTile read(DataInput dataInput) throws IOException {
        Tile tile = Tile.read(dataInput);
        int n = dataInput.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return new MapTile(tile, byArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapTile)) {
            return false;
        }
        MapTile mapTile = (MapTile)object;
        return this.location == null ? mapTile.location == null : this.location.equals(mapTile.location);
    }

    public int hashCode() {
        return this.location != null ? this.location.hashCode() : 0;
    }

    public String toString() {
        return this.location.toString() + (this.data != null ? "B" + this.data.length : "B?");
    }

    public synchronized void setData(byte[] byArray) {
        if (this.isComplete()) {
            throw new RuntimeException("Tile already complete");
        }
        this.imageVersion = 0;
        this.data = byArray;
        this.baseMapImage = null;
        if (!this.hasScaledImage) {
            this.mapImage = null;
        }
        if (decodingThreadRunning) {
            MapTile.queueImageDecoding(this);
        }
    }

    private static void createTempImages() {
        ImageFactory imageFactory = Config.getInstance().getImageFactory();
        try {
            notLoadingImage = loadingImage = imageFactory.createImage("/loading_tile.png");
        }
        catch (IOException iOException) {
            loadingImage = notLoadingImage = imageFactory.createImage(128, 128);
            Log.logThrowable((String)"MAP", (Throwable)iOException);
        }
    }

    private static boolean equalBytes(byte[] byArray, int n, byte[] byArray2) {
        if (byArray.length < n + byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static GoogleImage getNotAvailableImage() {
        ImageFactory imageFactory = Config.getInstance().getImageFactory();
        if (notAvailableImage == null) {
            try {
                notAvailableImage = imageFactory.createImage("/no_tile_128.png");
            }
            catch (IOException iOException) {
                notAvailableImage = imageFactory.createImage(128, 128);
                Log.logThrowable((String)"MAP", (Throwable)iOException);
            }
        }
        return notAvailableImage;
    }

    private static GoogleImage getImageFromUnicolor(byte[] byArray) {
        if (byArray.length < 3) {
            return MapTile.getNotAvailableImage();
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = n << 16 | n2 << 8 | n3;
        ImageFactory imageFactory = Config.getInstance().getImageFactory();
        GoogleImage googleImage = imageFactory.createImage(128, 128);
        GoogleGraphics googleGraphics = googleImage.getGraphics();
        googleGraphics.setColor(n4);
        googleGraphics.fillRect(0, 0, 128, 128);
        return googleImage;
    }

    private static GoogleImage getImageFromCjpg(byte[] byArray) {
        try {
            byArray = JpegUtil.uncompactJpeg(byArray);
            return Config.getInstance().getImageFactory().createImage(byArray, 0, byArray.length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.logThrowable((String)"MAP", (Throwable)illegalArgumentException);
            return MapTile.getNotAvailableImage();
        }
    }

    static void startDecodeThread() {
        if (decodingThreadRunning) {
            return;
        }
        stopThread = false;
        tileQueue = new Vector();
        Thread thread = new Thread((Runnable)new MapTile(null), "MapTile");
        thread.setPriority(Math.min(2, 5));
        thread.start();
        decodingThreadRunning = true;
    }

    static void stopDecodeThread() {
        stopThread = true;
        MapTile.wakeDecodingThread();
    }

    static boolean isDecoding() {
        return decodingThreadRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueImageDecoding(MapTile mapTile) {
        if (!mapTile.isComplete()) {
            throw new IllegalStateException("MapTile is not complete");
        }
        Object object = queueLock;
        synchronized (object) {
            if (!tileQueue.contains(mapTile)) {
                tileQueue.addElement(mapTile);
                MapTile.wakeDecodingThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wakeDecodingThread() {
        Object object = threadWaitLock;
        synchronized (object) {
            threadWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        while (!stopThread) {
            try {
                Object object = threadWaitLock;
                synchronized (object) {
                    if (tileQueue.size() == 0) {
                        try {
                            threadWaitLock.wait();
                            if (!stopThread) {
                                Thread.sleep(60L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (stopThread) continue;
                object = null;
                Object object2 = queueLock;
                synchronized (object2) {
                    if (!stopThread && tileQueue.size() > 0) {
                        object = tileQueue;
                        tileQueue = new Vector();
                    }
                }
                object2 = new Stopwatch().start();
                for (int i = 0; i < ((Vector)object).size() && !stopThread; ++i) {
                    MapTile mapTile = (MapTile)((Vector)object).elementAt(i);
                    mapTile.createImage();
                    if (((Stopwatch)object2).elapsedTime() <= 500L) continue;
                    try {
                        Thread.sleep(60L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ((Stopwatch)object2).reset().start();
                }
                if (repaintListener == null) continue;
                repaintListener.repaint();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                StaticUtil.handleOutOfMemory();
            }
        }
        repaintListener = null;
        decodingThreadRunning = false;
        tileQueue = null;
    }

    public void setIsPreCached(boolean bl) {
        this.isPreCached = bl;
    }

    public boolean getIsPreCached() {
        return this.isPreCached;
    }

    static void setRepaintListener(RepaintListener repaintListener) {
        MapTile.repaintListener = repaintListener;
    }

    static int getDecodeQueueSizeForTests() {
        RuntimeCheck.checkUnitTest();
        return tileQueue != null ? tileQueue.size() : 0;
    }

    static MapTile getDecodeQueueEntryForTests(int n) {
        RuntimeCheck.checkUnitTest();
        return (MapTile)tileQueue.elementAt(n);
    }

    static void setQueueStatusForTests(boolean bl) {
        RuntimeCheck.checkUnitTest();
        needDecodeThread = new Boolean(bl);
        if (bl) {
            MapTile.startDecodeThread();
        } else {
            MapTile.stopDecodeThread();
        }
    }

    public static void setTextSize(int n) {
        textSize = n;
    }

    static {
        stopThread = false;
        decodingThreadRunning = false;
        needDecodeThread = Boolean.FALSE;
        textSize = 1;
        CJPG_HEADER = new byte[]{67, 74, 80, 71};
    }
}

